/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;

public class RealisticBiomeSnowHills
extends RealisticBiomeBase {
    public RealisticBiomeSnowHills(int sub) {
        super(sub, BaseBiomes.baseSnowForest);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        block32: {
            int j1;
            int i1;
            int b;
            int k10;
            int j6;
            int b1;
            block33: {
                block31: {
                    int k1;
                    int j12;
                    int i12;
                    int i8;
                    int i2;
                    int l4;
                    if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
                        new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
                    }
                    int l = 0;
                    while ((float)l < 6.0f * strength) {
                        i12 = chunkX + rand.nextInt(16) + 8;
                        k1 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
                        if (k1 < 95 && (k1 < 64 || rand.nextInt(15) == 0)) {
                            new DecoBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i12, k1, j12);
                        }
                        ++l;
                    }
                    if (rand.nextInt((int)(25.0f / strength)) == 0) {
                        int j16 = chunkX + rand.nextInt(16) + 8;
                        int j18 = rand.nextInt(128);
                        int j21 = chunkY + rand.nextInt(16) + 8;
                        new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
                    }
                    int f23 = 0;
                    while ((float)f23 < 2.0f * strength) {
                        int j15 = chunkX + rand.nextInt(16) + 8;
                        int j17 = rand.nextInt(128);
                        int j20 = chunkY + rand.nextInt(16) + 8;
                        new DecoFlowers(new int[]{9, 0, 3}).func_76484_a(world, rand, j15, j17, j20);
                        ++f23;
                    }
                    int l14 = 0;
                    while ((float)l14 < 3.0f * strength) {
                        int l19 = chunkX + rand.nextInt(16) + 8;
                        int k22 = rand.nextInt(128);
                        int j24 = chunkY + rand.nextInt(16) + 8;
                        new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                        ++l14;
                    }
                    if (this.subID != 0) break block31;
                    int b12 = 0;
                    while ((float)b12 < 2.0f * strength) {
                        WorldGenerator worldgenerator;
                        int k102;
                        int j62 = chunkX + rand.nextInt(16) + 8;
                        int z52 = world.func_72976_f(j62, k102 = chunkY + rand.nextInt(16) + 8);
                        if (z52 < 75) {
                            worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                            worldgenerator.func_76484_a(world, rand, j62, z52, k102);
                        } else if (z52 < 110) {
                            worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                            worldgenerator.func_76484_a(world, rand, j62, z52, k102);
                        }
                        ++b12;
                    }
                    int b2 = 0;
                    while ((float)b2 < 1.0f * strength) {
                        i12 = chunkX + rand.nextInt(16) + 8;
                        k1 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
                        if (k1 < 110) {
                            if (rand.nextInt(10) == 0) {
                                new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i12, k1, j12);
                            } else {
                                new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i12, k1, j12);
                            }
                        }
                        ++b2;
                    }
                    break block32;
                }
                if (this.subID != 1) break block33;
                float l = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f - 0.5f;
                b1 = 0;
                while ((float)b1 < l * 2.0f * strength) {
                    WorldGenerator worldgenerator;
                    j6 = chunkX + rand.nextInt(16) + 8;
                    int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                    if (z52 < 75) {
                        worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    } else if (z52 < 110) {
                        worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                        worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                        worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                    }
                    ++b1;
                }
                if (!(l > -0.4f)) break block32;
                b = 0;
                while ((float)b < 2.0f * strength) {
                    i1 = chunkX + rand.nextInt(16) + 8;
                    int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                    if (k1 < 110) {
                        if (rand.nextInt(10) == 0) {
                            new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        } else {
                            new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        }
                    }
                    ++b;
                }
                break block32;
            }
            float l = perlin.noise2((float)chunkX / 100.0f, (float)chunkY / 100.0f) * 5.0f + 0.5f;
            b1 = 0;
            while ((float)b1 < l * 2.0f * strength) {
                WorldGenerator worldgenerator;
                j6 = chunkX + rand.nextInt(16) + 8;
                int z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 75) {
                    worldgenerator = rand.nextInt(8) != 0 ? new DecoSmallSpruce(1 + rand.nextInt(2)) : new DecoSmallPine(1 + rand.nextInt(3), 2 + rand.nextInt(4));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                } else if (z52 < 110) {
                    worldgenerator = rand.nextInt(4) != 0 ? new DecoSmallSpruce(rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(2), 4 + rand.nextInt(5));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b1;
            }
            if (l > -0.4f) {
                b = 0;
                while ((float)b < 2.0f * strength) {
                    i1 = chunkX + rand.nextInt(16) + 8;
                    int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
                    if (k1 < 110) {
                        if (rand.nextInt(10) == 0) {
                            new DecoShrub(rand.nextInt(5) + 4, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        } else {
                            new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
                        }
                    }
                    ++b;
                }
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float h;
            float f = (h *= (h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 130.0f) > -30.0f ? (h + 30.0f) / 70.0f + 1.0f : 1.0f) > 92.0f ? 92.0f : (h = h < -50.0f ? -50.0f : h);
            if (h > -40.0f) {
                float d = (h + 40.0f) / 2.0f > 8.0f ? 8.0f : (h + 40.0f) / 2.0f;
                h += perlin.noise2((float)x / 25.0f, (float)y / 25.0f) * d;
                if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > -15.0f) {
                    float d2 = (h + 15.0f) / 1.5f > 30.0f ? 30.0f : (h + 15.0f) / 1.5f;
                    h += cell.noise((double)x / 35.0, (double)y / 35.0, 1.0) * d2;
                }
            }
            h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 4.0f;
            return (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) + 120.0f;
        }
        if (this.subID == 1) {
            float h = perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 135.0f;
            h = (h *= h / 32.0f) > 150.0f ? 150.0f : h;
            float bn = 0.0f;
            if (h < 1.0f) {
                bn = 1.0f - h;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn * 1.25f;
                }
                float f = bn = bn > 3.0f ? 3.0f : bn;
            }
            if (h < 3.0f) {
                h += perlin.noise2((float)x / 13.0f, (float)y / 13.0f) * (bn + 3.0f - h) * 0.8f;
            }
            if (h > 10.0f) {
                float d = (h - 10.0f) / 2.0f > 8.0f ? 8.0f : (h - 10.0f) / 2.0f;
                h += perlin.noise2((float)x / 35.0f, (float)y / 35.0f) * d;
                if ((h += perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * d * 0.5f) > 35.0f) {
                    float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                    h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
                }
            }
            if (h > 2.0f) {
                float d = (h - 2.0f) / 2.0f > 4.0f ? 4.0f : (h - 2.0f) / 2.0f;
                h += perlin.noise2((float)x / 28.0f, (float)y / 28.0f) * d;
                h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * (d / 2.0f);
                h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * (d / 2.0f);
            }
            return h + 63.0f - bn;
        }
        float b = 12.0f + perlin.noise2((float)x / 300.0f, (float)y / 300.0f) * 6.0f;
        float h = cell.noise((double)x / 200.0, (double)y / 200.0, 1.0) * b;
        float f = h = (h *= h * 1.5f) > 155.0f ? 155.0f : h;
        if (h > 2.0f) {
            float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
            h += perlin.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            if ((h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
            }
        }
        h += perlin.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return 45.0f + (h += perlin.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f) + b * 2.0f;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        float c = CliffCalculator.calc(x, y, noise);
        int cliff = 0;
        float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
        boolean gravel = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0) {
                if (k < 63) {
                    gravel = true;
                }
                if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                    cliff = 1;
                }
                if (c > 1.4f) {
                    cliff = 2;
                }
                if (c < 0.3f + ((float)k - 80.0f) / 55.0f + p) {
                    cliff = 3;
                }
                if (cliff == 1) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (cliff == 2) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = 9;
                    continue;
                }
                if (cliff == 3) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (k < 63) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                    gravel = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                continue;
            }
            if (depth >= 6) continue;
            if (cliff == 1) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                continue;
            }
            if (cliff == 2) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                metadata[(y * 16 + x) * 256 + k] = 9;
                continue;
            }
            if (cliff == 3) {
                if (depth > 3 && k < 100) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150348_b;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = gravel ? Blocks.field_150351_n : Blocks.field_150346_d;
        }
    }
}

