/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import rwg.biomes.base.BaseBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoShrub;
import rwg.deco.trees.DecoSmallPine;
import rwg.deco.trees.DecoSmallSpruce;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.PerlinNoise;
import rwg.util.SnowheightCalculator;

public class RealisticBiomeTundraPlains
extends RealisticBiomeBase {
    public RealisticBiomeTundraPlains(int sub) {
        super(sub, sub == 0 ? BaseBiomes.baseSnowDesert : BaseBiomes.baseColdPlains);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, PerlinNoise perlin, CellNoise cell, float strength) {
        if (this.subID == 0) {
            int k10;
            int j6;
            int z52;
            int j1;
            int i1;
            int k1;
            if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 69) {
                new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            if (rand.nextInt((int)(1.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 69) {
                new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            }
            if (rand.nextInt((int)(5.0f / strength)) == 0 && (z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 69) {
                DecoSmallSpruce worldgenerator = new DecoSmallSpruce(rand.nextInt(5) == 0 ? 1 : 0);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
        } else {
            int j1;
            int i1;
            int k1;
            int k10;
            int j6;
            int z52;
            int i8;
            int i2;
            int l4;
            if (rand.nextInt((int)(15.0f / strength)) == 0 && (l4 = world.func_72976_f(i2 = chunkX + rand.nextInt(16) + 8, i8 = chunkY + rand.nextInt(16) + 8)) > 63 && l4 < 105) {
                new WorldGenLakes(Blocks.field_150355_j).func_76484_a(world, rand, i2, l4, i8);
            }
            int l = 0;
            while ((float)l < 3.0f * strength) {
                int j12;
                int i12 = chunkX + rand.nextInt(16) + 8;
                int k12 = world.func_72976_f(i12, j12 = chunkY + rand.nextInt(16) + 8);
                if (k12 < 85 && (k12 < 64 || rand.nextInt(5) == 0)) {
                    new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i12, k12, j12);
                }
                ++l;
            }
            if (this.subID == 2) {
                if (rand.nextInt((int)(1.0f / strength)) == 0 && ((z52 = world.func_72976_f(j6 = chunkX + rand.nextInt(16) + 8, k10 = chunkY + rand.nextInt(16) + 8)) < 66 || rand.nextInt(2) == 0)) {
                    Object worldgenerator = rand.nextBoolean() ? new WorldGenTrees(false) : new DecoSmallPine(1 + rand.nextInt(2), 4 + rand.nextInt(4));
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
            } else if (rand.nextInt((int)(2.0f / strength)) == 0) {
                j6 = chunkX + rand.nextInt(16) + 8;
                k10 = chunkY + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10);
                WorldGenerator worldgenerator = rand.nextInt(7) == 0 ? new DecoSmallSpruce(0 + rand.nextInt(2)) : new DecoSmallPine(2 + rand.nextInt(3), 4 + rand.nextInt(4), rand.nextInt(2));
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt((int)(1.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 90) {
                new DecoShrub(rand.nextInt(4) + 1, rand.nextInt(2), rand.nextInt(2)).func_76484_a(world, rand, i1, k1, j1);
            }
            if (rand.nextInt((int)(25.0f / strength)) == 0) {
                int j16 = chunkX + rand.nextInt(16) + 8;
                int j18 = rand.nextInt(100);
                int j21 = chunkY + rand.nextInt(16) + 8;
                new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
            }
            int f23 = 0;
            while ((float)f23 < 2.0f * strength) {
                int j15 = chunkX + rand.nextInt(16) + 8;
                int j17 = rand.nextInt(128);
                int j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{0}).func_76484_a(world, rand, j15, j17, j20);
                ++f23;
            }
            int l14 = 0;
            while ((float)l14 < 4.0f * strength) {
                int l19 = chunkX + rand.nextInt(16) + 8;
                int k22 = rand.nextInt(128);
                int j24 = chunkY + rand.nextInt(16) + 8;
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                ++l14;
            }
        }
    }

    @Override
    public float rNoise(PerlinNoise perlin, CellNoise cell, int x, int y, float ocean, float border) {
        if (this.subID == 0) {
            float st = (perlin.noise2((float)x / 160.0f, (float)y / 160.0f) + 0.38f) * 35.0f;
            st = st < 0.2f ? 0.2f : st;
            float h = perlin.noise2((float)x / 60.0f, (float)y / 60.0f) * st * 2.0f;
            h = h > 0.0f ? -h : h;
            h += st;
            h *= h / 50.0f;
            h += st;
            float b = 0.0f;
            b += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 3.2f;
            h = b > h ? (b += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * 1.35f) : (h -= 13.0f);
            return 65.0f + h;
        }
        if (this.subID == 1) {
            float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 42.0f;
            h = h > 5.0f ? 5.0f : h;
            h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
            h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
            return 67.0f + h;
        }
        float h = perlin.noise2((float)x / 200.0f, (float)y / 200.0f) * 42.0f;
        h = h > 5.0f ? 5.0f : h;
        h += perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * (12.0f - h) * 0.4f;
        h += perlin.noise2((float)x / 15.0f, (float)y / 15.0f) * (12.0f - h) * 0.15f;
        return 67.0f + h;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, Random rand, PerlinNoise perlin, CellNoise cell, float[] noise) {
        if (this.subID == 0) {
            float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = CliffCalculator.calc(x, y, noise);
            boolean grass = false;
            boolean snow = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b || ++depth >= 5) continue;
                if (depth == 0) {
                    if (depth == 0 && (float)k > 68.0f + perlin.noise2((float)x / 10.0f, (float)y / 10.0f) * 5.0f && k < 254) {
                        SnowheightCalculator.calc(x, y, k, blocks, metadata, noise);
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                        snow = true;
                        continue;
                    }
                    if (k <= 61) continue;
                    if (perlin.noise2((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
                        metadata[(y * 16 + x) * 256 + k] = 2;
                        continue;
                    }
                    if (p < 0.0f) {
                        grass = true;
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                    continue;
                }
                if (snow) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                    continue;
                }
                if (!grass) continue;
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150346_d;
            }
        } else if (this.subID == 1) {
            float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = CliffCalculator.calc(x, y, noise);
            int cliff = 0;
            boolean gravel = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (k < 63) {
                        gravel = true;
                    }
                    if (p < 0.0f) {
                        cliff = 1;
                    } else if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                        cliff = 1;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < 0.3f + ((float)k - 100.0f) / 50.0f + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                        continue;
                    }
                    if (cliff == 3) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                        continue;
                    }
                    if (k < 63 || k < 64 && this.subID == 0 && perlin.noise2((float)i / 6.0f, (float)j / 6.0f) < 0.0f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                        gravel = true;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                blocks[(y * 16 + x) * 256 + k] = cliff == 1 ? Blocks.field_150348_b : (cliff == 3 ? Blocks.field_150433_aE : (gravel ? Blocks.field_150351_n : Blocks.field_150346_d));
            }
        } else {
            float p = perlin.noise2((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = CliffCalculator.calc(x, y, noise);
            int cliff = 0;
            boolean gravel = false;
            for (int k = 255; k > -1; --k) {
                Block b = blocks[(y * 16 + x) * 256 + k];
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (k < 63) {
                        gravel = true;
                    }
                    if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                        cliff = 1;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < 0.3f + ((float)k - 100.0f) / 50.0f + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? Blocks.field_150347_e : Blocks.field_150348_b;
                        continue;
                    }
                    if (cliff == 3) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                        continue;
                    }
                    if (k < 63 || k < 64 && this.subID == 0 && perlin.noise2((float)i / 6.0f, (float)j / 6.0f) < 0.0f) {
                        blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
                        gravel = true;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150349_c;
                    continue;
                }
                if (depth >= 6) continue;
                blocks[(y * 16 + x) * 256 + k] = cliff == 1 ? Blocks.field_150348_b : (cliff == 3 ? Blocks.field_150433_aE : (gravel ? Blocks.field_150351_n : Blocks.field_150346_d));
            }
        }
    }
}

