/*
 * Decompiled with CFR 0.152.
 */
package rwg.deco.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DecoLargePine
extends WorldGenerator {
    private int startHeight;
    private int treeSize;

    public DecoLargePine(int start, int s) {
        this.startHeight = start;
        this.treeSize = s;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int i;
        int startY = y;
        Block g = world.func_147439_a(x, y - 1, z);
        if (g != Blocks.field_150349_c && g != Blocks.field_150346_d) {
            return false;
        }
        this.buildTrunk(world, rand, x + 1, y, z);
        this.buildTrunk(world, rand, x - 1, y, z);
        this.buildTrunk(world, rand, x, y, z + 1);
        this.buildTrunk(world, rand, x, y, z - 1);
        for (i = 0; i < this.startHeight; ++i) {
            world.func_147465_d(x, y, z, Blocks.field_150364_r, 0, 0);
            if (i > 5 && rand.nextInt(7) == 0) {
                int dX = -1 + rand.nextInt(3);
                int dZ = -1 + rand.nextInt(3);
                if (dX == 0 && dZ == 0) {
                    dX = -1 + rand.nextInt(3);
                    dZ = -1 + rand.nextInt(3);
                }
                this.buildBranch(world, rand, x, y, z, dX, dZ, 1, 1);
            }
            ++y;
        }
        int pX = 0;
        int pZ = 0;
        for (i = 0; i < this.treeSize; ++i) {
            if (rand.nextInt(i < this.treeSize - 12 && i > 2 ? 2 : 1) == 0 && i < this.treeSize - 2) {
                int dX = -1 + rand.nextInt(3);
                int dZ = -1 + rand.nextInt(3);
                if (dX == 0 && dZ == 0) {
                    dX = -1 + rand.nextInt(3);
                    dZ = -1 + rand.nextInt(3);
                }
                if (pX == dX && rand.nextBoolean()) {
                    dX = -dX;
                }
                if (pZ == dZ && rand.nextBoolean()) {
                    dZ = -dZ;
                }
                pX = dX;
                pZ = dZ;
                this.buildBranch(world, rand, x, y, z, dX, dZ, i < this.treeSize - 12 && i > 3 ? 3 : (i < this.treeSize - 8 ? 2 : 1), i < this.treeSize - 5 ? 2 : 1);
            }
            world.func_147465_d(x, y, z, Blocks.field_150364_r, 0, 0);
            if (i < this.treeSize - 2) {
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x, y, z + 1);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x, y, z - 1);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x + 1, y, z);
                }
                if (rand.nextBoolean()) {
                    this.buildLeaves(world, x - 1, y, z);
                }
            }
            ++y;
        }
        this.buildLeaves(world, x, y - 1, z + 1);
        this.buildLeaves(world, x, y - 1, z - 1);
        this.buildLeaves(world, x + 1, y - 1, z);
        this.buildLeaves(world, x - 1, y - 1, z);
        this.buildLeaves(world, x, y, z);
        return true;
    }

    public void buildBranch(World world, Random rand, int x, int y, int z, int dX, int dZ, int logLength, int leaveSize) {
        if (logLength == 3 && Math.abs(dX) + Math.abs(dZ) == 2) {
            --logLength;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) >= leaveSize + 1) continue;
                    this.buildLeaves(world, x + i + dX * logLength, y + k, z + j + dZ * logLength);
                }
            }
        }
        for (int m = 1; m <= logLength; ++m) {
            world.func_147465_d(x + dX * m, y, z + dZ * m, Blocks.field_150364_r, 0, 0);
        }
    }

    public void buildLeaves(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.func_149688_o() == Material.field_151579_a) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150362_t, 0, 0);
        }
    }

    public void buildTrunk(World world, Random rand, int x, int y, int z) {
        int h = (int)Math.ceil((float)this.startHeight / 4.0f);
        h += rand.nextInt(h * 2);
        for (int i = -1; i < h; ++i) {
            world.func_147465_d(x, y + i, z, Blocks.field_150364_r, 12, 0);
        }
    }
}

