/*
 * Decompiled with CFR 0.152.
 */
package rwg.deco.trees;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DecoPalmTree
extends WorldGenerator {
    private static int leavesLength = 133;
    private static int[] leaves = new int[]{1, 0, 0, 2, 0, 0, 3, -1, 0, 3, -2, 0, -1, 0, 0, -2, 0, 0, -3, -1, 0, -3, -2, 0, 0, 0, 1, 0, 0, 2, 0, -1, 3, 0, -2, 3, 0, 0, -1, 0, 0, -2, 0, -1, -3, 0, -2, -3, 0, 1, 0, 1, 1, 1, -1, 1, -1, -1, 1, 1, 1, 1, -1, 1, 2, 0, -1, 2, 0, 0, 2, 1, 0, 2, -1, 2, 3, 0, 3, 3, 0, 4, 2, 0, -2, 3, 0, -3, 3, 0, -4, 2, 0, 0, 3, 2, 0, 3, 3, 0, 2, 4, 0, 3, -2, 0, 3, -3, 0, 2, -4, 2, 2, -2, -2, 2, 2, -2, 2, -2, 2, 2, 2, 3, 2, -3, -3, 2, 3, -3, 2, -3, 3, 2, 3};
    private static int cocoasLength = 16;
    private static int[] cocoas = new int[]{2, 0, -2, 1, 1, 1, -2, 0, 0, 0, -2, -1, 3, -1, -2, 0};
    private int height;
    private boolean sand;

    public DecoPalmTree(int h) {
        this(h, true);
    }

    public DecoPalmTree(int h, boolean s) {
        this.height = h;
        this.sand = s;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        if (b != Blocks.field_150349_c && b != Blocks.field_150346_d && b != Blocks.field_150354_m || b == Blocks.field_150354_m && !this.sand) {
            return false;
        }
        this.createTrunk(world, rand, x, y, z);
        for (int i = 0; i <= this.height; ++i) {
            world.func_147465_d(x, y + i, z, Blocks.field_150364_r, 3, 0);
        }
        for (int j = 0; j < leavesLength; j += 3) {
            world.func_147465_d(x + leaves[j], y + this.height + leaves[j + 1], z + leaves[j + 2], (Block)Blocks.field_150362_t, 3, 0);
        }
        for (int k = 0; k < cocoasLength; k += 4) {
            if (rand.nextInt(20) != 0) continue;
            world.func_147465_d(x + cocoas[k + 1], y + this.height + cocoas[k + 2], z + cocoas[k + 3], Blocks.field_150375_by, cocoas[k + 0] + 8, 0);
        }
        return true;
    }

    private void createTrunk(World world, Random rand, int x, int y, int z) {
        int[] pos = new int[]{0, 0, 1, 0, 0, 1, -1, 0, 0, -1};
        for (int t = 0; t < 5; ++t) {
            for (int sh = rand.nextInt(3) + y; sh > y - 3 && world.func_147439_a(x + pos[t * 2], sh, z + pos[t * 2 + 1]) != Blocks.field_150346_d; --sh) {
                world.func_147465_d(x + pos[t * 2], sh, z + pos[t * 2 + 1], Blocks.field_150364_r, 15, 0);
            }
        }
    }
}

