/*
 * Decompiled with CFR 0.152.
 */
package rwg.map;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenAncientVillage {
    private Random rand = new Random();

    public void generate(IChunkProvider provider, World world, int chunkX, int chunkY, Block[] blocks) {
        int range = 3;
        this.rand.setSeed(world.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkY - range; j <= chunkY + range; ++j) {
                this.rand.setSeed((long)i * i1 + (long)j * j1 ^ world.func_72905_C());
                if (!this.recursiveGenerate(world, i, j, chunkX, chunkY, blocks)) continue;
                return;
            }
        }
    }

    public boolean recursiveGenerate(World world, int baseX, int baseY, int chunkX, int chunkY, Block[] block) {
        if (this.rand.nextInt(80) == 0) {
            long i1 = this.rand.nextLong() / 2L * 2L + 1L;
            long j1 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkX * i1 + (long)chunkY * j1 ^ world.func_72905_C());
            this.build(world, block, Math.max(Math.abs(baseX - chunkX), Math.abs(baseY - chunkY)));
            return true;
        }
        return false;
    }

    public void build(World world, Block[] block, int dis) {
        int j;
        int height;
        int i;
        int y;
        for (y = 120; y > 49; --y) {
            if (block[this.coordstoArray(8, y - 1, 8)] != Blocks.field_150350_a) {
                if (y <= 118) break;
                return;
            }
            if (y >= 51) continue;
            return;
        }
        int sizeX = this.rand.nextInt(5) + 10 - dis * 2;
        int sizeZ = this.rand.nextInt(5) + 10 - dis * 2;
        int startX = this.rand.nextInt(2) + dis;
        int startZ = this.rand.nextInt(2) + dis;
        for (i = startX; i < startX + sizeX; ++i) {
            if (block[this.coordstoArray(startX + i, y - 2, startZ)] != Blocks.field_150350_a) {
                height = this.rand.nextInt(4);
                for (j = 0; j < height; ++j) {
                    block[this.coordstoArray((int)(startX + i), (int)(y + j - 1), (int)startZ)] = Blocks.field_150341_Y;
                }
            }
            if (block[this.coordstoArray(startX + i, y - 2, startZ + sizeZ)] == Blocks.field_150350_a) continue;
            height = this.rand.nextInt(4);
            for (j = 0; j < height; ++j) {
                block[this.coordstoArray((int)(startX + i), (int)(y + j - 1), (int)(startZ + sizeZ))] = Blocks.field_150341_Y;
            }
        }
        for (i = startZ + 1; i < startZ + sizeZ - 1; ++i) {
            if (block[this.coordstoArray(startX, y - 2, startZ + i)] != Blocks.field_150350_a) {
                height = this.rand.nextInt(4);
                for (j = 0; j < height; ++j) {
                    block[this.coordstoArray((int)startX, (int)(y + j - 1), (int)(startZ + i))] = Blocks.field_150341_Y;
                }
            }
            if (block[this.coordstoArray(startX + sizeX, y - 2, startZ + i)] == Blocks.field_150350_a) continue;
            height = this.rand.nextInt(4);
            for (j = 0; j < height; ++j) {
                block[this.coordstoArray((int)(startX + sizeX), (int)(y + j - 1), (int)(startZ + i))] = Blocks.field_150341_Y;
            }
        }
    }

    public int coordstoArray(int x, int y, int z) {
        return (z * 16 + x) * 256 + y;
    }
}

