/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.client.saving;

import vazkii.gencreator.helper.BoundingBox;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.helper.StructureData;

public class TemporaryStructureData
extends StructureData {
    public BoundingBox boundingBox;
    public int currentX;
    public int currentY;
    public int currentZ;

    public TemporaryStructureData(BoundingBox box) {
        this.boundingBox = box;
        this.currentZ = 0;
        this.currentY = 0;
        this.currentX = 0;
        this.blockData = new FullBlockData[box.getXSize()][box.getYSize()][box.getZSize()];
    }

    public FullBlockData nextBlock() {
        FullBlockData blockData = this.boundingBox.getBlockData(this.currentX, this.currentY, this.currentZ);
        return blockData;
    }

    public boolean iterateLocation() {
        ++this.currentX;
        if (this.currentX >= this.boundingBox.getXSize()) {
            this.currentX = 0;
            ++this.currentZ;
            if (this.currentZ >= this.boundingBox.getZSize()) {
                this.currentZ = 0;
                ++this.currentY;
                if (this.currentY >= this.boundingBox.getYSize()) {
                    return false;
                }
            }
        }
        return true;
    }
}

