/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.core;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.gencreator.DataStorage;
import vazkii.gencreator.GenCreator;
import vazkii.gencreator.helper.IOHelper;
import vazkii.gencreator.helper.StructureData;
import vazkii.gencreator.helper.StructureReader;
import vazkii.gencreator.world.GCWorldGenerator;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        this.findAndCreateFolder(event);
    }

    public void init(FMLInitializationEvent event) {
        this.initKeybind(event);
        this.initTickHandlers(event);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GCWorldGenerator(), (int)9001);
        for (File f : GenCreator.dataDirectory.listFiles()) {
            if (!f.getName().endsWith(".dat")) continue;
            this.loadStructureFile(f);
        }
    }

    public void initKeybind(FMLInitializationEvent event) {
    }

    public void initTickHandlers(FMLInitializationEvent event) {
    }

    public void loadStructureFile(File f) {
        NBTTagCompound cmp = IOHelper.getTagCompoundInFile(f);
        StructureReader reader = new StructureReader(cmp);
        StructureData data = reader.getStructureData();
        DataStorage.structures.add(data);
    }

    public void findAndCreateFolder(FMLPreInitializationEvent event) {
        GenCreator.dataDirectory = new File(event.getModConfigurationDirectory(), "GenCreator");
        if (!GenCreator.dataDirectory.exists()) {
            GenCreator.dataDirectory.mkdir();
        }
        if (!GenCreator.dataDirectory.exists()) {
            throw new RuntimeException("Folder " + GenCreator.dataDirectory.getAbsolutePath() + " could not be created!");
        }
    }
}

