/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.helper;

import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import vazkii.gencreator.helper.FullBlockData;

public class BoundingBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public World world;

    private BoundingBox(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.world = world;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox copy() {
        return new BoundingBox(this.world, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public static BoundingBox createNew(World world, ChunkCoordinates point1, ChunkCoordinates point2) {
        int minX = point1.field_71574_a > point2.field_71574_a ? point2.field_71574_a : point1.field_71574_a;
        int maxX = point1.field_71574_a > point2.field_71574_a ? point1.field_71574_a : point2.field_71574_a;
        int minY = point1.field_71572_b > point2.field_71572_b ? point2.field_71572_b : point1.field_71572_b;
        int maxY = point1.field_71572_b > point2.field_71572_b ? point1.field_71572_b : point2.field_71572_b;
        int minZ = point1.field_71573_c > point2.field_71573_c ? point2.field_71573_c : point1.field_71573_c;
        int maxZ = point1.field_71573_c > point2.field_71573_c ? point1.field_71573_c : point2.field_71573_c;
        return new BoundingBox(world, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getXSize() {
        return this.maxX - this.minX + 1;
    }

    public int getYSize() {
        return this.maxY - this.minY + 1;
    }

    public int getZSize() {
        return this.maxZ - this.minZ + 1;
    }

    public FullBlockData getBlockData(int x, int y, int z) {
        return new FullBlockData(this.world, this.minX + x, this.minY + y, this.minZ + z);
    }

    public float getLightLevel(int x, int y, int z) {
        return this.world.func_72957_l(this.minX + x, this.minY + y, this.minZ + z);
    }
}

