/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.helper;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.biome.BiomeGenBase;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.helper.StructureData;
import vazkii.gencreator.lib.ObfuscationKeys;

public class StructureReader {
    StructureData data = new StructureData();

    public StructureReader(NBTTagCompound cmp) {
        this.data.ignoreAirSpaces = cmp.func_74767_n("ignoreAirSpaces");
        this.data.randomizeStoneBricks = cmp.func_74767_n("randomizeStoneBricks");
        this.data.rarity = cmp.func_74762_e("rarity");
        this.data.validBiomes = this.getValidBiomes(cmp.func_74779_i("validBiomes"));
        int xSize = cmp.func_74762_e("xSize");
        int ySize = cmp.func_74762_e("ySize");
        int zSize = cmp.func_74762_e("zSize");
        this.data.blockData = new FullBlockData[xSize][ySize][zSize];
        NBTTagCompound blocksCmp = cmp.func_74775_l("blockData");
        Set keys = blocksCmp.func_150296_c();
        for (String key : keys) {
            FullBlockData blockData;
            NBTBase tag = blocksCmp.func_74781_a(key);
            if (!(tag instanceof NBTTagCompound)) continue;
            NBTTagCompound blockCmp = (NBTTagCompound)tag;
            ChunkCoordinates coords = this.getCoordinates(key);
            this.data.blockData[coords.field_71574_a][coords.field_71572_b][coords.field_71573_c] = blockData = FullBlockData.constructFromNBT(blockCmp);
        }
    }

    public StructureData getStructureData() {
        return this.data;
    }

    private ChunkCoordinates getCoordinates(String str) {
        String[] values = str.split(",");
        int x = Integer.parseInt(values[0]);
        int y = Integer.parseInt(values[1]);
        int z = Integer.parseInt(values[2]);
        return new ChunkCoordinates(x, y, z);
    }

    private List<BiomeGenBase> getValidBiomes(String str) {
        String[] values;
        ArrayList<BiomeGenBase> list = new ArrayList<BiomeGenBase>();
        for (String s : values = str.split(",")) {
            int i = Integer.parseInt(s);
            list.add(((BiomeGenBase[])ReflectionHelper.getPrivateValue(BiomeGenBase.class, null, (String[])ObfuscationKeys.biomeList))[i]);
        }
        return list;
    }
}

