/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import vazkii.gencreator.DataStorage;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.helper.StructureData;
import vazkii.gencreator.world.PlacementMethod;
import vazkii.gencreator.world.PlacementMethodAir;
import vazkii.gencreator.world.PlacementMethodChest;
import vazkii.gencreator.world.PlacementMethodStoneBricks;

public class GCWorldGenerator
implements IWorldGenerator {
    private static final PlacementMethod REGULAR = new PlacementMethod();
    private static final PlacementMethod AIR = new PlacementMethodAir();
    private static final PlacementMethod STONE_BRICK = new PlacementMethodStoneBricks();
    private static final PlacementMethod CHEST = new PlacementMethodChest();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int posZ;
        if (!world.func_72912_H().func_76089_r()) {
            return;
        }
        int posX = chunkX * 16 + random.nextInt(16);
        int posY = world.func_72825_h(posX, posZ = chunkZ * 16 + random.nextInt(16));
        if (posY == -1) {
            return;
        }
        for (StructureData data : DataStorage.structures) {
            if (!data.canGenerate(world, random, posX, posY, posZ)) continue;
            this.generateStructure(data, random, world, posX, posY, posZ);
            return;
        }
    }

    public void generateStructure(StructureData data, Random rand, World world, int posX, int posY, int posZ) {
        for (int x = 0; x < data.blockData.length; ++x) {
            for (int y = 0; y < data.blockData[0].length; ++y) {
                for (int z = 0; z < data.blockData[0][0].length; ++z) {
                    int placePosX = posX + x;
                    int placePosY = posY + y - 0;
                    int placePosZ = posZ + z;
                    FullBlockData blockData = data.blockData[x][y][z];
                    this.placeBlock(world, rand, placePosX, placePosY, placePosZ, blockData, data);
                }
            }
        }
    }

    public void placeBlock(World world, Random rand, int x, int y, int z, FullBlockData blockData, StructureData structure) {
        Block block = blockData.block;
        PlacementMethod method = REGULAR;
        if (block == Blocks.field_150350_a) {
            method = AIR;
        }
        if (block == Blocks.field_150417_aV) {
            method = STONE_BRICK;
        }
        if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
            method = CHEST;
        }
        method.place(world, rand, x, y, z, blockData, structure);
    }
}

