/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.client.gui;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.opengl.GL11;
import vazkii.gencreator.DataStorage;
import vazkii.gencreator.client.gui.GuiButtonArrowHorizontal;
import vazkii.gencreator.client.gui.GuiButtonArrowVertical;
import vazkii.gencreator.client.gui.GuiButtonCheckbox;
import vazkii.gencreator.client.gui.GuiButtonInvisible;
import vazkii.gencreator.client.gui.GuiButtonPlusMinus;
import vazkii.gencreator.client.gui.GuiRestrictedTextField;
import vazkii.gencreator.client.saving.TemporaryStructureData;
import vazkii.gencreator.client.saving.WriteStructureThread;
import vazkii.gencreator.helper.BoundingBox;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.lib.ObfuscationKeys;

public class GuiCreator
extends GuiScreen {
    public static final ResourceLocation guiResource = new ResourceLocation("gencreator:textures/creator.png");
    GuiTextField textBox;
    private long ticksElapsed;
    private int rarity = 20;
    List<BiomeGenBase> availableBiomes = new ArrayList<BiomeGenBase>();
    List<BiomeGenBase> chosenBiomes;
    int biomeScrollIndex = 0;
    int chosenBiomeScrollIndex = 0;
    String error = "";
    boolean correct = false;
    private static final RenderBlocks renderBlocks = new RenderBlocks();

    public GuiCreator() {
        for (BiomeGenBase biome : (BiomeGenBase[])ReflectionHelper.getPrivateValue(BiomeGenBase.class, null, (String[])ObfuscationKeys.biomeList)) {
            if (biome == null) continue;
            this.availableBiomes.add(biome);
        }
        this.chosenBiomes = new ArrayList<BiomeGenBase>();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xSize = 176;
        int ySize = 166;
        int xStart = (this.field_146294_l - xSize) / 2;
        int yStart = (this.field_146295_m - ySize) / 2;
        String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_";
        this.textBox = new GuiRestrictedTextField(this.field_146289_q, xStart + 88, yStart + 19, 82, 12, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_");
        this.textBox.func_146193_g(0xDDDDDD);
        this.textBox.func_146185_a(false);
        this.textBox.func_146203_f(15);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonArrowVertical(0, xStart + 84, yStart + 49, false));
        this.field_146292_n.add(new GuiButtonArrowVertical(1, xStart + 160, yStart + 49, true));
        this.field_146292_n.add(new GuiButtonPlusMinus(2, xStart + 125, yStart + 80, false));
        this.field_146292_n.add(new GuiButtonPlusMinus(3, xStart + 145, yStart + 80, true));
        this.field_146292_n.add(new GuiButtonArrowHorizontal(4, xStart + 243, yStart + 49, false));
        this.field_146292_n.add(new GuiButtonArrowHorizontal(5, xStart + 243, yStart + 60, true));
        this.field_146292_n.add(new GuiButtonCheckbox(6, xStart + 156, yStart + 120));
        this.field_146292_n.add(new GuiButtonCheckbox(7, xStart + 156, yStart + 140));
        this.field_146292_n.add(new GuiButtonPlusMinus(8, xStart + 223, yStart + 12, true));
        this.field_146292_n.add(new GuiButtonPlusMinus(9, xStart + 223, yStart + 32, true));
        this.field_146292_n.add(new GuiButtonPlusMinus(10, xStart + 223, yStart + 52, true));
        this.field_146292_n.add(new GuiButtonInvisible(11, xStart + 8, yStart + ySize, 43, 22, "Create!"));
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textBox.func_146192_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.textBox.func_146201_a(par1, par2);
    }

    public void func_73876_c() {
        String error;
        if (!GuiCreator.func_146271_m()) {
            ++this.ticksElapsed;
        }
        this.error = error = this.verify();
        ((GuiButton)this.field_146292_n.get((int)11)).field_146124_l = this.correct = MathHelper.func_76139_a((String)error);
        ((GuiButton)this.field_146292_n.get((int)11)).field_146125_m = this.correct;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        super.func_146284_a(par1GuiButton);
        boolean shift = GuiCreator.func_146272_n();
        if (par1GuiButton.field_146127_k == 0) {
            this.chosenBiomeScrollIndex = Math.max(0, this.chosenBiomeScrollIndex - 1);
        }
        if (par1GuiButton.field_146127_k == 1) {
            this.chosenBiomeScrollIndex = Math.min(Math.max(0, this.chosenBiomes.size() - 1), this.chosenBiomeScrollIndex + 1);
        }
        if (par1GuiButton.field_146127_k == 2) {
            this.rarity = Math.max(1, this.rarity - (shift ? 10 : 1));
        }
        if (par1GuiButton.field_146127_k == 3) {
            this.rarity += shift ? 10 : 1;
        }
        int maxBiomeSize = this.availableBiomes.size() - 3;
        if (par1GuiButton.field_146127_k == 4) {
            this.biomeScrollIndex = Math.max(0, this.biomeScrollIndex - 1);
        }
        if (par1GuiButton.field_146127_k == 5) {
            this.biomeScrollIndex = Math.min(maxBiomeSize, this.biomeScrollIndex + 1);
        }
        if (par1GuiButton.field_146127_k == 4 || par1GuiButton.field_146127_k == 5) {
            for (int i = 0; i < 3; ++i) {
                BiomeGenBase biome = this.availableBiomes.get(this.biomeScrollIndex + i);
                boolean contains = this.chosenBiomes.contains(biome);
                GuiButtonPlusMinus button = (GuiButtonPlusMinus)((Object)this.field_146292_n.get(8 + i));
                button.setPlus(!contains);
            }
        }
        if (par1GuiButton.field_146127_k >= 8 && par1GuiButton.field_146127_k <= 10) {
            BiomeGenBase biome = this.availableBiomes.get(this.biomeScrollIndex + par1GuiButton.field_146127_k - 8);
            boolean contains = this.chosenBiomes.contains(biome);
            if (contains) {
                this.chosenBiomes.remove(biome);
            } else {
                this.chosenBiomes.add(biome);
            }
            ((GuiButtonPlusMinus)par1GuiButton).setPlus(contains);
            this.chosenBiomeScrollIndex = Math.min(this.chosenBiomeScrollIndex, Math.max(0, this.chosenBiomes.size() - 1));
        }
        if (par1GuiButton.field_146127_k == 11) {
            TemporaryStructureData data = new TemporaryStructureData(DataStorage.selection.copy());
            data.rarity = this.rarity;
            data.validBiomes = this.chosenBiomes;
            data.randomizeStoneBricks = ((GuiButtonCheckbox)((Object)this.field_146292_n.get((int)6))).field_146124_l;
            data.ignoreAirSpaces = ((GuiButtonCheckbox)((Object)this.field_146292_n.get((int)7))).field_146124_l;
            WriteStructureThread thread = new WriteStructureThread(data, this.textBox.func_146179_b(), this.field_146297_k);
            this.field_146297_k.func_147108_a(null);
            DataStorage.selection = null;
            DataStorage.point1 = null;
            DataStorage.point2 = null;
            thread.start();
        }
        if (par1GuiButton instanceof GuiButtonCheckbox) {
            ((GuiButtonCheckbox)par1GuiButton).check();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(guiResource);
        int xSize = 176;
        int ySize = 166;
        int renderXSize = 246;
        this.field_146289_q.func_82883_a();
        int xStart = (this.field_146294_l - xSize) / 2;
        int yStart = (this.field_146295_m - ySize) / 2;
        this.func_73729_b(xStart, yStart, 0, 0, renderXSize, ySize);
        if (this.correct) {
            this.func_73729_b(xStart + 8, yStart + ySize, 0, ySize, 43, 22);
        } else {
            this.func_73732_a(this.field_146289_q, this.error, this.field_146294_l / 2, yStart + 170, 0xFF4444);
        }
        this.func_73732_a(this.field_146289_q, "Editing Structure", this.field_146294_l / 2, yStart - 13, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Biomes", xStart + xSize + 35, yStart - 7, 0xFFFFFF);
        this.drawCenteredStringNoShadow(this.field_146289_q, "Name", xStart + 127, yStart + 5, 0x444444);
        this.drawCenteredStringNoShadow(this.field_146289_q, "Gen Biomes (" + this.chosenBiomes.size() + ")", xStart + 127, yStart + 36, 0x444444);
        this.field_146289_q.func_78276_b("Rarity", xStart + 87, yStart + 100, 0x444444);
        this.field_146289_q.func_78276_b("" + this.rarity, xStart + 138, yStart + 100, 0x444444);
        this.field_146289_q.func_78276_b("Randomize Stone Bricks", xStart + 8, yStart + 125, 0x444444);
        this.field_146289_q.func_78276_b("Ignore Air Spaces", xStart + 8, yStart + 145, 0x444444);
        this.field_146289_q.func_78264_a(true);
        for (int i = 0; i < 3; ++i) {
            BiomeGenBase biome = this.availableBiomes.get(i + this.biomeScrollIndex);
            String biomeName = biome.field_76791_y;
            String truncatedBiomeName = this.field_146289_q.func_78269_a(biome.field_76791_y, 38);
            if (!truncatedBiomeName.equals(biomeName)) {
                truncatedBiomeName = truncatedBiomeName.concat(".");
            }
            this.field_146289_q.func_78261_a(truncatedBiomeName, xStart + 183, yStart + 15 + i * 20, biome.field_76790_z);
        }
        if (this.chosenBiomes.size() > 0) {
            BiomeGenBase biome = this.chosenBiomes.get(this.chosenBiomeScrollIndex);
            String biomeName = biome.field_76791_y;
            String truncatedBiomeName = this.field_146289_q.func_78269_a(biome.field_76791_y, 63);
            if (!truncatedBiomeName.equals(biomeName)) {
                truncatedBiomeName = truncatedBiomeName.concat(".");
            }
            this.func_73732_a(this.field_146289_q, truncatedBiomeName, xStart + 127, yStart + 52, biome.field_76790_z);
        }
        this.field_146289_q.func_78264_a(false);
        String sizes = DataStorage.selection.getXSize() + "x" + DataStorage.selection.getYSize() + "x" + DataStorage.selection.getZSize();
        this.drawCenteredStringNoShadow(this.field_146289_q, sizes, xStart + 45, yStart + 105, 0x444444);
        this.renderSelection(xStart, yStart);
        this.textBox.func_146194_f();
        super.func_73863_a(par1, par2, par3);
    }

    public String verify() {
        String error = "";
        if (MathHelper.func_76139_a((String)this.textBox.func_146179_b())) {
            error = "The Structure needs a Name.";
        }
        if (this.isNameTaken()) {
            error = "That name is already used.";
        }
        if (this.chosenBiomes.isEmpty()) {
            error = "You need to pick one biome at least.";
        }
        return error;
    }

    public boolean isNameTaken() {
        return DataStorage.usedNames.contains(this.textBox.func_146179_b());
    }

    public void renderSelection(int xStart, int yStart) {
        float maxX = 70.0f;
        float maxY = 80.0f;
        BoundingBox sel = DataStorage.selection;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xStart + 46), (float)(yStart + 90), (float)this.field_73735_i);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.field_73735_i + 500.0f));
        float diag = (float)Math.sqrt(sel.getXSize() * sel.getXSize() + sel.getZSize() * sel.getZSize());
        float height = sel.getYSize();
        float scaleX = 70.0f / (diag + 1.4f);
        float scaleY = 80.0f / (height + 1.6f);
        float scale = Math.min(scaleY, scaleX);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)this.ticksElapsed % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (int x = 0; x < sel.getXSize(); ++x) {
            for (int y = 0; y < sel.getYSize(); ++y) {
                for (int z = 0; z < sel.getZSize(); ++z) {
                    FullBlockData data = sel.getBlockData(x, y, z);
                    this.renderBlock(data.block, data.meta, x, y, z);
                }
            }
        }
        GL11.glPopMatrix();
    }

    public void renderBlock(Block block, int meta, int x, int y, int z) {
        if (block != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - DataStorage.selection.getXSize() / 2), (float)y, (float)(z - DataStorage.selection.getZSize() / 2));
            renderBlocks.func_147800_a(block, meta, 0.85f);
            GL11.glPopMatrix();
        }
    }

    public void drawCenteredStringNoShadow(FontRenderer par1fontRendererObj, String par2Str, int par3, int par4, int par5) {
        par1fontRendererObj.func_78276_b(par2Str, par3 - par1fontRendererObj.func_78256_a(par2Str) / 2, par4, par5);
    }
}

