/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.client.saving;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;
import vazkii.gencreator.DataStorage;
import vazkii.gencreator.GenCreator;
import vazkii.gencreator.client.saving.TemporaryStructureData;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.helper.IOHelper;
import vazkii.gencreator.helper.StructureReader;

public class WriteStructureThread
extends Thread {
    public static boolean threadRunning = false;
    TemporaryStructureData data;
    Minecraft mc;
    String fileName;

    public WriteStructureThread(TemporaryStructureData structureData, String fileName, Minecraft mc) {
        this.data = structureData;
        this.mc = mc;
        this.fileName = fileName;
        this.setName("GenCreator Structure Writer");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        threadRunning = true;
        long startMs = System.currentTimeMillis();
        this.say("Starting Strucutre Creation. Do not modify your structure while this is going.");
        long ms = System.currentTimeMillis() - startMs;
        this.say("Initializing NBT [" + ms + "ms]");
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a("rarity", this.data.rarity);
        cmp.func_74778_a("validBiomes", this.generateValidBiomesString());
        cmp.func_74757_a("randomizeStoneBricks", this.data.randomizeStoneBricks);
        cmp.func_74757_a("ignoreAirSpaces", this.data.ignoreAirSpaces);
        cmp.func_74768_a("xSize", this.data.boundingBox.getXSize());
        cmp.func_74768_a("ySize", this.data.boundingBox.getYSize());
        cmp.func_74768_a("zSize", this.data.boundingBox.getZSize());
        NBTTagCompound blockCmp = new NBTTagCompound();
        ms = System.currentTimeMillis() - startMs;
        this.say("Writing Block Data to NBT [" + ms + "ms]");
        do {
            FullBlockData blockData = this.data.nextBlock();
            NBTTagCompound block1Cmp = new NBTTagCompound();
            blockData.writeToNBT(block1Cmp);
            blockCmp.func_74782_a(this.generateLocationString(), (NBTBase)block1Cmp);
        } while (this.data.iterateLocation());
        cmp.func_74782_a("blockData", (NBTBase)blockCmp);
        ms = System.currentTimeMillis() - startMs;
        this.say("Injecting NBT to .dat File [" + ms + "ms]");
        File file = IOHelper.createOrGetNBTFile(new File(GenCreator.dataDirectory, this.fileName + ".dat"));
        IOHelper.injectNBTToFile(cmp, file);
        ms = System.currentTimeMillis() - startMs;
        this.say("Reparsing NBT for WorldGen [" + ms + "ms]");
        StructureReader reader = new StructureReader(cmp);
        DataStorage.structures.add(reader.getStructureData());
        DataStorage.usedNames.add(this.fileName);
        ms = System.currentTimeMillis() - startMs;
        this.say("Done! [" + ms + "ms]");
        float seconds = (float)ms / 1000.0f;
        this.say("File " + this.fileName + ".dat created. Took " + seconds + " seconds. File Path: " + file.getAbsolutePath());
        threadRunning = false;
    }

    public String generateLocationString() {
        return this.data.currentX + "," + this.data.currentY + "," + this.data.currentZ;
    }

    public String generateValidBiomesString() {
        String s = "";
        for (BiomeGenBase biome : this.data.validBiomes) {
            s = s + biome.field_76756_M + ",";
        }
        return s.substring(0, s.length() - 1);
    }

    public void say(String s) {
        FMLLog.log((Level)Level.INFO, (String)s, (Object[])new Object[0]);
        if (this.mc.field_71439_g != null) {
            this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("[GenCreator] " + s));
        }
    }
}

