/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.world;

import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import vazkii.gencreator.helper.FullBlockData;
import vazkii.gencreator.helper.StructureData;
import vazkii.gencreator.world.PlacementMethod;
import vazkii.gencreator.world.staticspawner.StaticSpawner;

public class PlacementMethodChest
extends PlacementMethod {
    @Override
    public void place(World world, Random rand, int x, int y, int z, FullBlockData blockData, StructureData structure) {
        world.func_147465_d(x, y, z, blockData.block, blockData.meta, 2);
        TileEntity tile = this.constructTileEntity(world, x, y, z, blockData, structure);
        if (tile instanceof TileEntityChest) {
            boolean spawnerChest = this.isSpawner((TileEntityChest)tile);
            if (spawnerChest) {
                this.handleSpawner(world, rand, (TileEntityChest)tile, blockData, structure);
                world.func_147468_f(x, y, z);
                return;
            }
            world.func_147455_a(x, y, z, tile);
            if (this.shouldRandomize((TileEntityChest)tile)) {
                this.randomize(rand, (TileEntityChest)tile);
            }
        }
    }

    public boolean isSpawner(TileEntityChest tile) {
        ItemStack stack = tile.func_70301_a(0);
        return stack != null && stack.func_77973_b() == Items.field_151063_bx;
    }

    public void handleSpawner(World world, Random rand, TileEntityChest tile, FullBlockData blockData, StructureData structure) {
        StaticSpawner spawner = new StaticSpawner(tile, world);
        spawner.spawn();
    }

    public boolean shouldRandomize(TileEntityChest tile) {
        ItemStack stack = tile.func_70301_a(0);
        return stack != null && stack.func_77973_b() == Items.field_151121_aF && stack.func_82833_r().equals("[RANDOM]");
    }

    public void randomize(Random rand, TileEntityChest tile) {
        tile.func_70299_a(0, null);
        InventoryBasic holdingInv = new InventoryBasic("", false, tile.func_70302_i_());
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            holdingInv.func_70299_a(i, tile.func_70301_a(i) == null ? null : tile.func_70301_a(i).func_77946_l());
        }
        ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tile, (int)info.getCount(rand));
        for (int i = 0; i < holdingInv.func_70302_i_(); ++i) {
            ItemStack stack = holdingInv.func_70301_a(i);
            if (stack == null) continue;
            tile.func_70299_a(i, stack);
        }
    }
}

