/*
 * Decompiled with CFR 0.152.
 */
package vazkii.gencreator.world.staticspawner;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import vazkii.gencreator.world.staticspawner.IModifier;
import vazkii.gencreator.world.staticspawner.ModifierCoal;
import vazkii.gencreator.world.staticspawner.ModifierEmerald;
import vazkii.gencreator.world.staticspawner.ModifierNetherStar;
import vazkii.gencreator.world.staticspawner.ModifierPoisonPotato;
import vazkii.gencreator.world.staticspawner.ModifierPotato;
import vazkii.gencreator.world.staticspawner.ModifierPotion;
import vazkii.gencreator.world.staticspawner.ModifierWool;

public class StaticSpawner {
    private static Map<Item, IModifier> modifiers = new HashMap<Item, IModifier>();
    TileEntityChest chest;
    World world;
    EntityLivingBase entity;
    EntityLivingBase mount;
    boolean illegal = false;
    boolean villager = false;

    public StaticSpawner(TileEntityChest chest, World world) {
        this.chest = chest;
        this.world = world;
    }

    public void spawn() {
        this.identifyEntity();
        this.applyModifiers(1, this.entity);
        this.identifyMount();
        this.applyModifiers(19, this.mount);
        if (this.villager) {
            this.populateVillagerTrades();
        } else {
            this.equipEntity();
        }
        this.spawn_do();
    }

    private void identifyEntity() {
        if (this.illegal) {
            return;
        }
        ItemStack stack = this.chest.func_70301_a(0);
        this.identifyEntity(stack, false);
    }

    private void identifyMount() {
        if (this.illegal) {
            return;
        }
        ItemStack stack = this.chest.func_70301_a(18);
        this.identifyEntity(stack, true);
    }

    private void identifyEntity(ItemStack stack, boolean mount) {
        if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != Items.field_151063_bx) {
            if (!mount) {
                this.illegal = true;
            }
            return;
        }
        Entity entity = EntityList.func_75616_a((int)stack.func_77960_j(), (World)this.world);
        if (entity == null || !(entity instanceof EntityLivingBase)) {
            if (!mount) {
                this.illegal = true;
            }
            return;
        }
        if (!mount) {
            this.entity = (EntityLivingBase)entity;
            this.entity.func_70107_b((double)this.chest.field_145851_c + 0.5, (double)this.chest.field_145848_d, (double)this.chest.field_145849_e + 0.5);
            this.villager = entity instanceof EntityVillager;
            if (stack.func_82837_s() && this.entity instanceof EntityLiving) {
                ((EntityLiving)this.entity).func_94058_c(stack.func_82833_r());
            }
            this.flagEntityNonDespawnable(this.entity);
        } else {
            this.mount = (EntityLiving)entity;
            this.mount.func_70107_b((double)this.chest.field_145851_c + 0.5, (double)this.chest.field_145848_d, (double)this.chest.field_145849_e + 0.5);
            if (stack.func_82837_s() && this.mount instanceof EntityLiving) {
                ((EntityLiving)this.mount).func_94058_c(stack.func_82833_r());
            }
            this.flagEntityNonDespawnable(this.mount);
        }
    }

    private void flagEntityNonDespawnable(EntityLivingBase entity) {
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_110163_bv();
        }
    }

    private void equipEntity() {
        if (this.illegal) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.chest.func_70301_a(i + 9);
            if (stack == null) continue;
            this.entity.func_70062_b(4 - i, stack);
        }
    }

    private void populateVillagerTrades() {
        if (this.illegal) {
            return;
        }
        MerchantRecipeList list = new MerchantRecipeList();
        for (int i = 0; i < 9; ++i) {
            ItemStack buy = this.chest.func_70301_a(i + 9);
            ItemStack sell = this.chest.func_70301_a(i + 18);
            if (buy == null || sell == null) continue;
            MerchantRecipe recipe = new MerchantRecipe(buy, sell);
            recipe.func_82783_a(0x7FFFFFF8);
            list.add((Object)recipe);
        }
        if (!list.isEmpty()) {
            this.setVillagerTradingList((EntityVillager)this.entity, list);
            this.maximizeVillagerWealth((EntityVillager)this.entity);
        }
    }

    private void setVillagerTradingList(EntityVillager villager, MerchantRecipeList list) {
        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)list, (int)5);
    }

    private void maximizeVillagerWealth(EntityVillager villager) {
        villager.func_70606_j(2.1474836E9f);
    }

    private void applyModifiers(int start, EntityLivingBase entity) {
        if (this.illegal || entity == null) {
            return;
        }
        for (int i = start; i < start + 8; ++i) {
            ItemStack stack = this.chest.func_70301_a(i);
            if (stack == null) continue;
            this.applyModifier(stack, entity);
        }
    }

    private void applyModifier(ItemStack stack, EntityLivingBase entity) {
        if (modifiers.containsKey(stack.func_77973_b())) {
            IModifier modifier = modifiers.get(stack.func_77973_b());
            modifier.apply(stack, entity);
        }
    }

    private void spawn_do() {
        if (this.illegal) {
            return;
        }
        this.world.func_72838_d((Entity)this.entity);
        if (this.mount != null) {
            this.world.func_72838_d((Entity)this.mount);
            this.entity.func_70078_a((Entity)this.mount);
        }
    }

    static {
        modifiers.put(Items.field_151174_bG, new ModifierPotato());
        modifiers.put(Items.field_151170_bI, new ModifierPoisonPotato());
        modifiers.put(Items.field_151156_bN, new ModifierNetherStar());
        modifiers.put(Items.field_151044_h, new ModifierCoal());
        modifiers.put((Item)Items.field_151068_bn, new ModifierPotion());
        modifiers.put(Items.field_151166_bC, new ModifierEmerald());
        modifiers.put(Item.func_150898_a((Block)Blocks.field_150325_L), new ModifierWool());
    }
}

