/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.tileentity;

import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import router.reborn.RouterReborn;
import router.reborn.tileentity.IUpgrades;
import router.reborn.tileentity.InventoryChest;
import router.reborn.tileentity.chest.Util;

public class TileEntityChest
extends InventoryChest {
    public String dataPath = "";
    public ItemStack[][] upgrades = new ItemStack[6][9];
    public float angle;
    public float oldAngle;
    public int open;
    private int tickTimer;
    public IInventory[] invs = new IInventory[6];
    boolean hadInit = false;

    public void TileNeighborChanged(int ofX, int ofY, int ofZ, TileEntity tile) {
        int side = -1;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (dir.offsetX != ofX || dir.offsetY != ofY || dir.offsetZ != ofZ) continue;
            side = ForgeDirection.OPPOSITES[dir.ordinal()];
        }
        if (side == -1) {
            return;
        }
        if (tile != null && tile instanceof IInventory) {
            if (tile.func_145837_r()) {
                this.invs[side] = null;
                return;
            }
            if (this.invs[side] == null) {
                this.invs[side] = (IInventory)tile;
                return;
            }
            if (!tile.equals(this.invs[side])) {
                this.invs[side] = (IInventory)tile;
                return;
            }
        } else {
            this.invs[side] = null;
            return;
        }
    }

    public TileEntityChest() {
        super.setInventoryName("Special Chest");
    }

    public void updateDataPath() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.dataPath == "") {
            String tmpPath = "";
            File test = new File(Minecraft.func_71410_x().field_71412_D.getPath() + "/RouterReborn/d" + this.field_145850_b.field_73011_w.field_76574_g + "/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/x" + this.field_145851_c + "y" + this.field_145848_d + "z" + this.field_145849_e + "/");
            test.mkdirs();
            try {
                this.dataPath = test.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && !this.hadInit) {
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (tile instanceof IInventory) {
                    this.invs[dir.ordinal()] = (IInventory)tile;
                }
                this.hadInit = true;
            }
        }
        super.func_145845_h();
        if (++this.tickTimer % 20 * 4 == 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, RouterReborn.chest, 1, this.open);
        }
        this.oldAngle = this.angle;
        float f = 0.1f;
        if (this.open > 0 && this.angle == 0.0f) {
            double d0 = (double)this.field_145851_c + 0.5;
            double d1 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.open == 0 && this.angle > 0.0f || this.open > 0 && this.angle < 1.0f) {
            float f1;
            float f2 = this.angle;
            this.angle = this.open > 0 ? (this.angle += f) : (this.angle -= f);
            if (this.angle > 1.0f) {
                this.angle = 1.0f;
            }
            if (this.angle < (f1 = 0.5f) && f2 >= f1) {
                double d1 = (double)this.field_145851_c + 0.5;
                double d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.angle < 0.0f) {
                this.angle = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 2L == 0L) {
            for (int side = 0; side < this.upgrades.length; ++side) {
                for (int slot = 0; slot < this.upgrades[side].length; ++slot) {
                    ItemStack upg = this.upgrades[side][slot];
                    if (upg == null || !(upg.func_77973_b() instanceof IUpgrades)) continue;
                    ((IUpgrades)upg.func_77973_b()).doUpgradeUpdate(this.field_145850_b, side, this.upgrades[side], this, upg);
                }
            }
        }
    }

    public boolean func_145842_c(int eventID, int eventParameter) {
        if (eventID == 1) {
            if (this.open != eventParameter) {
                this.open = eventParameter;
            }
            return true;
        }
        return super.func_145842_c(eventID, eventParameter);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public void openChest() {
        ++this.open;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, RouterReborn.chest, 1, this.open);
        }
    }

    public void closeChest() {
        --this.open;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, RouterReborn.chest, 1, this.open);
        }
    }

    public boolean playerCanInteract(EntityPlayer p_145971_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_145971_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145841_b(NBTTagCompound p_145841_1_) {
        super.func_145841_b(p_145841_1_);
        p_145841_1_.func_74782_a("inventory", (NBTBase)super.saveInventoryToNBT());
        NBTTagList list = new NBTTagList();
        for (int side = 0; side < this.upgrades.length; ++side) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList slots = new NBTTagList();
            for (int slot = 0; slot < this.upgrades[side].length; ++slot) {
                NBTTagCompound itm = new NBTTagCompound();
                itm.func_74774_a("Slot", (byte)slot);
                if (this.upgrades[side][slot] != null) {
                    this.upgrades[side][slot].func_77955_b(itm);
                } else {
                    new ItemStack((Block)null).func_77955_b(itm);
                }
                slots.func_74742_a((NBTBase)itm);
            }
            tag.func_74782_a("slots", (NBTBase)slots);
            list.func_74742_a((NBTBase)tag);
        }
        p_145841_1_.func_74782_a("upgrades", (NBTBase)list);
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        super.loadInventoryFromNBT(p_145839_1_.func_150295_c("inventory", 10));
        NBTTagList lst = p_145839_1_.func_150295_c("upgrades", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tag = lst.func_150305_b(i);
            NBTTagList slotlst = tag.func_150295_c("slots", 10);
            for (int x = 0; x < slotlst.func_74745_c(); ++x) {
                NBTTagCompound slot = slotlst.func_150305_b(x);
                byte islot = slot.func_74771_c("Slot");
                this.upgrades[i][islot] = ItemStack.func_77949_a((NBTTagCompound)slot);
            }
        }
    }

    public TileEntityChest getInventoryChest() {
        return this;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        ItemStack stack = null;
        if (slot >= 0 && slot < this.inventoryContents.length) {
            stack = this.inventoryContents[slot];
            return stack;
        }
        int side = slot / 100;
        int s = slot % 100;
        return this.upgrades[--side][s];
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            if (this.inventoryContents[slot] != null) {
                if (this.inventoryContents[slot].field_77994_a <= count) {
                    ItemStack itemstack = this.inventoryContents[slot];
                    this.inventoryContents[slot] = null;
                    this.func_70296_d();
                    return itemstack;
                }
                ItemStack itemstack = this.inventoryContents[slot].func_77979_a(count);
                if (this.inventoryContents[slot].field_77994_a == 0) {
                    this.inventoryContents[slot] = null;
                }
                this.func_70296_d();
                return itemstack;
            }
            return null;
        }
        int side = slot / 100;
        int s = slot % 100;
        if (this.upgrades[--side][s] != null) {
            if (this.upgrades[side][s].field_77994_a <= count) {
                ItemStack itemstack = this.upgrades[side][s];
                this.upgrades[side][s] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.upgrades[side][s].func_77979_a(count);
            if (this.upgrades[side][s].field_77994_a == 0) {
                this.upgrades[side][s] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            if (this.inventoryContents[slot] != null) {
                ItemStack itemstack = this.inventoryContents[slot];
                this.inventoryContents[slot] = null;
                return itemstack;
            }
            return null;
        }
        int side = slot / 100;
        int s = slot % 100;
        if (this.upgrades[--side][s] != null) {
            ItemStack itemstack = this.upgrades[side][s];
            this.upgrades[side][s] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack item) {
        if (slot >= 0 && slot < this.inventoryContents.length) {
            this.inventoryContents[slot] = item;
            if (item != null && item.field_77994_a > this.func_70297_j_()) {
                item.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            return;
        }
        int side = slot / 100;
        int s = slot % 100;
        this.upgrades[--side][s] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    @Override
    public int func_70302_i_() {
        return this.slotsCount;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return Util.checkFilter(item, this.upgrades[side]);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (this.upgrades[side] != null) {
            return Util.checkFilter(item, this.upgrades[side]);
        }
        return true;
    }
}

