/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import router.reborn.cfg;
import router.reborn.tileentity.energy.tileRedfluxBase;

public class TileEntityPowerAdapter
extends tileRedfluxBase
implements IEnergySource {
    protected boolean addedToEnet;
    private TileEntity[] tiles = new TileEntity[6];

    public TileEntityPowerAdapter(int storage) {
        super(storage);
    }

    public TileEntityPowerAdapter() {
        super(32000);
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        double ret = Math.min(8196L, Math.round((double)this.storage.getEnergyStored() * cfg.convertionratio));
        return ret;
    }

    public void drawEnergy(double amount) {
        this.storage.extractEnergy((int)Math.round(amount / cfg.convertionratio), false);
    }

    public int getSourceTier() {
        return 4;
    }

    public void func_145845_h() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }
}

