/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import router.reborn.RouterNetClientPackage;
import router.reborn.RouterReborn;
import router.reborn.block.BlockRouter;
import router.reborn.block.cableUtil;
import router.reborn.cfg;
import router.reborn.tileentity.ICammo;
import router.reborn.tileentity.IInventoryCable;
import router.reborn.tileentity.TileEntityBase;

public abstract class TileEntityRouterBase
extends TileEntityBase
implements ICammo {
    private int lastIndx = 0;
    public int lastTab = 0;
    public boolean upgRedstone = true;
    public int redstoneType = 0;
    public boolean visitNear = false;
    public boolean machineBlackList = false;
    public boolean itemBlacklist = false;
    public boolean ignoreMetadata = false;
    public boolean upgEject = false;
    public ForgeDirection ejectSide = ForgeDirection.UNKNOWN;
    public boolean upgThorow = false;
    public boolean upgItemFilter = false;
    public boolean upgBandwidth = false;
    public boolean upgCamouflage = false;
    public int useSlot = 0;
    public ForgeDirection useSide = ForgeDirection.DOWN;
    public boolean upgMachineFilter = false;
    public boolean upgNoDelay = false;
    private ItemStack cammo = null;
    public boolean awaitScan = false;
    public IInventory eject = null;
    public MODE sMode = MODE.SIDED;
    public ArrayList<String> filterMachine = new ArrayList();
    public IOMODE mode = IOMODE.OUTPUT;
    public int rotation = 0;
    public ArrayList<String> mcList = new ArrayList();
    public ArrayList<Inventory> activeTileList;
    public ArrayList<TileEntity> cableTileList;
    public Stack<TileEntity> scanList;
    public Stack<TileEntity> scanApproved;
    public ArrayList<Future<String>> scanbreakblock = new ArrayList();
    public Future<ArrayList<Inventory>> scanner;
    private static final ExecutorService pool = Executors.newFixedThreadPool(cfg.threadLimit);
    ArrayList<Future<POS>> scannewblock = new ArrayList();
    private boolean lastRSstate = false;
    protected POS newpos;
    public boolean awaitResult = false;
    public ItemStack lastItem = null;
    public int delayUpdate = 0;
    public boolean hasInit = false;

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RouterReborn.routers.add(this);
            this.hasInit = false;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            RouterReborn.routers.remove(this);
        }
    }

    public void setMode(IOMODE tmp) {
        this.mode = tmp;
    }

    public TileEntityRouterBase() {
        this.slots = new ItemStack[11];
        slots_bottom = new int[]{0};
        slots_side = new int[]{0};
        slots_top = new int[]{0};
    }

    @Override
    public void setCammo(ItemStack stack, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound upd = new NBTTagCompound();
            this.cammo = stack;
            this.writeSyncableDataToNBT(upd);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private boolean validTile(TileEntity tile) {
        boolean res = tile instanceof IInventory || tile instanceof IInventoryCable;
        return res;
    }

    public boolean checkMachineFilter(String text) {
        if (!this.upgMachineFilter) {
            return true;
        }
        for (String filter : this.filterMachine) {
            if (!text.equalsIgnoreCase(filter)) continue;
            return !this.machineBlackList;
        }
        return this.machineBlackList;
    }

    public ArrayList<Inventory> scanForInventory(boolean IgnoreFilters) {
        TileEntity ej;
        Stack<TileEntity> list = new Stack<TileEntity>();
        IInventory[] eject = new IInventory[7];
        if (this.upgEject && this.ejectSide != ForgeDirection.UNKNOWN && (ej = this.field_145850_b.func_147438_o(this.field_145851_c + this.ejectSide.offsetX, this.field_145848_d + this.ejectSide.offsetY, this.field_145849_e + this.ejectSide.offsetZ)) instanceof IInventory) {
            eject[this.ejectSide.ordinal()] = (IInventory)ej;
            this.eject = (IInventory)ej;
        }
        if (this.scanList == null) {
            this.scanList = new Stack();
        }
        if (this.scanApproved == null) {
            this.scanApproved = new Stack();
        }
        this.scanList.clear();
        this.scanList.add(this);
        TileEntity tmp = null;
        TileEntity tile = null;
        Inventory tmpInv = null;
        block0: while (!this.scanList.empty()) {
            tile = this.scanList.pop();
            list.push(tile);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                tmp = this.field_145850_b.func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
                if (!this.validTile(tmp) && cableUtil.checkBlockInvCableAt(tmp) != IInventoryCable.invType.NORMAL) continue;
                tmpInv = new Inventory(tmp);
                if (tmp == this || this.scanApproved.contains(tmp) || this.scanList.contains(tmp) || list.contains(tmp) || this.isBlacklisted(tmpInv) && (cableUtil.checkBlockInvCableAt(tmp) != IInventoryCable.invType.NORMAL && cableUtil.checkBlockInvCableAt(tile) != IInventoryCable.invType.NORMAL || !cableUtil.canConnectThrewCover(tile, dir.ordinal()) || !cableUtil.canConnectThrewCover(tmp, ForgeDirection.OPPOSITES[dir.ordinal()]))) continue;
                if ((IgnoreFilters || this.checkMachineFilter(tmpInv.invName) || tmpInv.tile instanceof IInventoryCable) && (eject[this.ejectSide.ordinal()] != tmp || IgnoreFilters)) {
                    if (this.visitNear && !this.checkMachineFilter(tmpInv.invName) && !IgnoreFilters) continue block0;
                    this.scanApproved.add(tmp);
                }
                this.scanList.add(tmp);
            }
        }
        if (this.cableTileList == null) {
            this.cableTileList = new ArrayList();
        }
        this.cableTileList.clear();
        ArrayList<Inventory> lst = new ArrayList<Inventory>();
        while (!this.scanApproved.empty()) {
            tile = (TileEntity)this.scanApproved.remove(0);
            if (!(tile instanceof IInventoryCable) && cableUtil.checkBlockInvCableAt(tile) != IInventoryCable.invType.NORMAL) {
                if (tile == null) continue;
                lst.add(new Inventory(tile));
                continue;
            }
            this.cableTileList.add(tile);
        }
        return lst;
    }

    public Future<ArrayList<Inventory>> runScanner() {
        return pool.submit(new Callable<ArrayList<Inventory>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ArrayList<Inventory> call() throws Exception {
                1 var1_1 = this;
                synchronized (var1_1) {
                    World world = TileEntityRouterBase.this.field_145850_b;
                    synchronized (world) {
                        return TileEntityRouterBase.this.scanForInventory(false);
                    }
                }
            }
        });
    }

    public Future<String> runScanBlockBreak(final int x, final int y, final int z) {
        return pool.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                2 var1_1 = this;
                synchronized (var1_1) {
                    return TileEntityRouterBase.this.ScanBlockBreak(x, y, z);
                }
            }
        });
    }

    public String ScanBlockBreak(int x, int y, int z) {
        int indx = this.getIndexOfInv(x, y, z);
        if (indx == -1) {
            if (this.getIndexOfCable(x, y, z) > -1) {
                this.awaitScan = true;
                this.newpos = new POS(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return "true";
            }
            return "false";
        }
        this.awaitScan = true;
        this.newpos = new POS(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return "true";
    }

    public Future<POS> runScanBlockPlaced(final int x, final int y, final int z) {
        return pool.submit(new Callable<POS>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public POS call() throws Exception {
                3 var1_1 = this;
                synchronized (var1_1) {
                    return TileEntityRouterBase.this.ScanBlockPlaced(x, y, z);
                }
            }
        });
    }

    public POS ScanBlockPlaced(int X, int Y, int Z) {
        int invidx = -1;
        int caidx = -1;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (X - x == this.field_145851_c && Y - y == this.field_145848_d && Z - z == this.field_145849_e) {
                        this.newpos = new POS(X, Y, Z);
                        return new POS(X, Y, Z);
                    }
                    invidx = this.getIndexOfInv(X + x, Y + y, Z + z);
                    caidx = this.getIndexOfCable(X + x, Y + y, Z + z);
                    if (invidx > -1) {
                        this.newpos = new POS(X, Y, Z);
                        return new POS(X, Y, Z);
                    }
                    if (caidx <= -1) continue;
                    this.newpos = new POS(X, Y, Z);
                    return new POS(X, Y, Z);
                }
            }
        }
        return null;
    }

    private int getIndexOfCable(int x, int y, int z) {
        if (this.cableTileList == null || this.cableTileList.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.cableTileList.size(); ++i) {
            TileEntity s = this.cableTileList.get(i);
            if (s.field_145851_c != x || s.field_145848_d != y || s.field_145849_e != z) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfInv(int x, int y, int z) {
        if (this.activeTileList == null || this.activeTileList.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.activeTileList.size(); ++i) {
            Inventory s = this.activeTileList.get(i);
            if (s.tile.field_145851_c != x || s.tile.field_145848_d != y || s.tile.field_145849_e != z) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack getCammo() {
        return this.cammo;
    }

    @Override
    public boolean canInsertItemToSlot(int slot, ItemStack item) {
        if (slot == 0) {
            return this.ItemFilterOK(item);
        }
        return false;
    }

    protected boolean oreDictMatch(int[] stack, int[] stack2) {
        if (stack == null) {
            return false;
        }
        if (stack2 == null) {
            return false;
        }
        for (int s = 0; s < stack.length; ++s) {
            for (int t = 0; t < stack2.length; ++t) {
                if (stack[s] != stack2[t]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkRedstone() {
        if (this.upgRedstone) {
            if (this.redstoneType < 4) {
                BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            switch (this.redstoneType) {
                case 1: {
                    if (this.getRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0) break;
                    return false;
                }
                case 2: {
                    if (this.getRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) <= 0) break;
                    return false;
                }
                case 3: {
                    boolean rst;
                    boolean bl = rst = this.getRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
                    if (this.lastRSstate != rst && rst) {
                        this.lastRSstate = rst;
                        return true;
                    }
                    this.lastRSstate = rst;
                    return false;
                }
            }
        }
        return true;
    }

    protected int calculateRedstoneFromInventory() {
        double ss = this.slots[0].field_77994_a;
        double ms = this.slots[0].func_77976_d();
        int pers = (int)(ss / ms * 15.0);
        return pers;
    }

    protected int getRedstone(World worldObj, int x, int y, int z) {
        return worldObj.func_94572_D(x, y, z);
    }

    protected void setRedstone() {
        if (this.upgRedstone) {
            switch (this.redstoneType) {
                case 4: {
                    if (this.slots[0] == null) {
                        BlockRouter.setRedstone(15, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                case 5: {
                    if (this.slots[0] == null) {
                        BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        break;
                    }
                    if (this.slots[0].field_77994_a >= this.slots[0].func_77976_d()) {
                        BlockRouter.setRedstone(15, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
                case 6: {
                    if (this.slots[0] != null) {
                        BlockRouter.setRedstone(this.calculateRedstoneFromInventory(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        break;
                    }
                    BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    break;
                }
            }
        } else {
            BlockRouter.setRedstone(0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected boolean ItemFilterOK(ItemStack item) {
        if (!this.upgItemFilter) {
            return true;
        }
        if (item == null) {
            return true;
        }
        if (!this.itemBlacklist) {
            for (int i = 1; i < 10; ++i) {
                if (this.slots[i] == null) continue;
                int[] ore1 = OreDictionary.getOreIDs((ItemStack)this.slots[i]);
                int[] ore2 = OreDictionary.getOreIDs((ItemStack)item);
                if (ore1 != null && ore2 != null && ore1.length != 0 && ore2.length != 0) {
                    if (!this.oreDictMatch(ore1, ore2)) continue;
                    return true;
                }
                if (this.slots[i].func_77973_b() != item.func_77973_b()) continue;
                if (this.ignoreMetadata) {
                    return true;
                }
                if (this.slots[i].func_77960_j() != item.func_77960_j()) continue;
                return true;
            }
            return false;
        }
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null) continue;
            int[] ore1 = OreDictionary.getOreIDs((ItemStack)this.slots[i]);
            int[] ore2 = OreDictionary.getOreIDs((ItemStack)item);
            if (ore1 != null && ore2 != null && ore1.length != 0 && ore2.length != 0) {
                if (!this.oreDictMatch(ore1, ore2)) continue;
                return false;
            }
            if (this.slots[i].func_77973_b() != item.func_77973_b()) continue;
            if (this.ignoreMetadata) {
                return false;
            }
            if (this.slots[i].func_77960_j() != item.func_77960_j()) continue;
            return false;
        }
        return true;
    }

    protected boolean isBlacklisted(Inventory tmpInv) {
        if (cfg.Blacklist == null) {
            return false;
        }
        for (String element : cfg.Blacklist) {
            if (element == null || element.length() <= 0) continue;
            try {
                Matcher matcher;
                Pattern pattern = Pattern.compile(element.toLowerCase().trim());
                if (pattern == null || (matcher = pattern.matcher(tmpInv.invName.toLowerCase().trim())) == null || !matcher.find()) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean allowedToExtractFromSlot(int slot, ItemStack item, int count) {
        return slot == 0;
    }

    @Override
    public String func_145825_b() {
        return "tile.router";
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void readNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagList tagList2 = tagCompound.func_150295_c("cammo", 10);
        for (int i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList2.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot != 0) continue;
            this.cammo = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void readNBTVars(NBTTagCompound tagCompound) {
        this.useSlot = tagCompound.func_74762_e("useSlot");
        this.useSide = ForgeDirection.values()[tagCompound.func_74762_e("useSide")];
        this.sMode = tagCompound.func_74762_e("sMode") == 1 ? MODE.SIDED : MODE.NUMBERED;
        this.mode = tagCompound.func_74762_e("mode") == 1 ? IOMODE.EXTRACT : IOMODE.OUTPUT;
        this.upgBandwidth = tagCompound.func_74767_n("upgBandwidth");
        this.upgMachineFilter = tagCompound.func_74767_n("upgMachineFilter");
        this.upgNoDelay = tagCompound.func_74767_n("upgNoDelay");
        NBTTagList tagList2 = tagCompound.func_150295_c("machinefilter", 10);
        for (int i = 0; i < tagList2.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList2.func_150305_b(i);
            this.filterMachine.add(tag.func_74779_i("filter"));
        }
        this.upgItemFilter = tagCompound.func_74767_n("upgItemFilter");
        this.upgThorow = tagCompound.func_74767_n("upgThorow");
        this.upgEject = tagCompound.func_74767_n("upgEject");
        this.upgCamouflage = tagCompound.func_74767_n("upgCamouflage");
        this.ejectSide = ForgeDirection.getOrientation((int)tagCompound.func_74762_e("ejectSide"));
        this.upgRedstone = tagCompound.func_74767_n("upgRedstone");
        this.redstoneType = tagCompound.func_74762_e("redstoneType");
        this.itemBlacklist = tagCompound.func_74767_n("itemBlacklist");
        this.machineBlackList = tagCompound.func_74767_n("machineBlackList");
        this.visitNear = tagCompound.func_74767_n("visitNear");
        this.ignoreMetadata = tagCompound.func_74767_n("ignoreMetadata");
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readNBTSlots(tagCompound);
        this.readNBTVars(tagCompound);
    }

    public void readFromNBTitem(NBTTagCompound tagCompound) {
        this.readNBTSlots(tagCompound);
        this.readNBTVars(tagCompound);
        this.func_70296_d();
    }

    public void readSyncableDataFromNBT(NBTTagCompound tagCompound) {
        this.readNBTSlots(tagCompound);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void writeNBTSlots(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            if (stack != null) {
                stack.func_77955_b(tag);
            } else {
                new ItemStack((Block)null).func_77955_b(tag);
            }
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        itemList = new NBTTagList();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Slot", (byte)0);
        if (this.cammo != null) {
            this.cammo.func_77955_b(tag);
        } else {
            new ItemStack((Block)null).func_77955_b(tag);
        }
        itemList.func_74742_a((NBTBase)tag);
        tagCompound.func_74782_a("cammo", (NBTBase)itemList);
    }

    public void writeNBTVars(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("useSlot", this.useSlot);
        tagCompound.func_74768_a("useSide", this.useSide.ordinal());
        tagCompound.func_74768_a("sMode", this.sMode == MODE.SIDED ? 1 : 0);
        tagCompound.func_74768_a("mode", this.mode == IOMODE.EXTRACT ? 1 : 0);
        tagCompound.func_74757_a("upgBandwidth", this.upgBandwidth);
        tagCompound.func_74757_a("upgMachineFilter", this.upgMachineFilter);
        tagCompound.func_74757_a("upgNoDelay", this.upgNoDelay);
        tagCompound.func_74757_a("upgItemFilter", this.upgItemFilter);
        tagCompound.func_74757_a("upgThorow", this.upgThorow);
        tagCompound.func_74757_a("upgEject", this.upgEject);
        tagCompound.func_74757_a("upgCamouflage", this.upgCamouflage);
        tagCompound.func_74768_a("ejectSide", this.ejectSide.ordinal());
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.filterMachine.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("filter", this.filterMachine.get(i));
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("machinefilter", (NBTBase)itemList);
        tagCompound.func_74757_a("upgRedstone", this.upgRedstone);
        tagCompound.func_74768_a("redstoneType", this.redstoneType);
        tagCompound.func_74757_a("itemBlacklist", this.itemBlacklist);
        tagCompound.func_74757_a("machineBlackList", this.machineBlackList);
        tagCompound.func_74757_a("visitNear", this.visitNear);
        tagCompound.func_74757_a("ignoreMetadata", this.ignoreMetadata);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeNBTSlots(tagCompound);
        this.writeNBTVars(tagCompound);
    }

    public void writeSyncableDataToNBT(NBTTagCompound tagCompound) {
        this.writeNBTSlots(tagCompound);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            ++this.rotation;
            if (this.rotation > 359) {
                this.rotation = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.sendForcedUpdate();
            }
            if (!this.hasInit) {
                this.hasInit = true;
                this.activeTileList = (ArrayList)this.scanForInventory(false).clone();
                System.out.println("Initialized new invlist router: x:" + this.field_145851_c + " y:" + this.field_145848_d + " z:" + this.field_145849_e);
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
                for (Future<POS> future : this.scannewblock) {
                    if (future == null || !future.isDone()) continue;
                    try {
                        POS res = future.get();
                        if (res != null && this.validTile(this.field_145850_b.func_147438_o(res.x, res.y, res.z))) {
                            this.newpos = res;
                            this.awaitScan = true;
                            this.scannewblock.remove(future);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.scannewblock.remove(future);
                    break;
                }
                for (Future<Object> future : this.scanbreakblock) {
                    if (future == null || !future.isDone()) continue;
                    try {
                        if (future.get() == "true") {
                            this.newpos = new POS(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.awaitScan = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    this.scanbreakblock.remove(future);
                    break;
                }
                if (this.awaitScan && this.field_145850_b.func_82737_E() % (long)cfg.tickrate == 0L && this.newpos != null) {
                    TileEntity tile = this.field_145850_b.func_147438_o(this.newpos.x, this.newpos.y, this.newpos.z);
                    if (tile != null && this.validTile(tile)) {
                        if (this.scanner == null || this.scanner != null && this.scanner.isDone()) {
                            this.scanner = this.runScanner();
                            this.awaitResult = true;
                        }
                        this.awaitScan = false;
                        this.newpos = null;
                    } else {
                        this.awaitScan = false;
                    }
                }
            }
        }
        if (this.awaitResult && this.scanner != null && this.scanner.isDone()) {
            try {
                this.awaitResult = false;
                this.activeTileList = (ArrayList)this.scanner.get().clone();
            }
            catch (InterruptedException | ExecutionException e) {
                this.activeTileList = null;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendClientUpdateIfChanged();
        }
    }

    public void BlockBreak(BlockEvent.BreakEvent e, TileEntity tile) {
        if (this.awaitScan || !this.hasInit) {
            return;
        }
        this.scanbreakblock.add(this.runScanBlockBreak(e.x, e.y, e.z));
    }

    public void sendForcedUpdate() {
        if (this.slots[0] != null) {
            this.lastItem = this.slots[0].func_77946_l();
            Object[] objectArray = new Object[7];
            objectArray[0] = this.field_145851_c;
            objectArray[1] = this.field_145848_d;
            objectArray[2] = this.field_145849_e;
            objectArray[3] = 55;
            this.slots[0].func_77973_b();
            objectArray[4] = Item.func_150891_b((Item)this.slots[0].func_77973_b());
            objectArray[5] = this.slots[0].func_77960_j();
            objectArray[6] = this.slots[0].field_77994_a;
            String s2 = String.format("%d:%d:%d:%d:%d:%d:%d", objectArray);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.func_72912_H().func_76076_i(), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 60.0);
            RouterReborn.network.sendToAllAround((IMessage)new RouterNetClientPackage(s2), point);
        } else {
            this.delayUpdate = 0;
            String s2 = String.format("%d:%d:%d:%d:%d:%d:%d", this.field_145851_c, this.field_145848_d, this.field_145849_e, 55, 0, 0, 0);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.func_72912_H().func_76076_i(), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 60.0);
            RouterReborn.network.sendToAllAround((IMessage)new RouterNetClientPackage(s2), point);
            this.lastItem = null;
        }
    }

    private void sendClientUpdateIfChanged() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null) {
                this.delayUpdate = 0;
                if (!ItemStack.func_77989_b((ItemStack)this.lastItem, (ItemStack)this.slots[0])) {
                    this.lastItem = this.slots[0].func_77946_l();
                    Object[] objectArray = new Object[7];
                    objectArray[0] = this.field_145851_c;
                    objectArray[1] = this.field_145848_d;
                    objectArray[2] = this.field_145849_e;
                    objectArray[3] = 55;
                    this.slots[0].func_77973_b();
                    objectArray[4] = Item.func_150891_b((Item)this.slots[0].func_77973_b());
                    objectArray[5] = this.slots[0].func_77960_j();
                    objectArray[6] = this.slots[0].field_77994_a;
                    String s2 = String.format("%d:%d:%d:%d:%d:%d:%d", objectArray);
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.func_72912_H().func_76076_i(), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 60.0);
                    RouterReborn.network.sendToAllAround((IMessage)new RouterNetClientPackage(s2), point);
                }
            } else {
                ++this.delayUpdate;
                if (this.delayUpdate > 19) {
                    this.delayUpdate = 0;
                    String s2 = String.format("%d:%d:%d:%d:%d:%d:%d", this.field_145851_c, this.field_145848_d, this.field_145849_e, 55, 0, 0, 0);
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.func_72912_H().func_76076_i(), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 60.0);
                    RouterReborn.network.sendToAllAround((IMessage)new RouterNetClientPackage(s2), point);
                    this.lastItem = null;
                }
                if (this.lastItem == null) {
                    this.delayUpdate = 0;
                }
            }
        }
    }

    public void BlockPlace(BlockEvent.PlaceEvent e, TileEntity tile) {
        if (this.awaitScan || !this.hasInit) {
            return;
        }
        this.scannewblock.add(this.runScanBlockPlaced(e.x, e.y, e.z));
    }

    private class POS {
        public int x;
        public int y;
        public int z;

        public POS(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public class Inventory {
        public String invName = "";
        public TileEntity tile;

        public Inventory(TileEntity tile) {
            this.tile = tile;
            this.invName = this.getTileName(tile);
        }

        public String getTileName(TileEntity tile) {
            if (tile == null) {
                return "NULL";
            }
            Block blc = tile.func_145838_q();
            try {
                int meta = TileEntityRouterBase.this.field_145850_b.func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                Item it = blc.func_149650_a(tile.field_145847_g, null, 0);
                ItemStack stack = new ItemStack(it, 1, meta);
                if (stack != null && stack.func_77973_b() != null) {
                    String invname = stack.func_77977_a();
                    return invname.replace(':', '|');
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return blc.func_149739_a();
        }
    }

    public static enum MODE {
        NUMBERED,
        SIDED;

    }

    public static enum IOMODE {
        OUTPUT,
        EXTRACT;

    }
}

