/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.util;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.DimensionManager;
import router.reborn.RouterReborn;

public class CommandRR_ReloadConfig
extends CommandBase {
    private static final DecimalFormat timeFormatter = new DecimalFormat("########0.000");
    private WeakReference<MinecraftServer> server;

    public CommandRR_ReloadConfig(MinecraftServer server) {
        this.server = new WeakReference<MinecraftServer>(server);
    }

    public String func_71517_b() {
        return "rr";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "commands.forge.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException("routerreborn:commands.rr.usage", new Object[0]);
        }
        if ("help".equals(args[0])) {
            throw new WrongUsageException("routerreborn:commands.rr.usage", new Object[0]);
        }
        if ("creload".equals(args[0])) {
            this.ReloadConfig(sender, args);
        } else if ("tps".equals(args[0])) {
            this.displayTPS(sender, args);
        } else {
            throw new WrongUsageException("routerreborn:commands.rr.usage", new Object[0]);
        }
    }

    private void ReloadConfig(ICommandSender sender, String[] args) {
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Reloading config....", new Object[0]));
        try {
            RouterReborn.readConfig(RouterReborn.pr);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("Config Reloaded!", new Object[0]));
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation(e.getMessage(), new Object[0]));
        }
    }

    private void displayTPS(ICommandSender sender, String[] args) {
        int dim = 0;
        boolean summary = true;
        if (args.length > 1) {
            dim = CommandRR_ReloadConfig.func_71526_a((ICommandSender)sender, (String)args[1]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)CommandRR_ReloadConfig.mean((long[])this.getServer().worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dimId), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
            }
            double meanTickTime = (double)CommandRR_ReloadConfig.mean(this.getServer().field_71311_j) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.forge.tps.summary", new Object[]{"Overall", timeFormatter.format(meanTickTime), timeFormatter.format(meanTPS)}));
        } else {
            double worldTickTime = (double)CommandRR_ReloadConfig.mean((long[])this.getServer().worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.forge.tps.summary", new Object[]{String.format("Dim %d", dim), timeFormatter.format(worldTickTime), timeFormatter.format(worldTPS)}));
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)this.server.get();
    }
}

