/*
 * Decompiled with CFR 0.152.
 */
package tf2crates.crate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import tf2crates.ServerProxyTC;
import tf2crates.item.ItemPaint;
import tlhpoeCore.util.MathUtil;

public abstract class RandomLoot {
    private List<Item> possibleLoot;
    protected boolean enchanted;
    public static final List<Item> PICKAXES = new ArrayList<Item>();
    public static final List<Item> SHOVELS = new ArrayList<Item>();
    public static final List<Item> SWORDS = new ArrayList<Item>();
    public static final List<Item> AXES = new ArrayList<Item>();
    public static final List<Item> HOES = new ArrayList<Item>();
    public static final Map<Item.ToolMaterial, ArrayList<Item>> MATERIAL_TOOLS = new HashMap<Item.ToolMaterial, ArrayList<Item>>();
    public static final List<Item> HELMETS = new ArrayList<Item>();
    public static final List<Item> CHESTPLATES = new ArrayList<Item>();
    public static final List<Item> LEGGINGS = new ArrayList<Item>();
    public static final List<Item> BOOTS = new ArrayList<Item>();
    public static final Map<ItemArmor.ArmorMaterial, ArrayList<Item>> MATERIAL_ARMOR = new HashMap<ItemArmor.ArmorMaterial, ArrayList<Item>>();
    public static final List<Item> FOOD = new ArrayList<Item>();
    public static final List<ItemStack> POTIONS = new ArrayList<ItemStack>();
    public static final List<ItemStack> SPLASH_POTIONS = new ArrayList<ItemStack>();
    public static final List<Item> WEAPONS = new ArrayList<Item>();

    private RandomLoot(List<Item> possibleLoot, boolean enchanted) {
        this.possibleLoot = possibleLoot;
        this.enchanted = enchanted;
    }

    public ItemStack getLoot() {
        System.err.println("CLASS: " + this.getClass().getCanonicalName());
        System.err.println("SIZE: " + this.possibleLoot.size());
        ItemStack loot = new ItemStack(this.possibleLoot.get(MathUtil.nextInt((int)this.possibleLoot.size())), 1);
        if (this.enchanted) {
            EnchantmentHelper.func_77504_a((Random)MathUtil.getRandom(), (ItemStack)loot, (int)MathUtil.getRandomIntegerBetween((int)25, (int)30));
        }
        return loot;
    }

    public abstract String getDisplayName();

    public static class FishingRod
    extends RandomLoot {
        public FishingRod() {
            super(null, true);
        }

        @Override
        public ItemStack getLoot() {
            ItemStack loot = new ItemStack((Item)Items.field_151112_aM, 1);
            EnchantmentHelper.func_77504_a((Random)MathUtil.getRandom(), (ItemStack)loot, (int)30);
            return loot;
        }

        @Override
        public String getDisplayName() {
            return "A Randomly Enchanted Fishing Rod";
        }
    }

    public static class EnchantedBook
    extends RandomLoot {
        public EnchantedBook() {
            super(null, true);
        }

        @Override
        public ItemStack getLoot() {
            ItemStack loot = new ItemStack((Item)Items.field_151134_bR, 1);
            Enchantment enchantment = Enchantment.field_92090_c[MathUtil.nextInt((int)Enchantment.field_92090_c.length)];
            Items.field_151134_bR.func_92115_a(loot, new EnchantmentData(enchantment, MathUtil.getRandomIntegerBetween((int)enchantment.func_77319_d(), (int)enchantment.func_77325_b())));
            EnchantmentHelper.func_77504_a((Random)MathUtil.getRandom(), (ItemStack)loot, (int)30);
            return loot;
        }

        @Override
        public String getDisplayName() {
            return "A Random Enchanted Book";
        }
    }

    public static class Paint
    extends RandomLoot {
        public Paint() {
            super(null, false);
        }

        @Override
        public ItemStack getLoot() {
            return new ItemStack(ServerProxyTC.paint, 1, MathUtil.nextInt((int)ItemPaint.TYPES.length));
        }

        @Override
        public String getDisplayName() {
            return "A Random Paint";
        }
    }

    public static class CertainMaterialArmor
    extends RandomLoot {
        private ItemArmor.ArmorMaterial material;

        public CertainMaterialArmor(ItemArmor.ArmorMaterial material, boolean enchanted) {
            super((List)MATERIAL_ARMOR.get(material), enchanted);
            this.material = material;
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "Enchanted Random " + this.material.name() + " Armor" : "Random " + this.material.name() + " Armor";
        }
    }

    public static class CertainMaterialTool
    extends RandomLoot {
        private Item.ToolMaterial material;

        public CertainMaterialTool(Item.ToolMaterial material, boolean enchanted) {
            super((List)MATERIAL_TOOLS.get(material), enchanted);
            this.material = material;
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "Enchanted Random " + this.material.name() + " Tool" : "Random " + this.material.name() + " Tool";
        }
    }

    public static class SplashPotion
    extends RandomLoot {
        public SplashPotion() {
            super(null, false);
        }

        @Override
        public String getDisplayName() {
            return "A Random Splash Potion";
        }

        @Override
        public ItemStack getLoot() {
            ItemStack loot = ((ItemStack)SPLASH_POTIONS.get(MathUtil.nextInt((int)SPLASH_POTIONS.size()))).func_77946_l();
            loot.field_77994_a = MathUtil.getRandomIntegerBetween((int)2, (int)6);
            return loot;
        }
    }

    public static class Potion
    extends RandomLoot {
        public Potion() {
            super(null, false);
        }

        @Override
        public String getDisplayName() {
            return "A Random Potion";
        }

        @Override
        public ItemStack getLoot() {
            ItemStack loot = ((ItemStack)POTIONS.get(MathUtil.nextInt((int)POTIONS.size()))).func_77946_l();
            loot.field_77994_a = MathUtil.getRandomIntegerBetween((int)2, (int)6);
            return loot;
        }
    }

    public static class Food
    extends RandomLoot {
        public Food() {
            super(FOOD, false);
        }

        @Override
        public String getDisplayName() {
            return "A Random Food Item";
        }
    }

    public static class Boots
    extends RandomLoot {
        public Boots(boolean enchanted) {
            super(BOOTS, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "Enchanted Random Boots" : "Random Boots";
        }
    }

    public static class Leggings
    extends RandomLoot {
        public Leggings(boolean enchanted) {
            super(LEGGINGS, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "Enchanted Random Leggings" : "Random Leggings";
        }
    }

    public static class Chestplate
    extends RandomLoot {
        public Chestplate(boolean enchanted) {
            super(CHESTPLATES, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Chestplate" : "A Random Chestplate";
        }
    }

    public static class Helmet
    extends RandomLoot {
        public Helmet(boolean enchanted) {
            super(HELMETS, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Helmet" : "A Random Helmet";
        }
    }

    public static class Hoe
    extends RandomLoot {
        public Hoe(boolean enchanted) {
            super(HOES, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Hoe" : "A Random Hoe";
        }
    }

    public static class Axe
    extends RandomLoot {
        public Axe(boolean enchanted) {
            super(AXES, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Axe" : "A Random Axe";
        }
    }

    public static class Sword
    extends RandomLoot {
        public Sword(boolean enchanted) {
            super(SWORDS, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Sword" : "A Random Sword";
        }
    }

    public static class Shovel
    extends RandomLoot {
        public Shovel(boolean enchanted) {
            super(SHOVELS, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Shovel" : "A Random Shovel";
        }
    }

    public static class Pickaxe
    extends RandomLoot {
        public Pickaxe(boolean enchanted) {
            super(PICKAXES, enchanted);
        }

        @Override
        public String getDisplayName() {
            return this.enchanted ? "An Enchanted Random Pickaxe" : "A Random Pickaxe";
        }
    }
}

