/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.ChannelHandler;
import ichun.common.core.network.PacketHandler;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import portalgun.client.core.ClientProxy;
import portalgun.common.behavior.BehaviorDispensePortalGun;
import portalgun.common.behavior.BehaviorDispenseTurret;
import portalgun.common.core.ChunkLoadHandler;
import portalgun.common.core.CommonProxy;
import portalgun.common.core.EventHandler;
import portalgun.common.core.Settings;
import portalgun.common.entity.EntityPortalBall;
import portalgun.common.packet.PacketAFPInfo;
import portalgun.common.packet.PacketBePortalled;
import portalgun.common.packet.PacketCHex;
import portalgun.common.packet.PacketGrabEntity;
import portalgun.common.packet.PacketHeartCube;
import portalgun.common.packet.PacketKeyBind;
import portalgun.common.packet.PacketLaunchedByAFP;
import portalgun.common.packet.PacketPlayTurretSerenade;
import portalgun.common.packet.PacketSpawnerInfo;
import portalgun.common.packet.PacketUpdateOverlay;
import portalgun.common.packet.PacketUpdatePlayerColour;
import portalgun.common.packet.PacketWorldProps;
import portalgun.common.tileentity.TileEntityPortalMod;

@Mod(modid="PortalGun", name="PortalGun", version="4.0.0-beta-2", dependencies="required-after:iChunUtil@[4.2.2,)")
public class PortalGun {
    public static final String version = "4.0.0-beta-2";
    public static CreativeTabs creativeTabPortalGun;
    public static Block blockDummy;
    public static Block blockPortal;
    public static Block blockMulti;
    public static Item itemDummy;
    public static Item itemBacon;
    public static Item itemPGBlue;
    public static Item itemPGOrange;
    public static Item itemPortalSpawner;
    public static Item itemPotato;
    public static Item itemDust;
    public static Item itemMiniBlackHole;
    public static Item itemPedestal;
    public static Item itemLFB;
    public static Item itemLFBs;
    public static Item itemAFP;
    public static Item itemMulti;
    public static Item itemTurret;
    public static Item itemRecordStillAlive;
    public static Item itemRecordRadioLoop;
    public static Item itemRecordWantYouGone;
    public static HashMap<String, Integer> cHex;
    public static HashMap<Integer, EnumModPart> modPartMap;
    public static int renderMultiBlock;
    public static boolean isBirthday;
    public static boolean isChristmas;
    public static boolean isAFDay;
    @Mod.Instance(value="PortalGun")
    public static PortalGun instance;
    @SidedProxy(clientSide="portalgun.client.core.ClientProxy", serverSide="portalgun.common.core.CommonProxy")
    public static CommonProxy proxy;
    private static final Logger logger;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        PortalGun.dateCheck();
        EventHandler handler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        PortalGun.mapModPartEnums();
        proxy.setupAndLoadProperties(event.getModConfigurationDirectory());
        proxy.loadResourcePack();
        channels = ChannelHandler.getChannelHandlers((String)"PortalGun", (Class[])new Class[]{PacketLaunchedByAFP.class, PacketPlayTurretSerenade.class, PacketAFPInfo.class, PacketBePortalled.class, PacketSpawnerInfo.class, PacketHeartCube.class, PacketKeyBind.class, PacketGrabEntity.class, PacketWorldProps.class, PacketUpdateOverlay.class, PacketCHex.class, PacketUpdatePlayerColour.class});
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("PortalGun", "1.7.10", version, false));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initModParts();
        proxy.initTickHandlers();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadHandler());
        proxy.initRenderersAndTextures();
        FMLInterModComms.sendMessage((String)"GraviGun", (String)"PortalGun", (String)"");
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.initCommands(event.getServer());
        BlockDispenser.field_149943_a.func_82595_a((Object)itemPGBlue, (Object)new BehaviorDispensePortalGun(event.getServer()));
        BlockDispenser.field_149943_a.func_82595_a((Object)itemPGOrange, (Object)new BehaviorDispensePortalGun(event.getServer()));
        BlockDispenser.field_149943_a.func_82595_a((Object)itemTurret, (Object)new BehaviorDispenseTurret(event.getServer()));
        this.clearMaps();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Settings.loadProperties(proxy instanceof ClientProxy, true, DimensionManager.getWorld((int)0).getChunkSaveLocation());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        PortalGun.proxy.tickHandlerServer.saveData(DimensionManager.getWorld((int)0));
        this.clearMaps();
        PortalGun.proxy.tickHandlerServer.data = null;
    }

    public void clearMaps() {
        PortalGun.proxy.tickHandlerServer.grabMap.clear();
        PortalGun.proxy.tickHandlerServer.portals.clear();
        PortalGun.proxy.tickHandlerServer.moonPortals.clear();
        PortalGun.proxy.tickHandlerServer.potatosProgression.clear();
        PortalGun.proxy.tickHandlerServer.lastSeenEntity.clear();
        PortalGun.proxy.tickHandlerServer.hasFallen.clear();
        ChunkLoadHandler.entTickets.clear();
        ChunkLoadHandler.portalTickets.clear();
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equalsIgnoreCase("addBlockIDToGrabList".toLowerCase())) {
                PortalGun.console("Received mod blacklist request from: " + m.getSender());
                Settings.setBlockIdsToMap(Settings.modBlockIds, m.getStringValue(), false);
                continue;
            }
            if (m.key.equalsIgnoreCase("addEntityToTurretException".toLowerCase())) {
                try {
                    Class<?> clz = Class.forName(m.getStringValue());
                    PortalGun.addEntityToTurretException(clz);
                    PortalGun.console("Adding class " + m.getStringValue() + " to turret exceptions by mod " + m.getSender() + ".");
                }
                catch (Exception e) {
                    PortalGun.console("Failed to add class " + m.getStringValue() + " to turret exceptions by mod " + m.getSender() + ".", true);
                }
                continue;
            }
            if (m.key.equalsIgnoreCase("BaconMod".toLowerCase())) {
                String[] split = m.getStringValue().split(", *");
                if (split.length != 2) {
                    PortalGun.console("Received invalid bacon replacement from " + m.getSender(), true);
                    continue;
                }
                Item item = null;
                try {
                    Class<?> clz = Class.forName(split[0]);
                    Object obj = null;
                    obj = ObfuscationReflectionHelper.getPrivateValue(clz, null, (String[])new String[]{split[1]});
                    if (obj instanceof ItemStack) {
                        item = ((ItemStack)obj).func_77973_b();
                    } else if (obj instanceof Item) {
                        item = (Item)obj;
                    }
                    if (item == null) continue;
                    itemBacon = item;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Overriding Bacon Gun's recipe with ").append(item).append(" by mod " + m.getSender());
                    PortalGun.console(sb.toString());
                    List recipes = CraftingManager.func_77594_a().func_77592_b();
                    block5: for (int i = recipes.size() - 1; i >= 0; --i) {
                        List ingredients;
                        ShapelessRecipes recipe;
                        if (!(recipes.get(i) instanceof ShapelessRecipes) || !(recipe = (ShapelessRecipes)recipes.get(i)).func_77571_b().func_77969_a(new ItemStack(itemPGBlue, 1, 3)) && !recipe.func_77571_b().func_77969_a(new ItemStack(itemPGOrange, 1, 3)) || (ingredients = recipe.field_77579_b).size() != 2) continue;
                        for (int j = 0; j < ingredients.size(); ++j) {
                            ItemStack is = (ItemStack)ingredients.get(j);
                            if (!is.func_77969_a(new ItemStack(Items.field_151147_al))) continue;
                            recipes.remove(i);
                            continue block5;
                        }
                    }
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemPGBlue, 1, 3), (Object[])new Object[]{new ItemStack(itemPGBlue, 1, 0), itemBacon});
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemPGOrange, 1, 3), (Object[])new Object[]{new ItemStack(itemPGOrange, 1, 0), itemBacon});
                }
                catch (Exception e) {
                    PortalGun.console("Received invalid bacon replacement from " + m.getSender(), true);
                }
                continue;
            }
            PortalGun.console("Received unrecognised IMCMessage from " + m.getSender(), true);
        }
    }

    public static void addBlockIDToGrabList(int i, int[] i1) {
        if (i1 == null) {
            Settings.modBlockIds.remove(i);
            PortalGun.console("Removed Block ID " + i + " from grabbing blacklist.");
        } else {
            Settings.modBlockIds.put(i, i1);
            PortalGun.console("Added Block ID " + i + " to grabbing blacklist. " + (i1.length != 0 && i1[0] == -1 ? "Not metadata specific." : "Metadata specific: " + Settings.intArrayToString(i1)));
        }
    }

    public static void addEntityToTurretException(Class cls) {
        if (EntityLivingBase.class.isAssignableFrom(cls) && !Settings.turretExceptions.contains(cls)) {
            Settings.turretExceptions.add(cls);
        }
    }

    public static void spawnPortalAt(World world, int i, int j, int k, TileEntity portalPair) {
        if (world == null || portalPair == null || !(portalPair instanceof TileEntityPortalMod)) {
            return;
        }
        TileEntityPortalMod tep = (TileEntityPortalMod)portalPair;
        EntityPortalBall ball = new EntityPortalBall(world, null, tep.colour == 1 ? 2 : 1, tep.owner);
        ball.func_70012_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 0.0f, 90.0f);
        ball.field_70179_y = 0.0;
        ball.field_70159_w = 0.0;
        ball.field_70181_x = 2.0;
        ball.field_70128_L = false;
        ball.func_70071_h_();
        if (world.func_147439_a(i, j, k) != blockPortal) {
            ball.func_70012_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 90.0f, 90.0f);
            ball.field_70179_y = 0.0;
            ball.field_70159_w = 0.0;
            ball.field_70181_x = 2.0;
            ball.field_70128_L = false;
            ball.func_70071_h_();
        }
        ball.func_70106_y();
    }

    public static void addPortalToList(TileEntityPortalMod tep) {
        StringBuilder sb = new StringBuilder().append(tep.func_145831_w() == null ? 0 : tep.func_145831_w().field_73011_w.field_76574_g).append(":").append(tep.getOwnerType(true));
        if (tep.func_145831_w() == null || !tep.func_145831_w().field_72995_K) {
            TileEntityPortalMod tep1 = PortalGun.proxy.tickHandlerServer.portals.get(sb.toString());
            if (tep1 != null && tep1 != tep && tep1.func_145831_w().func_147438_o(tep1.field_145851_c, tep1.field_145848_d, tep1.field_145849_e) == tep1) {
                tep1.removePortal();
            }
            if (PortalGun.proxy.tickHandlerServer.portals.get(sb.toString()) != tep.getBase()) {
                PortalGun.proxy.tickHandlerServer.portals.put(sb.toString(), tep.getBase());
                PortalGun.updateOverlay(tep.getBase(), null);
                ChunkLoadHandler.addPortalAsChunkLoader(tep.getBase());
            }
        } else {
            PortalGun.proxy.tickHandlerClient.portals.put(sb.toString(), tep.getBase());
        }
    }

    public static void removePortalFromList(TileEntityPortalMod tep) {
        if (tep.getBase() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tep.func_145831_w().field_73011_w.field_76574_g).append(":").append(tep.getOwnerType(true));
        if (tep.func_145831_w() == null || !tep.func_145831_w().field_72995_K) {
            TileEntityPortalMod tep1 = tep.getLink();
            if (tep1 != null) {
                tep1 = tep1.getBase();
            }
            if (tep1 != null && tep1.getLink() == tep.getBase()) {
                tep1.tepLink = null;
                tep1.isLinkSpacePortal = false;
                tep1.func_145831_w().func_147471_g(tep1.field_145851_c, tep1.field_145848_d, tep1.field_145849_e);
                if (tep1.tepPair != null) {
                    tep1.tepPair.isLinkSpacePortal = false;
                    tep1.func_145831_w().func_147471_g(tep1.tepPair.field_145851_c, tep1.tepPair.field_145848_d, tep1.tepPair.field_145849_e);
                }
            }
            tep.getBase().tepLink = null;
            if (PortalGun.proxy.tickHandlerServer.portals.containsKey(sb.toString())) {
                PortalGun.proxy.tickHandlerServer.portals.remove(sb.toString());
                PortalGun.updateOverlay(tep.getBase(), null);
            }
            ChunkLoadHandler.removePortalAsChunkLoader(tep.getBase());
        } else {
            PortalGun.proxy.tickHandlerClient.portals.remove(sb.toString());
        }
    }

    public static void updateOverlay(TileEntityPortalMod tep, String username) {
        EntityPlayerMP player;
        if (tep != null) {
            StringBuilder sb = new StringBuilder().append(tep.func_145831_w().field_73011_w.field_76574_g).append(":").append(tep.getOwnerType(true));
            if (tep.owner.equalsIgnoreCase("def") || tep.owner.equalsIgnoreCase("coopA") || tep.owner.equalsIgnoreCase("coopB")) {
                PacketHandler.sendToDimension(channels, (AbstractPacket)new PacketUpdateOverlay(1, new String[]{tep.getOwnerType(true)}, new boolean[]{PortalGun.proxy.tickHandlerServer.portals.get(sb.toString()) != null}), (int)tep.func_145831_w().field_73011_w.field_76574_g);
            } else {
                EntityPlayerMP player2 = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(tep.owner.substring(0, tep.owner.length() - 2));
                if (player2 != null) {
                    PacketHandler.sendToPlayer(channels, (AbstractPacket)new PacketUpdateOverlay(1, new String[]{tep.getOwnerType(true)}, new boolean[]{PortalGun.proxy.tickHandlerServer.portals.get(sb.toString()) != null}), (EntityPlayer)player2);
                }
            }
        }
        if (username != null && !username.equalsIgnoreCase("") && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(username)) != null) {
            String[] names = new String[]{"def", "coopA", "coopB", username + "_A", username + "_B"};
            String[] realName = new String[names.length * 2];
            boolean[] states = new boolean[names.length * 2];
            for (int i = 0; i < names.length * 2; ++i) {
                StringBuilder sb = new StringBuilder().append(player.field_71093_bK).append(":").append(names[(int)Math.floor((float)i / 2.0f)]);
                realName[i] = names[(int)Math.floor((float)i / 2.0f)] + (i % 2 == 0 ? "1" : "2");
                states[i] = PortalGun.proxy.tickHandlerServer.portals.get(sb.toString() + (i % 2 == 0 ? "1" : "2")) != null;
            }
            PacketHandler.sendToPlayer(channels, (AbstractPacket)new PacketUpdateOverlay(10, realName, states), (EntityPlayer)player);
        }
    }

    public static boolean isEntityTurretException(EntityLivingBase ent) {
        return Settings.isEntityTurretException(ent);
    }

    public static int getSettings(String s) {
        return Settings.getSettings(s);
    }

    public static int getCHex(String s) {
        try {
            return Integer.parseInt(cHex.get(s).toString());
        }
        catch (NullPointerException e) {
            int clr = 0;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && PortalGun.proxy.tickHandlerServer.data != null && (clr = PortalGun.proxy.tickHandlerServer.data.func_74762_e("chex_" + s)) != 0) {
                cHex.put(s, clr);
            }
            return clr;
        }
    }

    public static int[] getBlockMetaInMap(Map map, Block i) {
        return Settings.getBlockMetaInMap(map, i);
    }

    public static String getOwnerName(ItemStack is) {
        int dmg = is.func_77960_j();
        return dmg == 0 ? "def" : (dmg == 1 ? "coopA" : (dmg == 2 ? "coopB" : (dmg == 3 ? Minecraft.func_71410_x().func_110432_I().func_111285_a() + "_A" : (dmg == 4 ? Minecraft.func_71410_x().func_110432_I().func_111285_a() + "_B" : "def"))));
    }

    public static String getOwnerName(EntityPlayer player, int slot) {
        if (slot > 50) {
            return "def";
        }
        ItemStack is = player.field_71071_by.field_70462_a[slot];
        if (is == null) {
            return "def";
        }
        int dmg = is.func_77960_j();
        return dmg == 0 || dmg == 5 ? "def" : (dmg == 1 ? "coopA" : (dmg == 2 ? "coopB" : (dmg == 3 ? player.func_70005_c_() + "_A" : (dmg == 4 ? player.func_70005_c_() + "_B" : "def"))));
    }

    public static String getOwnerName(EntityLivingBase living, int slot) {
        if (living instanceof EntityPlayer) {
            return PortalGun.getOwnerName((EntityPlayer)living, slot);
        }
        ItemStack is = living.func_70694_bm();
        if (is == null) {
            return "def";
        }
        int dmg = is.func_77960_j();
        EntityPlayer player = living.field_70170_p.func_72856_b((Entity)living, 20.0);
        return dmg == 0 || dmg == 5 ? "def" : (dmg == 1 ? "coopA" : (dmg == 2 ? "coopB" : (player != null ? (dmg == 3 ? player.func_70005_c_() + "_A" : player.func_70005_c_() + "_B") : "def")));
    }

    public static void mapModPartEnums() {
        EnumModPart[] parts = new EnumModPart[]{EnumModPart.PORTAL, EnumModPart.LONGFALLBOOTS, EnumModPart.STORAGECUBES, EnumModPart.FIZZLER, EnumModPart.TURRETS, EnumModPart.FAITHPLATE, EnumModPart.HEP, EnumModPart.TDB, EnumModPart.CHECKPOINT, EnumModPart.DECORATIVE};
        for (int i = 0; i < parts.length; ++i) {
            modPartMap.put(i, parts[i]);
        }
    }

    public static EnumModPart getModPartEnum(int i) {
        EnumModPart part = modPartMap.get(i);
        if (part == null) {
            return EnumModPart.NULL;
        }
        return part;
    }

    public static boolean isModPartEnabled(EnumModPart part) {
        for (Map.Entry<Integer, EnumModPart> e : modPartMap.entrySet()) {
            if (e.getValue() != part) continue;
            return Settings.isModPartEnabled(e.getKey());
        }
        return false;
    }

    public static boolean isGrabbed(Entity ent) {
        if (ent.field_70170_p.field_72995_K) {
            return PortalGun.proxy.tickHandlerClient.grabMap.containsValue(ent.func_145782_y());
        }
        return PortalGun.proxy.tickHandlerServer.grabMap.containsValue(ent);
    }

    public static void dateCheck() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        if (calendar.get(2) + 1 == 12 && calendar.get(5) == 25) {
            isChristmas = true;
        }
        if (calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
            isAFDay = true;
        }
        if (calendar.get(2) + 1 == 3 && calendar.get(5) == 9) {
            isBirthday = true;
        }
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }

    public static void console(String s) {
        PortalGun.console(s, false);
    }

    public static void console(int i) {
        PortalGun.console(new Integer(i).toString());
    }

    public static void console(boolean b) {
        PortalGun.console(new Boolean(b).toString());
    }

    public static void console(float f) {
        PortalGun.console(new Float(f).toString());
    }

    public static void console(double d) {
        PortalGun.console(new Double(d).toString());
    }

    static {
        cHex = new HashMap();
        modPartMap = new HashMap();
        renderMultiBlock = 0;
        logger = LogManager.getLogger((String)"PortalGun");
    }

    public static enum EnumModPart {
        PORTAL,
        LONGFALLBOOTS,
        STORAGECUBES,
        FIZZLER,
        TURRETS,
        FAITHPLATE,
        HEP,
        TDB,
        CHECKPOINT,
        DECORATIVE,
        NULL;

    }
}

