/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import ichun.common.core.EntityHelperBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import portalgun.common.PortalGun;
import portalgun.common.core.Settings;
import portalgun.common.entity.EntityBlock;
import portalgun.common.entity.EntityCube;
import portalgun.common.entity.EntityHEP;
import portalgun.common.entity.EntityPedestal;
import portalgun.common.entity.EntityPortalBall;
import portalgun.common.entity.EntityRadio;
import portalgun.common.entity.EntityTurret;
import portalgun.common.item.ItemPortalGun;
import portalgun.common.item.ItemPortalGunBlue;
import portalgun.common.item.ItemPortalGunOrange;
import portalgun.common.tileentity.TileEntityPortalMod;

public class EntityHelper
extends EntityHelperBase {
    public static void spawnMoonPortal(World world, int colour, boolean active, String owner) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityPortalMod tep = new TileEntityPortalMod();
        tep.isSpacePortal = true;
        tep.func_145834_a(world);
        tep.setupPortal(1, 1, 0, colour, false, null, false, owner);
        if (active) {
            PortalGun.addPortalToList(tep);
            tep.findLink();
        } else {
            PortalGun.proxy.tickHandlerServer.moonPortals.put(tep, 0);
        }
    }

    public static void tryGrab(EntityLivingBase ent, boolean holdGun) {
        MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)ent, (double)4.0);
        boolean grabSuccess = false;
        if (mop != null) {
            if (mop.field_72308_g == null) {
                boolean grabable;
                Block bId;
                if (holdGun && (bId = ent.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) != Blocks.field_150350_a && bId.func_149712_f(ent.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) >= 0.0f && (grabable = EntityHelper.canGrab(bId, ent.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d))) && (!(ent instanceof EntityZombie) || ent instanceof EntityZombie && ent.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) && (bId.func_149637_q() || bId.func_149645_b() == 22 && PortalGun.getSettings("grabChestTypeAllowed") == 1 || bId == Blocks.field_150359_w || bId == Blocks.field_150426_aN || bId == Blocks.field_150414_aQ || bId == Blocks.field_150335_W || bId == Blocks.field_150432_aD || bId instanceof BlockSlab || bId == Blocks.field_150467_bQ)) {
                    EntityBlock entBlock = new EntityBlock(ent.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
                    ent.field_70170_p.func_72838_d((Entity)entBlock);
                    PortalGun.proxy.tickHandlerServer.setGrabbed(ent, entBlock);
                    grabSuccess = true;
                }
            } else if (ent.field_70154_o != mop.field_72308_g && ent.field_70153_n != mop.field_72308_g) {
                boolean grabable = false;
                if (!(mop.field_72308_g instanceof EntityPedestal) && !(mop.field_72308_g instanceof EntityHEP) && !(mop.field_72308_g instanceof EntityPainting) && !(mop.field_72308_g instanceof EntityPlayer) && !(mop.field_72308_g instanceof EntityDragon) && !(mop.field_72308_g instanceof EntityDragonPart) || mop.field_72308_g instanceof EntityPlayer && (PortalGun.getSettings("grabablePlayers") == 1 || PortalGun.getSettings("grabablePlayers") == 2 && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(((EntityPlayer)mop.field_72308_g).func_146103_bH()))) {
                    EntityTurret turret;
                    if (mop.field_72308_g instanceof EntityBlock && !((EntityBlock)mop.field_72308_g).dummy || mop.field_72308_g instanceof EntityCube || mop.field_72308_g instanceof EntityRadio || mop.field_72308_g instanceof EntityTurret) {
                        grabable = true;
                    } else if (PortalGun.getSettings("grabEntityMode") == 1) {
                        grabable = true;
                    } else if (PortalGun.getSettings("grabEntityMode") == 2 && mop.field_72308_g instanceof EntityLivingBase) {
                        grabable = true;
                    }
                    if (mop.field_72308_g instanceof EntityTurret && (turret = (EntityTurret)mop.field_72308_g).getBouncy()) {
                        grabable = false;
                    }
                }
                if (grabable && (holdGun || mop.field_72308_g instanceof EntityCube || mop.field_72308_g instanceof EntityRadio)) {
                    if (mop.field_72308_g.field_70154_o != null) {
                        PortalGun.proxy.tickHandlerServer.setGrabbed(ent, mop.field_72308_g.field_70154_o);
                    } else {
                        PortalGun.proxy.tickHandlerServer.setGrabbed(ent, mop.field_72308_g);
                    }
                    grabSuccess = true;
                }
            }
        }
        if (holdGun) {
            if (grabSuccess) {
                ent.field_70170_p.func_72956_a((Entity)ent, "portalgun:object_use_start_", 0.3f, 1.0f);
            } else {
                ent.field_70170_p.func_72956_a((Entity)ent, "portalgun:object_use_failure_", 0.3f, 1.0f);
            }
        }
    }

    public static boolean canGrab(Block block, int metadata) {
        int[] modMeta;
        boolean grabable = true;
        int[] meta = PortalGun.getBlockMetaInMap(Settings.grabBlockIds, block);
        if (PortalGun.getSettings("grabBlockWhitelist") == 1) {
            grabable = false;
        }
        if (meta != null) {
            int j1;
            if (PortalGun.getSettings("grabBlockWhitelist") == 1) {
                if (meta.length != 0 && meta[0] == -1) {
                    grabable = true;
                }
                for (j1 = 0; j1 < meta.length; ++j1) {
                    if (metadata != meta[j1]) continue;
                    grabable = true;
                    break;
                }
            } else if (meta.length != 0 && meta[0] == -1) {
                grabable = false;
            } else {
                for (j1 = 0; j1 < meta.length; ++j1) {
                    if (metadata != meta[j1]) continue;
                    grabable = false;
                    break;
                }
            }
        }
        if ((modMeta = PortalGun.getBlockMetaInMap(Settings.modBlockIds, block)) != null) {
            if (modMeta.length != 0 && modMeta[0] == -1) {
                grabable = false;
            } else {
                for (int j1 = 0; j1 < modMeta.length; ++j1) {
                    if (metadata != modMeta[j1]) continue;
                    grabable = false;
                    break;
                }
            }
        }
        return grabable;
    }

    public static boolean shootPortal(EntityLivingBase living, ItemStack is, int key) {
        EntityPlayer player = null;
        if (living instanceof EntityPlayer) {
            player = (EntityPlayer)living;
        }
        if (PortalGun.proxy.tickHandlerServer.getGrabbed(living) != null) {
            if (key == 1) {
                Entity grabbed = PortalGun.proxy.tickHandlerServer.getGrabbed(living);
                double d = living.field_70165_t - grabbed.field_70165_t;
                double d1 = living.field_70161_v - grabbed.field_70161_v;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                grabbed.field_70160_al = true;
                float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
                float f1 = 0.4f;
                grabbed.field_70159_w -= 0.5 * (d / (double)f) * (double)f1;
                grabbed.field_70181_x = grabbed.field_70181_x + 0.5 * (grabbed instanceof EntityLivingBase ? 0.6 : (double)0.4f);
                grabbed.field_70179_y -= 0.5 * (d1 / (double)f) * (double)f1;
            }
            PortalGun.proxy.tickHandlerServer.setGrabbed(living, null);
            if (player != null ? player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemPortalGun : living.func_70694_bm() != null && living.func_70694_bm().func_77973_b() instanceof ItemPortalGun) {
                living.field_70170_p.func_72956_a((Entity)living, "portalgun:object_use_stop_", 0.3f, 1.0f);
            }
        } else if (!(is == null || (is.func_77960_j() >= 5 || !(is.func_77973_b() instanceof ItemPortalGun)) && (is.func_77960_j() != 5 || key == 1 && is.func_77973_b() instanceof ItemPortalGunOrange || key == 2 && is.func_77973_b() instanceof ItemPortalGunBlue))) {
            if (EntityHelper.isLookingAtMoon((World)living.field_70170_p, (EntityLivingBase)living, (float)0.0f, (PortalGun.getSettings("canShootPortalsThroughGlass") == 1 ? 1 : 0) != 0)) {
                if (PortalGun.getSettings("enableMoonPortals") == 0) {
                    if (player != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Server has disabled shooting portals on the moon"));
                    }
                } else if (!(PortalGun.getSettings("enableMoonPortals") == 1 || PortalGun.getSettings("enableMoonPortals") == 2 && player != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(player.func_146103_bH()))) {
                    if (player != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Server only allows shooting portals on the moon to players who are allowed to execute commands"));
                    }
                } else {
                    EntityHelper.spawnMoonPortal(player.field_70170_p, key, false, PortalGun.getOwnerName(living, player != null ? player.field_71071_by.field_70461_c : 0));
                }
            }
            EntityPortalBall ball = new EntityPortalBall(living.field_70170_p, (Entity)living, key, PortalGun.getOwnerName(living, player != null ? player.field_71071_by.field_70461_c : 0));
            living.field_70170_p.func_72838_d((Entity)ball);
            if (key == 1) {
                if (is.func_77973_b() instanceof ItemPortalGunOrange && is.func_77960_j() != 5) {
                    if (player != null) {
                        ItemStack is1 = new ItemStack(PortalGun.itemPGBlue, 1, player.func_71045_bC().func_77960_j());
                        is1.func_77982_d(player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77978_p());
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = is1;
                    } else {
                        ItemStack is1 = new ItemStack(PortalGun.itemPGBlue, 1, living.func_70694_bm().func_77960_j());
                        is1.func_77982_d(living.func_70694_bm().func_77978_p());
                        living.func_70062_b(0, is1);
                    }
                }
                living.field_70170_p.func_72956_a((Entity)living, "portalgun:wpn_portal_gun_fire_b", 0.3f, 1.0f);
            } else {
                if (is.func_77973_b() instanceof ItemPortalGunBlue && is.func_77960_j() != 5) {
                    if (player != null) {
                        ItemStack is1 = new ItemStack(PortalGun.itemPGOrange, 1, player.func_71045_bC().func_77960_j());
                        is1.func_77982_d(player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77978_p());
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = is1;
                    } else {
                        ItemStack is1 = new ItemStack(PortalGun.itemPGOrange, 1, living.func_70694_bm().func_77960_j());
                        is1.func_77982_d(living.func_70694_bm().func_77978_p());
                        living.func_70062_b(0, is1);
                    }
                }
                living.field_70170_p.func_72956_a((Entity)living, "portalgun:wpn_portal_gun_fire_r", 0.3f, 1.0f);
            }
        }
        return true;
    }

    public static boolean holdingPortalGun(EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        return is != null && is.func_77973_b() instanceof ItemPortalGun;
    }

    public static boolean holdingPotatoGun(EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        return is != null && is.func_77973_b() instanceof ItemPortalGun && is.func_77960_j() == 4;
    }

    public static boolean isEntityWearingLFB(Entity ent) {
        EntityZombie zombie;
        ItemStack ar0;
        if (ent instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ent;
            ItemStack ar02 = player.field_71071_by.field_70460_b[0];
            if (ar02 != null && ar02.func_77973_b() == PortalGun.itemLFBs) {
                return true;
            }
        } else if (ent instanceof EntityZombie && (ar0 = (zombie = (EntityZombie)ent).func_71124_b(1)) != null && ar0.func_77973_b() == PortalGun.itemLFBs) {
            return true;
        }
        return false;
    }
}

