/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.smart.render.IModelPlayer;
import net.smart.render.ModelCapeRenderer;
import net.smart.render.ModelEarsRenderer;
import net.smart.render.ModelRotationRenderer;
import net.smart.render.RendererData;
import net.smart.render.SmartRenderContext;
import net.smart.render.SmartRenderInstall;
import net.smart.render.SmartRenderRender;
import net.smart.utilities.Reflect;
import org.lwjgl.opengl.GL11;

public class SmartRenderModel
extends SmartRenderContext {
    public IModelPlayer imp;
    public ModelBiped mp;
    public boolean isModelPlayer;
    public boolean smallArms;
    public boolean isInventory;
    public int scaleArmType;
    public int scaleLegType;
    public float totalVerticalDistance;
    public float currentVerticalSpeed;
    public float totalDistance;
    public float currentSpeed;
    public double distance;
    public double verticalDistance;
    public double horizontalDistance;
    public float currentCameraAngle;
    public float currentVerticalAngle;
    public float currentHorizontalAngle;
    public float actualRotation;
    public float forwardRotation;
    public float workingAngle;
    public ModelRotationRenderer bipedOuter;
    public ModelRotationRenderer bipedTorso;
    public ModelRotationRenderer bipedBody;
    public ModelRotationRenderer bipedBreast;
    public ModelRotationRenderer bipedNeck;
    public ModelRotationRenderer bipedHead;
    public ModelRotationRenderer bipedRightShoulder;
    public ModelRotationRenderer bipedRightArm;
    public ModelRotationRenderer bipedLeftShoulder;
    public ModelRotationRenderer bipedLeftArm;
    public ModelRotationRenderer bipedPelvic;
    public ModelRotationRenderer bipedRightLeg;
    public ModelRotationRenderer bipedLeftLeg;
    public ModelRotationRenderer bipedBodywear;
    public ModelRotationRenderer bipedHeadwear;
    public ModelRotationRenderer bipedRightArmwear;
    public ModelRotationRenderer bipedLeftArmwear;
    public ModelRotationRenderer bipedRightLegwear;
    public ModelRotationRenderer bipedLeftLegwear;
    public ModelEarsRenderer bipedEars;
    public ModelCapeRenderer bipedCloak;
    public boolean disabled;
    public boolean attemptToCallRenderCape;
    public RendererData prevOuterRenderData;
    public boolean isSleeping;
    public boolean firstPerson;
    private static final Field _textureOffsetX = Reflect.GetField(ModelRenderer.class, SmartRenderInstall.ModelRenderer_textureOffsetX);
    private static final Field _textureOffsetY = Reflect.GetField(ModelRenderer.class, SmartRenderInstall.ModelRenderer_textureOffsetY);

    public SmartRenderModel(boolean b, ModelBiped mb, IModelPlayer imp, ModelRenderer originalBipedBody, ModelRenderer originalBipedBodywear, ModelRenderer originalBipedHead, ModelRenderer originalBipedHeadwear, ModelRenderer originalBipedRightArm, ModelRenderer originalBipedRightArmwear, ModelRenderer originalBipedLeftArm, ModelRenderer originalBipedLeftArmwear, ModelRenderer originalBipedRightLeg, ModelRenderer originalBipedRightLegwear, ModelRenderer originalBipedLeftLeg, ModelRenderer originalBipedLeftLegwear, ModelRenderer originalBipedCape, ModelRenderer originalBipedDeadmau5Head) {
        this.imp = imp;
        this.mp = mb;
        this.isModelPlayer = this.mp instanceof ModelPlayer;
        this.smallArms = b;
        mb.field_78092_r.clear();
        this.bipedOuter = this.create(null);
        this.bipedOuter.fadeEnabled = true;
        this.bipedTorso = this.create(this.bipedOuter);
        this.bipedBody = this.create(this.bipedTorso, originalBipedBody);
        this.bipedBreast = this.create(this.bipedTorso);
        this.bipedNeck = this.create(this.bipedBreast);
        this.bipedHead = this.create(this.bipedNeck, originalBipedHead);
        this.bipedRightShoulder = this.create(this.bipedBreast);
        this.bipedRightArm = this.create(this.bipedRightShoulder, originalBipedRightArm);
        this.bipedLeftShoulder = this.create(this.bipedBreast);
        this.bipedLeftShoulder.field_78809_i = true;
        this.bipedLeftArm = this.create(this.bipedLeftShoulder, originalBipedLeftArm);
        this.bipedPelvic = this.create(this.bipedTorso);
        this.bipedRightLeg = this.create(this.bipedPelvic, originalBipedRightLeg);
        this.bipedLeftLeg = this.create(this.bipedPelvic, originalBipedLeftLeg);
        this.bipedBodywear = this.create(this.bipedBody, originalBipedBodywear);
        this.bipedHeadwear = this.create(this.bipedHead, originalBipedHeadwear);
        this.bipedRightArmwear = this.create(this.bipedRightArm, originalBipedRightArmwear);
        this.bipedLeftArmwear = this.create(this.bipedLeftArm, originalBipedLeftArmwear);
        this.bipedRightLegwear = this.create(this.bipedRightLeg, originalBipedRightLegwear);
        this.bipedLeftLegwear = this.create(this.bipedLeftLeg, originalBipedLeftLegwear);
        if (originalBipedCape != null) {
            this.bipedCloak = new ModelCapeRenderer((ModelBase)mb, 0, 0, this.bipedBreast, this.bipedOuter);
            SmartRenderModel.copy(this.bipedCloak, originalBipedCape);
        }
        if (originalBipedDeadmau5Head != null) {
            this.bipedEars = new ModelEarsRenderer((ModelBase)mb, 24, 0, this.bipedHead);
            SmartRenderModel.copy(this.bipedEars, originalBipedDeadmau5Head);
        }
        this.reset();
        imp.initialize(this.bipedBody, this.bipedBodywear, this.bipedHead, this.bipedHeadwear, this.bipedRightArm, this.bipedRightArmwear, this.bipedLeftArm, this.bipedLeftArmwear, this.bipedRightLeg, this.bipedRightLegwear, this.bipedLeftLeg, this.bipedLeftLegwear, this.bipedCloak, this.bipedEars);
        if (SmartRenderRender.CurrentMainModel != null) {
            this.isInventory = SmartRenderRender.CurrentMainModel.isInventory;
            this.totalVerticalDistance = SmartRenderRender.CurrentMainModel.totalVerticalDistance;
            this.currentVerticalSpeed = SmartRenderRender.CurrentMainModel.currentVerticalSpeed;
            this.totalDistance = SmartRenderRender.CurrentMainModel.totalDistance;
            this.currentSpeed = SmartRenderRender.CurrentMainModel.currentSpeed;
            this.distance = SmartRenderRender.CurrentMainModel.distance;
            this.verticalDistance = SmartRenderRender.CurrentMainModel.verticalDistance;
            this.horizontalDistance = SmartRenderRender.CurrentMainModel.horizontalDistance;
            this.currentCameraAngle = SmartRenderRender.CurrentMainModel.currentCameraAngle;
            this.currentVerticalAngle = SmartRenderRender.CurrentMainModel.currentVerticalAngle;
            this.currentHorizontalAngle = SmartRenderRender.CurrentMainModel.currentHorizontalAngle;
            this.prevOuterRenderData = SmartRenderRender.CurrentMainModel.prevOuterRenderData;
            this.isSleeping = SmartRenderRender.CurrentMainModel.isSleeping;
            this.actualRotation = SmartRenderRender.CurrentMainModel.actualRotation;
            this.forwardRotation = SmartRenderRender.CurrentMainModel.forwardRotation;
            this.workingAngle = SmartRenderRender.CurrentMainModel.workingAngle;
        }
    }

    private ModelRotationRenderer create(ModelRotationRenderer base) {
        return new ModelRotationRenderer((ModelBase)this.mp, -1, -1, base);
    }

    private ModelRotationRenderer create(ModelRotationRenderer base, ModelRenderer original) {
        if (original == null) {
            return null;
        }
        int textureOffsetX = (Integer)Reflect.GetField(_textureOffsetX, original);
        int textureOffsetY = (Integer)Reflect.GetField(_textureOffsetY, original);
        ModelRotationRenderer local = new ModelRotationRenderer((ModelBase)this.mp, textureOffsetX, textureOffsetY, base);
        SmartRenderModel.copy(local, original);
        return local;
    }

    private static void copy(ModelRotationRenderer local, ModelRenderer original) {
        if (original.field_78805_m != null) {
            for (Object childModel : original.field_78805_m) {
                local.func_78792_a((ModelRenderer)childModel);
            }
        }
        if (original.field_78804_l != null) {
            for (Object cube : original.field_78804_l) {
                local.field_78804_l.add(cube);
            }
        }
        local.field_78809_i = original.field_78809_i;
    }

    public void render(Entity entity, float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor) {
        GL11.glPushMatrix();
        if (entity.func_70093_af()) {
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.bipedLeftLeg.ignoreRender = true;
        this.bipedRightLeg.ignoreRender = true;
        this.bipedLeftArm.ignoreRender = true;
        this.bipedRightArm.ignoreRender = true;
        this.bipedHead.ignoreRender = true;
        this.bipedBody.ignoreRender = true;
        if (this.isModelPlayer) {
            this.bipedLeftLegwear.ignoreRender = true;
            this.bipedRightLegwear.ignoreRender = true;
            this.bipedLeftArmwear.ignoreRender = true;
            this.bipedRightArmwear.ignoreRender = true;
            this.bipedHeadwear.ignoreRender = true;
            this.bipedBodywear.ignoreRender = true;
        }
        this.imp.superRender(entity, totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.isModelPlayer) {
            this.bipedLeftLegwear.ignoreRender = false;
            this.bipedRightLegwear.ignoreRender = false;
            this.bipedLeftArmwear.ignoreRender = false;
            this.bipedRightArmwear.ignoreRender = false;
            this.bipedHeadwear.ignoreRender = false;
            this.bipedBodywear.ignoreRender = false;
        }
        this.bipedLeftLeg.ignoreRender = false;
        this.bipedRightLeg.ignoreRender = false;
        this.bipedLeftArm.ignoreRender = false;
        this.bipedRightArm.ignoreRender = false;
        this.bipedHead.ignoreRender = false;
        this.bipedBody.ignoreRender = false;
        this.bipedOuter.func_78785_a(factor);
        this.bipedOuter.renderIgnoreBase(factor);
        this.bipedTorso.renderIgnoreBase(factor);
        this.bipedBody.renderIgnoreBase(factor);
        this.bipedBreast.renderIgnoreBase(factor);
        this.bipedNeck.renderIgnoreBase(factor);
        this.bipedHead.renderIgnoreBase(factor);
        this.bipedRightShoulder.renderIgnoreBase(factor);
        this.bipedRightArm.renderIgnoreBase(factor);
        this.bipedLeftShoulder.renderIgnoreBase(factor);
        this.bipedLeftArm.renderIgnoreBase(factor);
        this.bipedPelvic.renderIgnoreBase(factor);
        this.bipedRightLeg.renderIgnoreBase(factor);
        this.bipedLeftLeg.renderIgnoreBase(factor);
        if (this.isModelPlayer) {
            this.bipedBodywear.renderIgnoreBase(factor);
            this.bipedHeadwear.renderIgnoreBase(factor);
            this.bipedRightArmwear.renderIgnoreBase(factor);
            this.bipedLeftArmwear.renderIgnoreBase(factor);
            this.bipedRightLegwear.renderIgnoreBase(factor);
            this.bipedLeftLegwear.renderIgnoreBase(factor);
        }
        GL11.glPopMatrix();
    }

    public void setRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float totalTime, float viewHorizontalAngelOffset, float viewVerticalAngelOffset, float factor, Entity entity) {
        this.reset();
        if (this.firstPerson || this.isInventory) {
            this.bipedBody.ignoreBase = true;
            this.bipedHead.ignoreBase = true;
            this.bipedRightArm.ignoreBase = true;
            this.bipedLeftArm.ignoreBase = true;
            this.bipedRightLeg.ignoreBase = true;
            this.bipedLeftLeg.ignoreBase = true;
            if (this.isModelPlayer) {
                this.bipedBodywear.ignoreBase = true;
                this.bipedHeadwear.ignoreBase = true;
                this.bipedRightArmwear.ignoreBase = true;
                this.bipedLeftArmwear.ignoreBase = true;
                this.bipedRightLegwear.ignoreBase = true;
                this.bipedLeftLegwear.ignoreBase = true;
                this.bipedEars.ignoreBase = true;
                this.bipedCloak.ignoreBase = true;
            }
            this.bipedBody.forceRender = this.firstPerson;
            this.bipedHead.forceRender = this.firstPerson;
            this.bipedRightArm.forceRender = this.firstPerson;
            this.bipedLeftArm.forceRender = this.firstPerson;
            this.bipedRightLeg.forceRender = this.firstPerson;
            this.bipedLeftLeg.forceRender = this.firstPerson;
            if (this.isModelPlayer) {
                this.bipedBodywear.forceRender = this.firstPerson;
                this.bipedHeadwear.forceRender = this.firstPerson;
                this.bipedRightArmwear.forceRender = this.firstPerson;
                this.bipedLeftArmwear.forceRender = this.firstPerson;
                this.bipedRightLegwear.forceRender = this.firstPerson;
                this.bipedLeftLegwear.forceRender = this.firstPerson;
                this.bipedEars.forceRender = this.firstPerson;
                this.bipedCloak.forceRender = this.firstPerson;
            }
            this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.bipedLeftLeg.func_78793_a(2.0f, 12.0f, 0.0f);
            this.imp.superSetRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor, entity);
            return;
        }
        if (this.isSleeping) {
            this.prevOuterRenderData.rotateAngleX = 0.0f;
            this.prevOuterRenderData.rotateAngleY = 0.0f;
            this.prevOuterRenderData.rotateAngleZ = 0.0f;
        }
        this.bipedOuter.previous = this.prevOuterRenderData;
        this.bipedOuter.field_78796_g = this.actualRotation / 57.295776f;
        this.bipedOuter.fadeRotateAngleY = entity.field_70154_o == null;
        this.imp.animateHeadRotation(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.isSleeping) {
            this.imp.animateSleeping(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        this.imp.animateArmSwinging(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.mp.field_78093_q) {
            this.imp.animateRiding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.field_78119_l != 0) {
            this.imp.animateLeftArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.field_78120_m != 0) {
            this.imp.animateRightArmItemHolding(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.field_78095_p > -9990.0f) {
            this.imp.animateWorkingBody(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
            this.imp.animateWorkingArms(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.mp.field_78117_n) {
            this.imp.animateSneaking(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        this.imp.animateArms(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        if (this.mp.field_78118_o) {
            this.imp.animateBowAiming(totalHorizontalDistance, currentHorizontalSpeed, totalTime, viewHorizontalAngelOffset, viewVerticalAngelOffset, factor);
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleX) {
            this.bipedOuter.previous.rotateAngleX = this.bipedOuter.field_78795_f;
        }
        if (this.bipedOuter.previous != null && !this.bipedOuter.fadeRotateAngleY) {
            this.bipedOuter.previous.rotateAngleY = this.bipedOuter.field_78796_g;
        }
        this.bipedOuter.fadeIntermediate(totalTime);
        this.bipedOuter.fadeStore(totalTime);
        if (this.isModelPlayer) {
            this.bipedCloak.ignoreBase = false;
            this.bipedCloak.field_78795_f = 0.09817477f;
        }
    }

    public void animateHeadRotation(float viewHorizontalAngelOffset, float viewVerticalAngelOffset) {
        this.bipedNeck.ignoreBase = true;
        this.bipedHead.field_78796_g = (this.actualRotation + viewHorizontalAngelOffset) / 57.295776f;
        this.bipedHead.field_78795_f = viewVerticalAngelOffset / 57.295776f;
    }

    public void animateSleeping() {
        this.bipedNeck.ignoreBase = false;
        this.bipedHead.field_78796_g = 0.0f;
        this.bipedHead.field_78795_f = 0.7853982f;
        this.bipedTorso.field_78798_e = -17.0f;
    }

    public void animateArmSwinging(float totalHorizontalDistance, float currentHorizontalSpeed) {
        this.bipedRightArm.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 2.0f * currentHorizontalSpeed * 0.5f;
        this.bipedLeftArm.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f)) * 2.0f * currentHorizontalSpeed * 0.5f;
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f)) * 1.4f * currentHorizontalSpeed;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 1.4f * currentHorizontalSpeed;
    }

    public void animateRiding() {
        this.bipedRightArm.field_78795_f += -0.6283185f;
        this.bipedLeftArm.field_78795_f += -0.6283185f;
        this.bipedRightLeg.field_78795_f = -1.256637f;
        this.bipedLeftLeg.field_78795_f = -1.256637f;
        this.bipedRightLeg.field_78796_g = 0.3141593f;
        this.bipedLeftLeg.field_78796_g = -0.3141593f;
    }

    public void animateLeftArmItemHolding() {
        this.bipedLeftArm.field_78795_f = this.bipedLeftArm.field_78795_f * 0.5f - 0.3141593f * (float)this.mp.field_78119_l;
    }

    public void animateRightArmItemHolding() {
        this.bipedRightArm.field_78795_f = this.bipedRightArm.field_78795_f * 0.5f - 0.3141593f * (float)this.mp.field_78120_m;
        if (this.mp.field_78120_m == 3) {
            this.bipedRightArm.field_78796_g = -0.5235988f;
        }
    }

    public void animateWorkingBody() {
        float angle = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)this.mp.field_78095_p) * ((float)Math.PI * 2))) * 0.2f;
        this.bipedBreast.field_78796_g = this.bipedBody.field_78796_g += angle;
        this.bipedBreast.rotationOrder = this.bipedBody.rotationOrder = ModelRotationRenderer.YXZ;
        this.bipedLeftArm.field_78795_f += angle;
    }

    public void animateWorkingArms() {
        float f6 = 1.0f - this.mp.field_78095_p;
        f6 = 1.0f - f6 * f6 * f6;
        float f7 = MathHelper.func_76126_a((float)(f6 * (float)Math.PI));
        float f8 = MathHelper.func_76126_a((float)(this.mp.field_78095_p * (float)Math.PI)) * -(this.bipedHead.field_78795_f - 0.7f) * 0.75f;
        this.bipedRightArm.field_78795_f = (float)((double)this.bipedRightArm.field_78795_f - ((double)f7 * 1.2 + (double)f8));
        this.bipedRightArm.field_78796_g += MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)this.mp.field_78095_p) * ((float)Math.PI * 2))) * 0.4f;
        this.bipedRightArm.field_78808_h -= MathHelper.func_76126_a((float)(this.mp.field_78095_p * (float)Math.PI)) * 0.4f;
    }

    public void animateSneaking() {
        this.bipedTorso.field_78795_f += 0.5f;
        this.bipedRightLeg.field_78795_f += -0.5f;
        this.bipedLeftLeg.field_78795_f += -0.5f;
        this.bipedRightArm.field_78795_f += -0.1f;
        this.bipedLeftArm.field_78795_f += -0.1f;
        this.bipedPelvic.field_82908_p = -0.13652f;
        this.bipedPelvic.field_82907_q = -0.05652f;
        this.bipedBreast.field_82908_p = -0.01872f;
        this.bipedBreast.field_82907_q = -0.07502f;
        this.bipedNeck.field_82908_p = 0.0621f;
    }

    public void animateArms(float totalTime) {
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    public void animateBowAiming(float totalTime) {
        this.bipedRightArm.field_78808_h = 0.0f;
        this.bipedLeftArm.field_78808_h = 0.0f;
        this.bipedRightArm.field_78796_g = -0.1f + this.bipedHead.field_78796_g - this.bipedOuter.field_78796_g;
        this.bipedLeftArm.field_78796_g = 0.1f + this.bipedHead.field_78796_g + 0.4f - this.bipedOuter.field_78796_g;
        this.bipedRightArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedLeftArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    public void reset() {
        this.bipedOuter.reset();
        this.bipedTorso.reset();
        this.bipedBody.reset();
        this.bipedBreast.reset();
        this.bipedNeck.reset();
        this.bipedHead.reset();
        this.bipedRightShoulder.reset();
        this.bipedRightArm.reset();
        this.bipedLeftShoulder.reset();
        this.bipedLeftArm.reset();
        this.bipedPelvic.reset();
        this.bipedRightLeg.reset();
        this.bipedLeftLeg.reset();
        if (this.isModelPlayer) {
            this.bipedBodywear.reset();
            this.bipedHeadwear.reset();
            this.bipedRightArmwear.reset();
            this.bipedLeftArmwear.reset();
            this.bipedRightLegwear.reset();
            this.bipedLeftLegwear.reset();
            this.bipedEars.reset();
            this.bipedCloak.reset();
        }
        this.bipedRightShoulder.func_78793_a(-5.0f, this.isModelPlayer && this.smallArms ? 2.5f : 2.0f, 0.0f);
        this.bipedLeftShoulder.func_78793_a(5.0f, this.isModelPlayer && this.smallArms ? 2.5f : 2.0f, 0.0f);
        this.bipedPelvic.func_78793_a(0.0f, 12.0f, 0.1f);
        this.bipedRightLeg.func_78793_a(-1.9f, 0.0f, 0.0f);
        this.bipedLeftLeg.func_78793_a(1.9f, 0.0f, 0.0f);
        if (this.isModelPlayer) {
            this.bipedCloak.func_78793_a(0.0f, 0.0f, 2.0f);
        }
    }

    public void renderCloak(float f) {
        this.attemptToCallRenderCape = true;
        if (!this.disabled) {
            this.imp.superRenderCloak(f);
        }
    }

    public ModelRenderer getRandomBox(Random par1Random) {
        List boxList = this.mp.field_78092_r;
        int size = boxList.size();
        int renderersWithBoxes = 0;
        for (int i = 0; i < size; ++i) {
            ModelRenderer renderer = (ModelRenderer)boxList.get(i);
            if (!SmartRenderModel.canBeRandomBoxSource(renderer)) continue;
            ++renderersWithBoxes;
        }
        if (renderersWithBoxes != 0) {
            int random = par1Random.nextInt(renderersWithBoxes);
            renderersWithBoxes = -1;
            for (int i = 0; i < size; ++i) {
                ModelRenderer renderer = (ModelRenderer)boxList.get(i);
                if (SmartRenderModel.canBeRandomBoxSource(renderer)) {
                    ++renderersWithBoxes;
                }
                if (renderersWithBoxes != random) continue;
                return renderer;
            }
        }
        return null;
    }

    private static boolean canBeRandomBoxSource(ModelRenderer renderer) {
        return renderer.field_78804_l != null && renderer.field_78804_l.size() > 0 && (!(renderer instanceof ModelRotationRenderer) || ((ModelRotationRenderer)renderer).canBeRandomBoxSource());
    }
}

