/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.smart.render.IModelPlayer;
import net.smart.render.IRenderPlayer;
import net.smart.render.RendererData;
import net.smart.render.SmartRenderContext;
import net.smart.render.SmartRenderModel;
import net.smart.render.statistics.SmartStatistics;
import net.smart.render.statistics.SmartStatisticsFactory;

public class SmartRenderRender
extends SmartRenderContext {
    public static SmartRenderModel CurrentMainModel;
    public IRenderPlayer irp;
    private static Map<EntityPlayer, RendererData> previousRendererData;
    private static int previousRendererDataAccessCounter;
    public final SmartRenderModel modelBipedMain;

    public SmartRenderRender(IRenderPlayer irp) {
        this.irp = irp;
        this.modelBipedMain = irp.createModel((ModelBiped)irp.getModelBipedMain(), 0.0f, irp.getSmallArms()).getRenderModel();
        SmartRenderModel modelArmorChestplate = irp.createModel(irp.getModelArmorChestplate(), 1.0f, false).getRenderModel();
        SmartRenderModel modelArmor = irp.createModel(irp.getModelArmor(), 0.5f, false).getRenderModel();
        irp.initialize((ModelPlayer)this.modelBipedMain.mp, modelArmorChestplate.mp, modelArmor.mp);
    }

    public void doRender(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        SmartStatistics statistics = SmartStatisticsFactory.getInstance((EntityPlayer)entityplayer);
        if (statistics != null) {
            boolean isInventory = d == 0.0 && d1 == 0.0 && d2 == 0.0 && f == 0.0f && renderPartialTicks == 1.0f;
            boolean isSleeping = entityplayer.func_70608_bn();
            float totalVerticalDistance = statistics.getTotalVerticalDistance(renderPartialTicks);
            float currentVerticalSpeed = statistics.getCurrentVerticalSpeed(renderPartialTicks);
            float totalDistance = statistics.getTotalDistance(renderPartialTicks);
            float currentSpeed = statistics.getCurrentSpeed(renderPartialTicks);
            double distance = 0.0;
            double verticalDistance = 0.0;
            double horizontalDistance = 0.0;
            float currentCameraAngle = 0.0f;
            float currentVerticalAngle = 0.0f;
            float currentHorizontalAngle = 0.0f;
            if (!isInventory) {
                double xDiff = entityplayer.field_70165_t - entityplayer.field_70169_q;
                double yDiff = entityplayer.field_70163_u - entityplayer.field_70167_r;
                double zDiff = entityplayer.field_70161_v - entityplayer.field_70166_s;
                verticalDistance = Math.abs(yDiff);
                horizontalDistance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                distance = Math.sqrt(horizontalDistance * horizontalDistance + verticalDistance * verticalDistance);
                currentCameraAngle = entityplayer.field_70177_z / 57.295776f;
                currentVerticalAngle = (float)Math.atan(yDiff / horizontalDistance);
                if (Float.isNaN(currentVerticalAngle)) {
                    currentVerticalAngle = 1.5707964f;
                }
                if (Float.isNaN(currentHorizontalAngle = (float)(-Math.atan(xDiff / zDiff)))) {
                    currentHorizontalAngle = Float.isNaN(statistics.prevHorizontalAngle) ? currentCameraAngle : statistics.prevHorizontalAngle;
                } else if (zDiff < 0.0) {
                    currentHorizontalAngle += (float)Math.PI;
                }
                statistics.prevHorizontalAngle = currentHorizontalAngle;
            }
            IModelPlayer[] modelPlayers = this.irp.getRenderModels();
            for (int i = 0; i < modelPlayers.length; ++i) {
                SmartRenderModel modelPlayer = modelPlayers[i].getRenderModel();
                modelPlayer.isInventory = isInventory;
                modelPlayer.totalVerticalDistance = totalVerticalDistance;
                modelPlayer.currentVerticalSpeed = currentVerticalSpeed;
                modelPlayer.totalDistance = totalDistance;
                modelPlayer.currentSpeed = currentSpeed;
                modelPlayer.distance = distance;
                modelPlayer.verticalDistance = verticalDistance;
                modelPlayer.horizontalDistance = horizontalDistance;
                modelPlayer.currentCameraAngle = currentCameraAngle;
                modelPlayer.currentVerticalAngle = currentVerticalAngle;
                modelPlayer.currentHorizontalAngle = currentHorizontalAngle;
                modelPlayer.prevOuterRenderData = SmartRenderRender.getPreviousRendererData((EntityPlayer)entityplayer);
                modelPlayer.isSleeping = isSleeping;
            }
        }
        CurrentMainModel = this.modelBipedMain;
        this.irp.superDoRender(entityplayer, d, d1, d2, f, renderPartialTicks);
        CurrentMainModel = null;
    }

    public void rotateCorpse(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        boolean isInventory;
        boolean isLocal = entityplayer instanceof EntityPlayerSP;
        boolean bl = isInventory = f2 == 1.0f && isLocal && Minecraft.func_71410_x().field_71462_r instanceof GuiInventory;
        if (!isInventory) {
            float workingAngle;
            float forwardRotation = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f2;
            if (entityplayer.func_70608_bn()) {
                actualRotation = 0.0f;
                forwardRotation = 0.0f;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            if (!isLocal) {
                workingAngle = -entityplayer.field_70177_z;
                workingAngle += minecraft.func_175606_aa().field_70177_z;
            } else {
                workingAngle = actualRotation - SmartRenderRender.getPreviousRendererData((EntityPlayer)entityplayer).rotateAngleY * 57.295776f;
            }
            if (minecraft.field_71474_y.field_74320_O == 2 && !((EntityPlayer)minecraft.func_175606_aa()).func_70608_bn()) {
                workingAngle += 180.0f;
            }
            IModelPlayer[] modelPlayers = this.irp.getRenderModels();
            for (int i = 0; i < modelPlayers.length; ++i) {
                SmartRenderModel modelPlayer = modelPlayers[i].getRenderModel();
                modelPlayer.actualRotation = actualRotation;
                modelPlayer.forwardRotation = forwardRotation;
                modelPlayer.workingAngle = workingAngle;
            }
            actualRotation = 0.0f;
        }
        this.irp.superRotateCorpse(entityplayer, totalTime, actualRotation, f2);
    }

    public void renderSpecials(AbstractClientPlayer entityPlayer, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.modelBipedMain.bipedEars.beforeRender((EntityPlayer)entityPlayer);
        this.modelBipedMain.bipedCloak.beforeRender((EntityPlayer)entityPlayer, f3);
        this.irp.superRenderSpecials(entityPlayer, f1, f2, f3, f4, f5, f6, f7);
        this.modelBipedMain.bipedCloak.afterRender();
        this.modelBipedMain.bipedEars.afterRender();
    }

    public void beforeHandleRotationFloat(AbstractClientPlayer entityPlayer, float f) {
        SmartStatistics statistics = SmartStatisticsFactory.getInstance((EntityPlayer)entityPlayer);
        if (statistics != null) {
            entityPlayer.field_70173_aa += statistics.ticksRiding;
        }
    }

    public void afterHandleRotationFloat(AbstractClientPlayer entityPlayer, float f) {
        SmartStatistics statistics = SmartStatisticsFactory.getInstance((EntityPlayer)entityPlayer);
        if (statistics != null) {
            entityPlayer.field_70173_aa -= statistics.ticksRiding;
        }
    }

    public static RendererData getPreviousRendererData(EntityPlayer entityplayer) {
        RendererData result;
        if (++previousRendererDataAccessCounter > 1000) {
            List players = Minecraft.func_71410_x().field_71441_e.field_73010_i;
            Iterator<EntityPlayer> iterator = previousRendererData.keySet().iterator();
            while (iterator.hasNext()) {
                if (players.contains(iterator.next())) continue;
                iterator.remove();
            }
            previousRendererDataAccessCounter = 0;
        }
        if ((result = previousRendererData.get(entityplayer)) == null) {
            result = new RendererData();
            previousRendererData.put(entityplayer, result);
        }
        return result;
    }

    static {
        previousRendererData = new HashMap<EntityPlayer, RendererData>();
        previousRendererDataAccessCounter = 0;
    }
}

