/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.smart.core.SmartCoreEventHandler;
import net.smart.moving.LocalUserNameProvider;
import net.smart.moving.SmartMovingComm;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.SmartMovingCoreEventHandler;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.SmartMovingServer;
import net.smart.moving.SmartMovingServerComm;
import net.smart.moving.config.SmartMovingConfig;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.moving.playerapi.SmartMoving;
import net.smart.moving.playerapi.SmartMovingServerPlayerBase;
import net.smart.moving.render.RenderPlayer;
import net.smart.render.SmartRenderContext;
import net.smart.render.SmartRenderMod;
import net.smart.utilities.Assert;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

@Mod(modid="SmartMoving", name="Smart Moving", version="16.0")
public class SmartMovingMod {
    private final boolean isClient;
    private boolean hasRenderer = false;

    public SmartMovingMod() {
        Assert.clientPlayerAPI("Smart Moving");
        Assert.serverPlayerAPI("Smart Moving");
        this.isClient = FMLCommonHandler.instance().getSide().isClient();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.newEventDrivenChannel(SmartMovingPacketStream.Id).register((Object)this);
        if (this.isClient) {
            this.hasRenderer = Assert.hasRenderPlayerAPI;
            SmartMoving.register();
            if (this.hasRenderer) {
                Class<?> type = Reflect.LoadClass(SmartMovingMod.class, new Name("net.smart.moving.render.playerapi.SmartMoving"), true);
                Method method = Reflect.GetMethod(type, new Name("register"), new Class[0]);
                Reflect.Invoke(method, null, new Object[0]);
            } else {
                SmartRenderMod.doNotAddRenderer();
            }
            SmartMovingServerComm.localUserNameProvider = new LocalUserNameProvider();
            if (!this.hasRenderer) {
                SmartRenderContext.registerRenderers(RenderPlayer.class);
            }
            this.registerGameTicks();
            net.smart.moving.playerapi.SmartMovingFactory.initialize();
            this.checkForPresentModsAndInitializeOptions();
            SmartMovingContext.initialize();
        } else {
            SmartMovingServer.initialize(new File("."), FMLLog.getLogger(), FMLCommonHandler.instance().getMinecraftServerInstance().func_71265_f().func_77148_a(), new SmartMovingConfig());
        }
        SmartCoreEventHandler.Add((SmartCoreEventHandler)new SmartMovingCoreEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.isClient) {
            SmartMovingServerPlayerBase.registerPlayerBase();
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        SmartMovingContext.onTickInGame();
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        SmartMovingPacketStream.receivePacket(event.packet, SmartMovingServerComm.instance, SmartMovingServerPlayerBase.getPlayerBase(((NetHandlerPlayServer)event.handler).field_147369_b));
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        SmartMovingPacketStream.receivePacket(event.packet, SmartMovingComm.instance, null);
    }

    public void registerGameTicks() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public Object getInstance(EntityPlayer entityPlayer) {
        return SmartMovingFactory.getInstance(entityPlayer);
    }

    public Object getClient() {
        return SmartMovingContext.Client;
    }

    public void checkForPresentModsAndInitializeOptions() {
        List modList = Loader.instance().getActiveModList();
        boolean hasRedPowerWiring = false;
        boolean hasBuildCraftTransport = false;
        boolean hasFiniteLiquid = false;
        boolean hasBetterThanWolves = false;
        boolean hasSinglePlayerCommands = false;
        boolean hasRopesPlus = false;
        boolean hasASGrapplingHook = false;
        boolean hasBetterMisc = false;
        for (int i = 0; i < modList.size(); ++i) {
            ModContainer mod = (ModContainer)modList.get(i);
            String name = mod.getName();
            if (name.contains("RedPowerWiring")) {
                hasRedPowerWiring = true;
                continue;
            }
            if (name.contains("BuildCraftTransport")) {
                hasBuildCraftTransport = true;
                continue;
            }
            if (name.contains("Liquid")) {
                hasFiniteLiquid = true;
                continue;
            }
            if (name.contains("FCBetterThanWolves")) {
                hasBetterThanWolves = true;
                continue;
            }
            if (name.contains("SinglePlayerCommands")) {
                hasSinglePlayerCommands = true;
                continue;
            }
            if (name.contains("ASGrapplingHook")) {
                hasASGrapplingHook = true;
                continue;
            }
            if (!name.contains("BetterMisc")) continue;
            hasBetterMisc = true;
        }
        hasRopesPlus = Reflect.CheckClasses(SmartMovingMod.class, SmartMovingInstall.RopesPlusCore);
        SmartMovingOptions.initialize(hasRedPowerWiring, hasBuildCraftTransport, hasFiniteLiquid, hasBetterThanWolves, hasSinglePlayerCommands, hasRopesPlus, hasASGrapplingHook, hasBetterMisc);
    }
}

