/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.io.File;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.config.SmartMovingConfig;
import net.smart.moving.config.SmartMovingServerOptions;
import net.smart.properties.Property;
import org.apache.logging.log4j.Logger;

public class SmartMovingServer {
    public static final float SmallSizeItemGrabHeight = 0.25f;
    protected final IEntityPlayerMP mp;
    private boolean resetFallDistance = false;
    private boolean resetTicksForFloatKick = false;
    private boolean initialized = false;
    private boolean withinOnLivingUpdate = false;
    public boolean crawlingInitialized;
    public int crawlingCooldown;
    public boolean isCrawling;
    public boolean isSmall;
    public float hunger;
    private int disableAddExhaustionDepth;
    private boolean disableAddExhaustion;
    public static SmartMovingConfig Options = null;
    private static SmartMovingServerOptions optionsHandler = null;

    public SmartMovingServer(IEntityPlayerMP mp, boolean onTheFly) {
        this.mp = mp;
        if (onTheFly) {
            this.initialize(true);
        }
    }

    public void initialize(boolean alwaysSendMessage) {
        if (((Boolean)SmartMovingServer.Options._globalConfig.value).booleanValue()) {
            SmartMovingPacketStream.sendConfigContent(this.mp, optionsHandler.writeToProperties(), null);
        } else if (((Boolean)SmartMovingServer.Options._serverConfig.value).booleanValue()) {
            SmartMovingPacketStream.sendConfigContent(this.mp, optionsHandler.writeToProperties(this.mp, false), null);
        } else if (alwaysSendMessage) {
            SmartMovingPacketStream.sendConfigContent(this.mp, SmartMovingServer.Options.enabled ? new String[]{} : null, null);
        }
        this.initialized = true;
    }

    public void processStatePacket(FMLProxyPacket packet, long state) {
        if (!this.initialized) {
            this.initialize(false);
        }
        boolean isCrawling = (state >>> 13 & 1L) != 0L;
        this.setCrawling(isCrawling);
        boolean isSmall = (state >>> 15 & 1L) != 0L;
        this.setSmall(isSmall);
        boolean isClimbing = (state >>> 14 & 1L) != 0L;
        boolean isCrawlClimbing = (state >>> 12 & 1L) != 0L;
        boolean isCeilingClimbing = (state >>> 18 & 1L) != 0L;
        boolean isWallJumping = (state >>> 31 & 1L) != 0L;
        this.resetFallDistance = isClimbing || isCrawlClimbing || isCeilingClimbing || isWallJumping;
        this.resetTicksForFloatKick = isClimbing || isCrawlClimbing || isCeilingClimbing;
        this.mp.sendPacketToTrackedPlayers(packet);
    }

    public void processConfigPacket(String clientConfigurationVersion) {
        boolean warn = true;
        String type = "unknown";
        if (clientConfigurationVersion != null) {
            for (int i = 0; i < SmartMovingConfig._all.length; ++i) {
                if (!clientConfigurationVersion.equals(SmartMovingConfig._all[i])) continue;
                warn = i > 0;
                type = warn ? "outdated" : "matching";
                break;
            }
        }
        String message = "Smart Moving player \"" + this.mp.getUsername() + "\" connected with " + type + " configuration system";
        if (clientConfigurationVersion != null) {
            message = message + " version \"" + clientConfigurationVersion + "\"";
        }
        if (warn) {
            FMLLog.warning((String)message, (Object[])new Object[0]);
        } else {
            FMLLog.info((String)message, (Object[])new Object[0]);
        }
    }

    public void processConfigChangePacket(String localUserName) {
        if (!((Boolean)SmartMovingServer.Options._globalConfig.value).booleanValue()) {
            this.toggleSingleConfig();
            return;
        }
        String username = this.mp.getUsername();
        if (localUserName == username) {
            this.toggleConfig();
            return;
        }
        String[] rightPlayerNames = (String[])SmartMovingServer.Options._usersWithChangeConfigRights.value;
        for (int i = 0; i < rightPlayerNames.length; ++i) {
            if (!rightPlayerNames[i].equals(username)) continue;
            this.toggleConfig();
            return;
        }
        SmartMovingPacketStream.sendConfigChange(this.mp);
    }

    public void processSpeedChangePacket(int difference, String localUserName) {
        if (!((Boolean)SmartMovingServer.Options._globalConfig.value).booleanValue()) {
            this.changeSingleSpeed(difference);
            return;
        }
        if (!this.hasRight(localUserName, SmartMovingServer.Options._usersWithChangeSpeedRights)) {
            SmartMovingPacketStream.sendSpeedChange(this.mp, 0, null);
        } else {
            this.changeSpeed(difference);
        }
    }

    public void processHungerChangePacket(float hunger) {
        this.hunger = hunger;
    }

    public void processSoundPacket(String soundId, float volume, float pitch) {
        this.mp.localPlaySound(soundId, volume, pitch);
    }

    private boolean hasRight(String localUserName, Property<String[]> rights) {
        String username = this.mp.getUsername();
        if (localUserName == username) {
            return true;
        }
        String[] rightPlayerNames = (String[])rights.value;
        for (int i = 0; i < rightPlayerNames.length; ++i) {
            if (!rightPlayerNames[i].equals(username)) continue;
            return true;
        }
        return false;
    }

    public void toggleSingleConfig() {
        SmartMovingPacketStream.sendConfigContent(this.mp, optionsHandler.writeToProperties(this.mp, true), this.mp.getUsername());
    }

    public void toggleConfig() {
        optionsHandler.toggle(this.mp);
        String[] config = optionsHandler.writeToProperties();
        IEntityPlayerMP[] players = this.mp.getAllPlayers();
        for (int n = 0; n < players.length; ++n) {
            SmartMovingPacketStream.sendConfigContent(players[n], config, this.mp.getUsername());
        }
    }

    public void changeSingleSpeed(int difference) {
        optionsHandler.changeSingleSpeed(this.mp, difference);
        SmartMovingPacketStream.sendSpeedChange(this.mp, difference, this.mp.getUsername());
    }

    public void changeSpeed(int difference) {
        optionsHandler.changeSpeed(difference, this.mp);
        IEntityPlayerMP[] players = this.mp.getAllPlayers();
        for (int n = 0; n < players.length; ++n) {
            SmartMovingPacketStream.sendSpeedChange(players[n], difference, this.mp.getUsername());
        }
    }

    public void afterOnUpdate() {
        if (this.resetFallDistance) {
            this.mp.resetFallDistance();
        }
        if (this.resetTicksForFloatKick) {
            this.mp.resetTicksForFloatKick();
        }
    }

    public static void initialize(File optionsPath, Logger logger, int gameType, SmartMovingConfig config) {
        Options = config;
        optionsHandler = new SmartMovingServerOptions(Options, optionsPath, gameType);
        logger.info("Smart Moving uses communication protocol 2.3");
    }

    public void setCrawling(boolean crawling) {
        if (!crawling && this.isCrawling) {
            this.crawlingCooldown = 10;
        }
        this.isCrawling = crawling;
    }

    public void setSmall(boolean isSmall) {
        this.mp.setHeight(isSmall ? 0.8f : 1.8f);
        this.isSmall = isSmall;
    }

    public void afterSetPosition(double d, double d1, double d2) {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight() - 1.0);
        }
    }

    public void beforeIsPlayerSleeping() {
        if (!this.crawlingInitialized) {
            this.mp.setMaxY(this.mp.getMinY() + (double)this.mp.getHeight());
            this.crawlingInitialized = true;
        }
    }

    public void beforeOnUpdate() {
        if (this.crawlingCooldown > 0) {
            --this.crawlingCooldown;
        }
    }

    public void beforeOnLivingUpdate() {
        this.withinOnLivingUpdate = true;
    }

    public void afterOnLivingUpdate() {
        this.withinOnLivingUpdate = false;
        if (!this.isSmall) {
            return;
        }
        if (this.mp.doGetHealth() <= 0.0f) {
            return;
        }
        double offset = 0.25;
        AxisAlignedBB box = this.mp.expandBox(this.mp.getBox(), 1.0, offset, 1.0);
        List<?> offsetEntities = this.mp.getEntitiesExcludingPlayer(box);
        if (offsetEntities != null && offsetEntities.size() > 0) {
            Object[] offsetEntityArray = offsetEntities.toArray();
            box = this.mp.expandBox(box, 0.0, -offset, 0.0);
            List<?> standardEntities = this.mp.getEntitiesExcludingPlayer(box);
            for (int i = 0; i < offsetEntityArray.length; ++i) {
                Entity offsetEntity = (Entity)offsetEntityArray[i];
                if (standardEntities != null && standardEntities.contains(offsetEntity) || this.mp.isDeadEntity(offsetEntity)) continue;
                this.mp.onCollideWithPlayer(offsetEntity);
            }
        }
    }

    public boolean isEntityInsideOpaqueBlock() {
        if (this.crawlingCooldown > 0) {
            return false;
        }
        return this.mp.localIsEntityInsideOpaqueBlock();
    }

    public void addMovementStat(double var1, double var3, double var5) {
        this.beforeAddMovingHungerBatch();
        this.mp.localAddMovementStat(var1, var3, var5);
        if (this.disableAddExhaustion && this.hunger != 0.0f && !this.withinOnLivingUpdate) {
            this.mp.localAddExhaustion(this.hunger);
        }
        this.afterAddMovingHungerBatch();
    }

    public void beforeAddMovingHungerBatch() {
        ++this.disableAddExhaustionDepth;
        if (this.hunger != -1.0f) {
            this.disableAddExhaustion = true;
        }
    }

    public void addExhaustion(float exhaustion) {
        if (!this.disableAddExhaustion) {
            this.mp.localAddExhaustion(exhaustion);
        }
    }

    public void afterAddMovingHungerBatch() {
        --this.disableAddExhaustionDepth;
        if (this.disableAddExhaustionDepth == 0) {
            this.disableAddExhaustion = false;
        }
    }
}

