/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.playerapi;

import api.player.server.IServerPlayerAPI;
import api.player.server.ServerPlayerAPI;
import api.player.server.ServerPlayerBase;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.SmartMovingServer;
import net.smart.utilities.Reflect;

public class SmartMovingServerPlayerBase
extends ServerPlayerBase
implements IEntityPlayerMP {
    public final SmartMovingServer moving = new SmartMovingServer(this, false);

    public static void registerPlayerBase() {
        ServerPlayerAPI.register((String)"Smart Moving", SmartMovingServerPlayerBase.class);
    }

    public static SmartMovingServerPlayerBase getPlayerBase(Object player) {
        return (SmartMovingServerPlayerBase)((IServerPlayerAPI)player).getServerPlayerBase("Smart Moving");
    }

    public SmartMovingServerPlayerBase(ServerPlayerAPI playerApi) {
        super(playerApi);
    }

    @Override
    public float getHeight() {
        return this.player.field_70131_O;
    }

    @Override
    public double getMinY() {
        return this.player.func_174813_aQ().field_72338_b;
    }

    @Override
    public void setMaxY(double maxY) {
        AxisAlignedBB box = this.player.func_174813_aQ();
        this.player.func_174826_a(new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, maxY, box.field_72334_f));
    }

    public void afterSetPosition(double d, double d1, double d2) {
        this.moving.afterSetPosition(d, d1, d2);
    }

    public void beforeIsPlayerSleeping() {
        this.moving.beforeIsPlayerSleeping();
    }

    public void beforeOnUpdate() {
        this.moving.beforeOnUpdate();
    }

    public void afterOnUpdate() {
        this.moving.afterOnUpdate();
    }

    public void beforeOnLivingUpdate() {
        this.moving.beforeOnLivingUpdate();
    }

    public void afterOnLivingUpdate() {
        this.moving.afterOnLivingUpdate();
    }

    @Override
    public float doGetHealth() {
        return this.player.func_110143_aJ();
    }

    @Override
    public AxisAlignedBB getBox() {
        return this.player.func_174813_aQ();
    }

    @Override
    public AxisAlignedBB expandBox(AxisAlignedBB box, double x, double y, double z) {
        return box.func_72314_b(x, y, z);
    }

    @Override
    public List<?> getEntitiesExcludingPlayer(AxisAlignedBB box) {
        return this.player.field_70170_p.func_72839_b((Entity)this.player, box);
    }

    @Override
    public boolean isDeadEntity(Entity entity) {
        return entity.field_70128_L;
    }

    @Override
    public void onCollideWithPlayer(Entity entity) {
        entity.func_70100_b_((EntityPlayer)this.player);
    }

    public float getEyeHeight() {
        return this.player.field_70131_O - 0.18f;
    }

    public boolean isEntityInsideOpaqueBlock() {
        return this.moving.isEntityInsideOpaqueBlock();
    }

    @Override
    public boolean localIsEntityInsideOpaqueBlock() {
        return super.isEntityInsideOpaqueBlock();
    }

    public void addExhaustion(float exhaustion) {
        this.moving.addExhaustion(exhaustion);
    }

    @Override
    public void localAddExhaustion(float exhaustion) {
        super.addExhaustion(exhaustion);
    }

    public void addMovementStat(double x, double y, double z) {
        this.moving.addMovementStat(x, y, z);
    }

    @Override
    public void localAddMovementStat(double x, double y, double z) {
        super.addMovementStat(x, y, z);
    }

    @Override
    public void localPlaySound(String soundId, float volume, float pitch) {
        this.player.func_85030_a(soundId, volume, pitch);
    }

    public void beforeUpdatePotionEffects() {
        this.moving.afterAddMovingHungerBatch();
    }

    public void afterUpdatePotionEffects() {
        this.moving.beforeAddMovingHungerBatch();
    }

    @Override
    public void setHeight(float height) {
        this.player.field_70131_O = height;
    }

    @Override
    public void sendPacket(byte[] data) {
        this.player.field_71135_a.func_147359_a((Packet)new FMLProxyPacket(new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)), SmartMovingPacketStream.Id));
    }

    @Override
    public String getUsername() {
        return this.player.func_146103_bH().getName();
    }

    @Override
    public void resetFallDistance() {
        this.player.field_70143_R = 0.0f;
        this.player.field_70181_x = 0.08;
    }

    @Override
    public void resetTicksForFloatKick() {
        Reflect.SetField(NetHandlerPlayServer.class, this.player.field_71135_a, SmartMovingInstall.NetServerHandler_ticksForFloatKick, 0);
    }

    @Override
    public void sendPacketToTrackedPlayers(FMLProxyPacket packet) {
        this.player.field_71133_b.func_71218_a(this.player.field_71093_bK).func_73039_n().func_151247_a((Entity)this.player, (Packet)packet);
    }

    @Override
    public SmartMovingServer getMoving() {
        return this.moving;
    }

    @Override
    public IEntityPlayerMP[] getAllPlayers() {
        List playerEntityList = this.player.field_71133_b.func_71203_ab().field_72404_b;
        IEntityPlayerMP[] result = new IEntityPlayerMP[playerEntityList.size()];
        for (int i = 0; i < playerEntityList.size(); ++i) {
            result[i] = (IEntityPlayerMP)((IServerPlayerAPI)playerEntityList.get(i)).getServerPlayerBase("Smart Moving");
        }
        return result;
    }
}

