/*
 * Decompiled with CFR 0.152.
 */
package net.smart.utilities;

import java.io.PrintStream;
import net.minecraftforge.fml.common.FMLLog;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;
import org.apache.logging.log4j.Level;

public class Assert {
    public static final String messageBorder = "========================================";
    public static final String messageSeparator = "----------------------------------------";
    public static final boolean hasClientPlayerAPI = Assert.hasAPI("Client");
    public static final boolean hasServerPlayerAPI = Assert.hasAPI("Server");
    public static final boolean hasRenderPlayerAPI = Assert.hasAPI("Render");

    public static void clientPlayerAPI(String modName) {
        if (!hasClientPlayerAPI) {
            throw new RuntimeException(Assert.error(Assert.getPlayerAPIMessage(modName, true)));
        }
    }

    public static void serverPlayerAPI(String modName) {
        if (!hasServerPlayerAPI) {
            throw new RuntimeException(Assert.error(Assert.getPlayerAPIMessage(modName, false)));
        }
    }

    private static String[] getPlayerAPIMessage(String modName, boolean client) {
        return Assert.getMessage(modName + " could not find the required API \"" + (client ? "Client" : "Server") + " Player\"!", "Download Player API core from:", "\thttp://www.minecraftforum.net/topic/738498-/", "and install it on your system to fix this specific problem.");
    }

    private static String[] getMessage(String header, String ... lines) {
        String[] message = new String[lines.length + 4];
        int i = 0;
        message[i++] = messageBorder;
        message[i++] = header;
        message[i++] = messageSeparator;
        for (int n = 0; n < lines.length; ++n) {
            message[i++] = lines[n];
        }
        message[i] = messageBorder;
        return message;
    }

    public static String error(String ... lines) {
        return Assert.log(Level.ERROR, System.err, lines);
    }

    private static String log(Level level, PrintStream stream, String ... lines) {
        String message = "\n";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            stream.println(line);
            message = message + "\n\t" + line;
        }
        message = message + "\n";
        FMLLog.log((Level)level, (String)message, (Object[])new Object[0]);
        return message;
    }

    private static boolean hasAPI(String prefix) {
        String fullPrefix = "api.player." + prefix.substring(0, 1).toLowerCase() + prefix.substring(1) + "." + prefix + "Player";
        return Reflect.CheckClasses(Assert.class, new Name(fullPrefix + "API"), new Name(fullPrefix + "BaseSorter"));
    }
}

