/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.GuiHandler;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.control.PulseManager;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.TinkerOredict;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.debug.TinkerDebug;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.plugin.TinkerVintageCraft;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod(modid="tconstruct", name="Tinkers' Construct", version="1.8.8-2.0.1", guiFactory="slimeknights.tconstruct.common.config.ConfigGui$ConfigGuiFactory", dependencies="required-after:Forge@[11.15.0.1647,);required-after:mantle@[1.8.8-0.6,)", acceptedMinecraftVersions="1.8.8, 1.8.9")
public class TConstruct {
    public static final String modID = "tconstruct";
    public static final String modVersion = "1.8.8-2.0.1";
    public static final Logger log = LogManager.getLogger((String)"tconstruct");
    public static final Random random = new Random();
    @Mod.Instance(value="tconstruct")
    public static TConstruct instance;
    public static PulseManager pulseManager;
    public static GuiHandler guiHandler;

    public TConstruct() {
        if (Loader.isModLoaded((String)"Natura")) {
            log.info("Natura, what are we going to do tomorrow night?");
            LogManager.getLogger((String)"Natura").info("TConstruct, we're going to take over the world!");
        } else {
            log.info("Preparing to take over the world");
        }
    }

    @NetworkCheckHandler
    public boolean matchModVersions(Map<String, String> remoteVersions, Side side) {
        return remoteVersions.containsKey(modID) && modVersion.equals(remoteVersions.get(modID));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        HarvestLevels.init();
        EntityRegistry.registerModEntity(IndestructibleEntityItem.class, (String)"Indestructible Item", (int)0, (Object)instance, (int)32, (int)5, (boolean)true);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        if (event.getSide().isClient()) {
            ClientProxy.initClient();
        }
        TinkerNetwork.instance.setup();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientProxy.initRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)IndestructibleEntityItem.EventHandler.instance);
    }

    static {
        pulseManager = new PulseManager((IConfiguration)Config.pulseConfig);
        guiHandler = new GuiHandler();
        pulseManager.registerPulse((Object)new TinkerCommons());
        pulseManager.registerPulse((Object)new TinkerWorld());
        pulseManager.registerPulse((Object)new TinkerTools());
        pulseManager.registerPulse((Object)new TinkerSmeltery());
        pulseManager.registerPulse((Object)new TinkerMaterials());
        pulseManager.registerPulse((Object)new TinkerVintageCraft());
        pulseManager.registerPulse((Object)new TinkerOredict());
        pulseManager.registerPulse((Object)new TinkerDebug());
    }
}

