/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameData;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontRenderer;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.ItemBlockModelSetter;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModelLoader;
import slimeknights.tconstruct.library.modifiers.IModifier;

public abstract class ClientProxy
extends CommonProxy {
    public static CustomFontRenderer fontRenderer;
    protected static final ToolModelLoader loader;
    protected static final MaterialModelLoader materialLoader;
    protected static final ModifierModelLoader modifierLoader;

    public static void initClient() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)materialLoader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)modifierLoader);
        MinecraftForge.EVENT_BUS.register((Object)new ItemBlockModelSetter());
    }

    public static void initRenderer() {
        CustomTextureCreator creator = new CustomTextureCreator();
        MinecraftForge.EVENT_BUS.register((Object)creator);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)creator);
        fontRenderer = new CustomFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a());
            fontRenderer.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)fontRenderer);
        try {
            Class<?> clazz = Class.forName("codechicken.lib.gui.GuiDraw");
            Field field = clazz.getDeclaredField("fontRenderer");
            field.set(null, (Object)fontRenderer);
        }
        catch (ClassNotFoundException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
        catch (NoSuchFieldException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
        catch (IllegalAccessException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
    }

    protected ResourceLocation registerModel(Item item, String ... customVariants) {
        return this.registerModel(item, 0, customVariants);
    }

    protected ResourceLocation registerModel(Item item, int meta, String ... customVariants) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((Object)item);
        if (o == null) {
            TConstruct.log.error("Trying to register a model for an unregistered item: %s" + item.func_77658_a());
            return null;
        }
        ResourceLocation location = o;
        location = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        if (customVariants.length > 0) {
            ModelBakery.addVariantName((Item)item, (String[])new String[]{location.toString()});
        }
        for (String customVariant : customVariants) {
            String custom = location.func_110624_b() + ":" + customVariant;
            ModelBakery.addVariantName((Item)item, (String[])new String[]{custom});
        }
        return location;
    }

    protected void registerItemModel(ItemStack item, String name) {
        if (!name.contains(":")) {
            name = Util.resource(name);
        }
        ModelBakery.addVariantName((Item)item.func_77973_b(), (String[])new String[]{name});
        ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)item.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    protected ResourceLocation registerToolModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        String path = "tools/" + itemLocation.func_110623_a() + ToolModelLoader.EXTENSION;
        return this.registerToolModel(item, new ResourceLocation(itemLocation.func_110624_b(), path));
    }

    protected ResourceLocation registerToolModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(ToolModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + ToolModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public ResourceLocation registerMaterialItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return this.registerMaterialModel(item, new ResourceLocation(itemLocation.func_110624_b(), itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
    }

    public ResourceLocation registerMaterialModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(MaterialModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + MaterialModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public void registerModifierModel(IModifier modifier, ResourceLocation location) {
        modifierLoader.registerModifierFile(modifier.getIdentifier(), location);
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelBakery.addVariantName((Item)item, (String[])new String[]{location.toString()});
        return location;
    }

    public static ResourceLocation getItemLocation(Item item) {
        return Util.getItemLocation(item);
    }

    @Override
    public void sendPacketToServerOnly(AbstractPacket packet) {
        TinkerNetwork.sendToServer(packet);
    }

    static {
        loader = new ToolModelLoader();
        materialLoader = new MaterialModelLoader();
        modifierLoader = new ModifierModelLoader();
    }
}

