/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.world.TinkerWorld;

@Pulse(id="TinkerOredict", forced=true)
public class TinkerOredict {
    public static final String PulseId = "TinkerOredict";

    @Subscribe
    public static void doTheOredict(FMLPreInitializationEvent event) {
        TinkerOredict.ensureOredict();
        TinkerOredict.registerCommon();
        TinkerOredict.registerTools();
        TinkerOredict.registerSmeltery();
        TinkerOredict.registerWorld();
    }

    private static void ensureOredict() {
        TinkerOredict.oredict(Blocks.field_150462_ai, "workbench");
        TinkerOredict.oredict((Block)Blocks.field_150434_aF, "blockCactus");
        TinkerOredict.oredict(Blocks.field_180399_cE, "blockSlime");
        TinkerOredict.oredict(Blocks.field_150343_Z, "obsidian");
        TinkerOredict.oredict(Blocks.field_150424_aL, "netherrack");
        TinkerOredict.oredict(Blocks.field_180397_cI, "prismarine");
        TinkerOredict.oredict(Blocks.field_150395_bd, "vine");
        TinkerOredict.oredict(Blocks.field_150346_d, "dirt");
    }

    private static void registerCommon() {
        String dict = "slimeball";
        TinkerOredict.oredict(Items.field_151123_aH, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallPurple, dict, dict + "Purple");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlood, dict, dict + "Blood");
        dict = "ingot";
        TinkerOredict.oredict(TinkerCommons.ingotCobalt, dict + "Cobalt");
        TinkerOredict.oredict(TinkerCommons.ingotArdite, dict + "Ardite");
        TinkerOredict.oredict(TinkerCommons.ingotManyullyn, dict + "Manyullyn");
        TinkerOredict.oredict(TinkerCommons.ingotKnightSlime, dict + "Knightslime");
        dict = "nugget";
        TinkerOredict.oredict(TinkerCommons.nuggetCobalt, dict + "Cobalt");
        TinkerOredict.oredict(TinkerCommons.nuggetArdite, dict + "Ardite");
        TinkerOredict.oredict(TinkerCommons.nuggetManyullyn, dict + "Manyullyn");
        TinkerOredict.oredict(TinkerCommons.nuggetKnightSlime, dict + "Knightslime");
        dict = "block";
        String metal = "blockMetal";
        TinkerOredict.oredict(TinkerCommons.blockCobalt, dict + "Cobalt", metal);
        TinkerOredict.oredict(TinkerCommons.blockArdite, dict + "Ardite", metal);
        TinkerOredict.oredict(TinkerCommons.blockManyullyn, dict + "Manyullyn", metal);
        TinkerOredict.oredict(TinkerCommons.blockKnightSlime, dict + "Knightslime", metal);
        TinkerOredict.oredict(new ItemStack(Blocks.field_150339_S), metal);
        TinkerOredict.oredict(new ItemStack(Blocks.field_150340_R), metal);
        TinkerOredict.oredict(TinkerCommons.searedBrick, "ingotBrickSeared");
        dict = "slimecrystal";
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystal, dict, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.oreCobalt, "oreCobalt");
        TinkerOredict.oredict(TinkerCommons.oreArdite, "oreArdite");
    }

    private static void registerTools() {
        TinkerOredict.oredict((Block)TinkerTools.toolTables, BlockToolTable.TableTypes.CraftingStation.meta, "workbench");
        TinkerOredict.oredict((Item)TinkerTools.pickHead, "partPickHead");
        TinkerOredict.oredict((Item)TinkerTools.binding, "partBinding");
        TinkerOredict.oredict((Item)TinkerTools.toolRod, "partToolRod");
        TinkerOredict.oredict((Item)TinkerTools.pattern, "pattern");
    }

    private static void registerSmeltery() {
        TinkerOredict.oredict((Item)TinkerSmeltery.cast, "cast");
    }

    private static void registerWorld() {
        TinkerOredict.oredict((Block)TinkerWorld.slimeSapling, "treeSapling");
        TinkerOredict.oredict((Block)TinkerWorld.slimeBlock, "blockSlime");
        TinkerOredict.oredict((Block)TinkerWorld.slimeBlockCongealed, "blockSlimeCongealed");
        TinkerOredict.oredict((Block)TinkerWorld.slimeDirt, "blockSlimeDirt");
        TinkerOredict.oredict((Block)TinkerWorld.slimeGrass, "blockSlimeGrass");
        TinkerOredict.oredict((Block)TinkerWorld.slimeLeaves, "treeLeaves");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue3, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple3, "vine");
    }

    public static void oredict(Item item, String ... name) {
        TinkerOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        TinkerOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && stack.func_77973_b() != null) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

