/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;

public abstract class TinkerPulse {
    protected static boolean isToolsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerTools");
    }

    protected static boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    protected static boolean isWorldLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerWorld");
    }

    protected static <T extends Item> T registerItem(T item, String unlocName) {
        if (!unlocName.equals(unlocName.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", unlocName));
        }
        item.func_77655_b(Util.prefix(unlocName));
        GameRegistry.registerItem(item, (String)unlocName);
        return item;
    }

    protected static <T extends Block> T registerBlock(T block, String unlocName) {
        block.func_149663_c(Util.prefix(unlocName));
        GameRegistry.registerBlock(block, (String)unlocName);
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumBlock(T block, String unlocName) {
        TinkerPulse.registerBlock(block, ItemBlockMeta.class, unlocName, new Object[0]);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Block> T registerBlock(T block, Class<? extends ItemBlock> itemBlockClazz, String unlocName, Object ... itemCtorArgs) {
        if (!unlocName.equals(unlocName.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", unlocName));
        }
        block.func_149663_c(Util.prefix(unlocName));
        GameRegistry.registerBlock(block, itemBlockClazz, (String)unlocName, (Object[])itemCtorArgs);
        return block;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }
}

