/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;

@SideOnly(value=Side.CLIENT)
public final class TinkerRegistryClient {
    public static final Logger log = Util.getLogger("API-Client");
    private static final Map<Item, ToolBuildGuiInfo> toolBuildInfo = Maps.newLinkedHashMap();
    private static final Map<Fluid, FluidDisplayType> fluidTypes = Maps.newHashMap();

    private TinkerRegistryClient() {
    }

    public static void addToolBuilding(ToolBuildGuiInfo info) {
        toolBuildInfo.put(info.tool.func_77973_b(), info);
    }

    public static ToolBuildGuiInfo getToolBuildInfoForTool(Item tool) {
        return toolBuildInfo.get(tool);
    }

    public static void clear() {
        toolBuildInfo.clear();
    }

    public static void registerFluidDisplayType(Fluid fluid, FluidDisplayType type) {
        fluidTypes.put(fluid, type);
    }

    public static FluidDisplayType getFluidDisplayType(Fluid fluid) {
        if (!fluidTypes.containsKey(fluid)) {
            return FluidDisplayType.BUCKETS;
        }
        return fluidTypes.get(fluid);
    }

    public static enum FluidDisplayType {
        BUCKETS,
        INGOTS,
        BLOCKS,
        SEARED,
        GLASS,
        GEMS;

    }
}

