/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.CustomFontColor;

@SideOnly(value=Side.CLIENT)
public class CustomFontRenderer
extends FontRenderer {
    private boolean dropShadow;
    private int state = 0;
    private int red;
    private int green;
    private int blue;

    public CustomFontRenderer(GameSettings gameSettingsIn, ResourceLocation location, TextureManager textureManagerIn) {
        super(gameSettingsIn, location, textureManagerIn, true);
    }

    public int func_180455_b(String text, float x, float y, int color, boolean dropShadow) {
        this.dropShadow = dropShadow;
        return super.func_180455_b(text, x, y, color, dropShadow);
    }

    protected float func_78277_a(char letter, boolean italic) {
        if (letter >= CustomFontColor.MARKER && letter <= CustomFontColor.MARKER + 255) {
            int value = letter & 0xFF;
            switch (this.state) {
                case 0: {
                    this.red = value;
                    break;
                }
                case 1: {
                    this.green = value;
                    break;
                }
                case 2: {
                    this.blue = value;
                    break;
                }
                default: {
                    this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    return 0.0f;
                }
            }
            ++this.state;
            this.state %= 3;
            int color = this.red << 16 | this.green << 8 | this.blue | 0xFF000000;
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (this.dropShadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
            return 0.0f;
        }
        if (this.state != 0) {
            this.state = 0;
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return super.func_78277_a(letter, italic);
    }
}

