/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import slimeknights.tconstruct.library.client.texture.CastTexture;
import slimeknights.tconstruct.library.client.texture.GuiOutlineTexture;
import slimeknights.tconstruct.library.client.texture.PatternTexture;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;

public class CustomTextureCreator
implements IResourceManagerReloadListener {
    private static Logger log = Util.getLogger("TextureGen");
    public static Map<String, Map<String, TextureAtlasSprite>> sprites = Maps.newHashMap();
    private static Set<ResourceLocation> baseTextures = Sets.newHashSet();
    public static ResourceLocation patternModelLocation;
    public static ResourceLocation castModelLocation;
    public static String patternLocString;
    public static String castLocString;
    public static final Material guiMaterial;

    public static void registerTextures(Collection<ResourceLocation> textures) {
        baseTextures.addAll(textures);
    }

    public static void registerTexture(ResourceLocation texture) {
        baseTextures.add(texture);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void createCustomTextures(TextureStitchEvent.Pre event) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return;
        }
        this.createMaterialTextures(event.map);
        this.createPatterntextures(event.map);
    }

    private void createMaterialTextures(TextureMap map) {
        for (ResourceLocation baseTexture : baseTextures) {
            TextureAtlasSprite sprite;
            if (baseTexture.toString().equals("minecraft:missingno")) continue;
            TextureAtlasSprite base = map.getTextureExtry(baseTexture.toString());
            if (base == null) {
                log.error("Missing base texture: " + baseTexture.toString());
                continue;
            }
            HashMap builtSprites = Maps.newHashMap();
            for (Material material : TinkerRegistry.getAllMaterials()) {
                TextureAtlasSprite sprite2 = this.createTexture(material, baseTexture, base, map);
                if (sprite2 == null) continue;
                builtSprites.put(material.identifier, sprite2);
            }
            if (CustomTextureCreator.belongsToToolPart(baseTexture) && (sprite = this.createTexture(guiMaterial, baseTexture, base, map)) != null) {
                builtSprites.put(CustomTextureCreator.guiMaterial.identifier, sprite);
            }
            sprites.put(baseTexture.toString(), builtSprites);
        }
    }

    private TextureAtlasSprite createTexture(Material material, ResourceLocation baseTexture, TextureAtlasSprite base, TextureMap map) {
        TextureAtlasSprite sprite;
        String location = baseTexture.toString() + "_" + material.identifier;
        if (CustomTextureCreator.exists(location)) {
            sprite = map.func_174942_a(new ResourceLocation(location));
        } else {
            if (material.renderInfo == null) {
                return null;
            }
            TextureAtlasSprite matBase = base;
            if (material.renderInfo.getTextureSuffix() != null) {
                String loc2 = baseTexture.toString() + "_" + material.renderInfo.getTextureSuffix();
                TextureAtlasSprite base2 = map.getTextureExtry(loc2);
                if (base2 == null && CustomTextureCreator.exists(loc2)) {
                    base2 = new AbstractColoredTexture(loc2, loc2){

                        @Override
                        protected int colorPixel(int pixel, int mipmap, int pxCoord) {
                            return pixel;
                        }
                    };
                    map.setTextureEntry(loc2, base2);
                }
                if (base2 != null) {
                    matBase = base2;
                }
            }
            sprite = material.renderInfo.getTexture(matBase, location);
        }
        if (sprite != null && material.renderInfo.isStitched()) {
            map.setTextureEntry(location, sprite);
        }
        return sprite;
    }

    private void createPatterntextures(TextureMap map) {
        if (patternModelLocation == null && castModelLocation == null) {
            return;
        }
        try {
            ResourceLocation patternLocation;
            IModel patternModel;
            TextureAtlasSprite pattern = null;
            TextureAtlasSprite cast = null;
            if (patternModelLocation != null) {
                patternModel = ModelLoaderRegistry.getModel((ResourceLocation)patternModelLocation);
                patternLocation = (ResourceLocation)patternModel.getTextures().iterator().next();
                pattern = map.getTextureExtry(patternLocation.toString());
                patternLocString = patternLocation + "_";
            }
            if (castModelLocation != null) {
                patternModel = ModelLoaderRegistry.getModel((ResourceLocation)castModelLocation);
                patternLocation = (ResourceLocation)patternModel.getTextures().iterator().next();
                cast = map.getTextureExtry(patternLocation.toString());
                castLocString = patternLocation + "_";
            }
            for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
                if (!(toolpart instanceof Item)) continue;
                ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
                IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
                ResourceLocation partTexture = (ResourceLocation)partModel.getTextures().iterator().next();
                if (pattern != null) {
                    String partPatternLocation = patternLocString + toolpart.getIdentifier().toLowerCase(Locale.US);
                    Object partPatternTexture = CustomTextureCreator.exists(partPatternLocation) ? map.func_174942_a(new ResourceLocation(partPatternLocation)) : new PatternTexture(partTexture.toString(), pattern, partPatternLocation);
                    map.setTextureEntry(partPatternLocation, partPatternTexture);
                }
                if (cast == null) continue;
                String partCastLocation = castLocString + toolpart.getIdentifier().toLowerCase(Locale.US);
                Object partCastTexture = CustomTextureCreator.exists(partCastLocation) ? map.func_174942_a(new ResourceLocation(partCastLocation)) : new CastTexture(partTexture.toString(), cast, partCastLocation);
                map.setTextureEntry(partCastLocation, partCastTexture);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private void createGUITextures(TextureMap map) {
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!(toolpart instanceof Item)) continue;
            try {
                ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
                IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
                ResourceLocation baseTexture = (ResourceLocation)partModel.getTextures().iterator().next();
                TextureAtlasSprite base = map.getTextureExtry(baseTexture.toString());
                if (base == null) {
                    log.error("Missing base texture: " + baseTexture.toString());
                    continue;
                }
                Map<String, TextureAtlasSprite> partTextures = sprites.get(baseTexture.toString());
                if (partTextures == null) continue;
                String location = baseTexture.toString() + "_internal_gui";
                GuiOutlineTexture outlineTexture = new GuiOutlineTexture(base, location);
                map.setTextureEntry(location, (TextureAtlasSprite)outlineTexture);
                partTextures.put("_internal_gui", outlineTexture);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public static String getItemLoc(String res) {
        ResourceLocation loc = new ResourceLocation(res);
        return String.format("%s:items/%s", loc.func_110624_b(), loc.func_110623_a());
    }

    public static boolean exists(String res) {
        try {
            ResourceLocation loc = new ResourceLocation(res);
            loc = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
            Minecraft.func_71410_x().func_110442_L().func_135056_b(loc);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        baseTextures.clear();
        for (Map<String, TextureAtlasSprite> map : sprites.values()) {
            map.clear();
        }
        sprites.clear();
    }

    public static ResourceLocation getTextureLocationFromToolPart(IToolPart toolpart) throws IOException {
        if (!(toolpart instanceof Item)) {
            return null;
        }
        ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
        IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
        ResourceLocation partTexture = (ResourceLocation)partModel.getTextures().iterator().next();
        return partTexture;
    }

    public static boolean belongsToToolPart(ResourceLocation location) {
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!(toolpart instanceof Item)) continue;
            try {
                ResourceLocation modelLocation = Util.getItemLocation((Item)toolpart);
                IModel partModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "item/parts/" + modelLocation.func_110623_a() + MaterialModelLoader.EXTENSION));
                ResourceLocation baseTexture = (ResourceLocation)partModel.getTextures().iterator().next();
                if (!baseTexture.toString().equals(location.toString())) continue;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    static {
        guiMaterial = new Material("_internal_gui", EnumChatFormatting.WHITE);
        guiMaterial.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new GuiOutlineTexture(baseTexture, location);
            }
        });
    }
}

