/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderUtil {
    public static float FLUID_OFFSET = 0.005f;
    protected static Minecraft mc = Minecraft.func_71410_x();

    private RenderUtil() {
    }

    public static void renderTiledTextureAtlas(int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtil.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.putTiledTextureQuads(worldrenderer, x, y, width, height, depth, sprite);
        tessellator.func_78381_a();
    }

    public static void putTiledTextureQuads(WorldRenderer renderer, int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int renderHeight = Math.min(sprite.func_94216_b(), height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int renderWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)sprite.func_94211_a()));
                renderer.func_181662_b((double)x2, (double)y, (double)depth).func_181673_a((double)u1, (double)v1).func_181675_d();
                renderer.func_181662_b((double)x2, (double)(y + renderHeight), (double)depth).func_181673_a((double)u1, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_181673_a((double)u2, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)y, (double)depth).func_181673_a((double)u2, (double)v1).func_181675_d();
                x2 += renderWidth;
            } while (width2 > 0);
            y += renderHeight;
        } while (height > 0);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double w, double h, double d) {
        double wd = (1.0 - w) / 2.0;
        double hd = (1.0 - h) / 2.0;
        double dd = (1.0 - d) / 2.0;
        RenderUtil.renderFluidCuboid(fluid, pos, x, y, z, wd, hd, dd, 1.0 - wd, 1.0 - hd, 1.0 - dd);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        RenderUtil.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getFluid().getColor(fluid);
        int brightness = RenderUtil.mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        RenderUtil.pre(x, y, z);
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness);
        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness);
        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness);
        tessellator.func_78381_a();
        RenderUtil.post();
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax) {
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        RenderUtil.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getFluid().getColor(fluid);
        int brightness = RenderUtil.mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        RenderUtil.pre(px, py, pz);
        GlStateManager.func_179109_b((float)from.func_177958_n(), (float)from.func_177956_o(), (float)from.func_177952_p());
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        int xd = to.func_177958_n() - from.func_177958_n();
        int yd = to.func_177956_o() - from.func_177956_o();
        int zd = to.func_177952_p() - from.func_177952_p();
        double xmin = FLUID_OFFSET;
        double xmax = (double)xd + 1.0 - (double)FLUID_OFFSET;
        double zmin = FLUID_OFFSET;
        double zmax = (double)zd + 1.0 - (double)FLUID_OFFSET;
        double[] xs = new double[2 + xd];
        double[] ys = new double[2 + yd];
        double[] zs = new double[2 + zd];
        xs[0] = xmin;
        for (i = 1; i <= xd; ++i) {
            xs[i] = i;
        }
        xs[xd + 1] = xmax;
        ys[0] = ymin;
        for (i = 1; i <= yd; ++i) {
            ys[i] = i;
        }
        ys[yd + 1] = ymax;
        zs[0] = zmin;
        for (i = 1; i <= zd; ++i) {
            zs[i] = i;
        }
        zs[zd + 1] = zmax;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    double x1 = xs[x];
                    double x2 = xs[x + 1] - x1;
                    double y1 = ys[y];
                    double y2 = ys[y + 1] - y1;
                    double z1 = zs[z];
                    double z2 = zs[z + 1] - z1;
                    if (x == 0) {
                        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.WEST, color, brightness);
                    }
                    if (x == xd) {
                        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.EAST, color, brightness);
                    }
                    if (y == 0) {
                        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.DOWN, color, brightness);
                    }
                    if (y == yd) {
                        RenderUtil.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.UP, color, brightness);
                    }
                    if (z == 0) {
                        RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.NORTH, color, brightness);
                    }
                    if (z != zd) continue;
                    RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.SOUTH, color, brightness);
                }
            }
        }
        tessellator.func_78381_a();
        RenderUtil.post();
    }

    public static void putTexturedCuboid(WorldRenderer renderer, ResourceLocation location, double x1, double y1, double z1, double x2, double y2, double z2, int color, int brightness) {
        TextureAtlasSprite sprite = mc.func_147117_R().getTextureExtry(location.toString());
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness);
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness);
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness);
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness);
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness);
        RenderUtil.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness);
    }

    public static void putTexturedQuad(WorldRenderer renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderUtil.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2);
    }

    public static void putTexturedQuad(WorldRenderer renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        double x1 = x;
        double x2 = x + w;
        double y1 = y;
        double y2 = y + h;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y1 % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z1 % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * 16.0);
                maxU = sprite.func_94214_a(xt2 * 16.0);
                minV = sprite.func_94207_b(zt1 * 16.0);
                maxV = sprite.func_94207_b(zt2 * 16.0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt1 * 16.0);
                maxU = sprite.func_94214_a(xt2 * 16.0);
                minV = sprite.func_94207_b(yt1 * 16.0);
                maxV = sprite.func_94207_b(yt2 * 16.0);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt1 * 16.0);
                maxU = sprite.func_94214_a(zt2 * 16.0);
                minV = sprite.func_94207_b(yt1 * 16.0);
                maxV = sprite.func_94207_b(yt2 * 16.0);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y1, z2).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z2).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x1, y2, z1).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_181662_b(x2, y1, z1).func_181669_b(r, g, b, a).func_181673_a(minU, maxV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z1).func_181669_b(r, g, b, a).func_181673_a(minU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, minV).func_181671_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y1, z2).func_181669_b(r, g, b, a).func_181673_a(maxU, maxV).func_181671_a(light1, light2).func_181675_d();
            }
        }
    }

    public static void pre(double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public static void post() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void setColorRGB(int color) {
        RenderUtil.setColorRGBA(color | 0xFF000000);
    }

    public static void setColorRGBA(int color) {
        float a = (float)(color >> 16 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void setBrightness(WorldRenderer renderer, int brightness) {
        renderer.func_178962_a(brightness, brightness, brightness, brightness);
    }
}

