/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.materials.Material;

public class ModifierModel
implements IModel {
    private Map<String, String> models = new THashMap();

    public void addModelForModifier(String modifier, String texture) {
        this.models.put(modifier, texture);
    }

    public String getTextureForModifier(String modifier) {
        if (!this.models.containsKey(modifier)) {
            return null;
        }
        return this.models.get(modifier);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String texture : this.models.values()) {
            builder.add((Object)new ResourceLocation(texture));
        }
        return builder.build();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        throw new UnsupportedOperationException("The modifier-Model is not built to be used as an item model");
    }

    public Map<String, IFlexibleBakedModel> bakeModels(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        THashMap bakedModels = new THashMap();
        float s = 0.025f;
        TRSRTransformation transformation = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 1.0E-4f - s / 2.0f), null, new Vector3f(1.0f, 1.0f, 1.0f + s), null);
        for (Map.Entry<String, String> entry : this.models.entrySet()) {
            Object bakedModel;
            if (TinkerRegistry.getModifier(entry.getKey()).hasTexturePerMaterial()) {
                MaterialModel materialModel = new MaterialModel((ImmutableList<ResourceLocation>)ImmutableList.of((Object)new ResourceLocation(entry.getValue())));
                bakedModel = materialModel.bakeIt(state, format, bakedTextureGetter);
                for (Material material : TinkerRegistry.getAllMaterials()) {
                    IFlexibleBakedModel materialBakedModel = ((BakedMaterialModel)((Object)bakedModel)).getModelByIdentifier(material.getIdentifier());
                    if (materialBakedModel == bakedModel) continue;
                    bakedModels.put(entry.getKey() + material.getIdentifier(), materialBakedModel);
                }
                continue;
            }
            IModel model = ItemLayerModel.instance.retexture(ImmutableMap.of((Object)"layer0", (Object)entry.getValue()));
            bakedModel = model.bake(state, format, bakedTextureGetter);
            bakedModels.put(entry.getKey(), bakedModel);
        }
        return bakedModels;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

