/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;

public class ToolModel
extends ItemLayerModel {
    private final List<MaterialModel> partBlocks;
    private final List<MaterialModel> brokenPartBlocks;
    private final ModifierModel modifiers;

    public ToolModel(ImmutableList<ResourceLocation> defaultTextures, List<MaterialModel> parts, List<MaterialModel> brokenPartBlocks, ModifierModel modifiers) {
        super(defaultTextures);
        this.partBlocks = parts;
        this.brokenPartBlocks = brokenPartBlocks;
        this.modifiers = modifiers;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)super.getTextures());
        if (this.modifiers != null) {
            builder.addAll(this.modifiers.getTextures());
        }
        return builder.build();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int i;
        IFlexibleBakedModel base = super.bake(state, format, bakedTextureGetter);
        BakedMaterialModel[] partModels = new BakedMaterialModel[this.partBlocks.size()];
        BakedMaterialModel[] brokenPartModels = new BakedMaterialModel[this.partBlocks.size()];
        for (i = 0; i < this.partBlocks.size(); ++i) {
            MaterialModel m = this.partBlocks.get(i);
            partModels[i] = m.bakeIt(state, format, bakedTextureGetter);
        }
        for (i = 0; i < this.brokenPartBlocks.size(); ++i) {
            if (this.brokenPartBlocks.get(i) == null) continue;
            brokenPartModels[i] = this.brokenPartBlocks.get(i).bakeIt(state, format, bakedTextureGetter);
        }
        Object modifierModels = this.modifiers != null ? this.modifiers.bakeModels(state, format, bakedTextureGetter) : new THashMap();
        ImmutableMap transforms = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        return new BakedToolModel(base, partModels, brokenPartModels, (Map<String, IFlexibleBakedModel>)modifierModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
    }

    public IModelState getDefaultState() {
        return ModelHelper.DEFAULT_TOOL_STATE;
    }
}

