/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerRegistry;

public abstract class AbstractColoredTexture
extends TextureAtlasSprite {
    private TextureAtlasSprite baseTexture;
    private String backupTextureLocation;
    private String extra;

    protected AbstractColoredTexture(TextureAtlasSprite baseTexture, String spriteName) {
        super(spriteName);
        this.baseTexture = baseTexture;
        this.backupTextureLocation = baseTexture.func_94215_i();
    }

    protected AbstractColoredTexture(String baseTextureLocation, String spriteName) {
        super(spriteName);
        this.baseTexture = null;
        this.backupTextureLocation = baseTextureLocation;
    }

    public TextureAtlasSprite setSuffix(String suffix) {
        this.extra = suffix;
        this.baseTexture = null;
        return this;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        Object data;
        this.field_110976_a = Lists.newArrayList();
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        if (this.baseTexture != null && this.baseTexture.func_110970_k() > 0) {
            this.func_94217_a(this.baseTexture);
            int[][] original = this.baseTexture.func_147965_a(0);
            data = new int[original.length][];
            for (int i = 0; i < original.length; ++i) {
                if (original[i] == null) continue;
                data[i] = Arrays.copyOf(original[i], original[i].length);
            }
        } else {
            data = null;
            if (this.extra != null && !this.extra.isEmpty()) {
                data = this.backupLoadTexture(new ResourceLocation(this.backupTextureLocation + "_" + this.extra), manager);
            }
            if (data == null) {
                data = this.backupLoadTexture(new ResourceLocation(this.backupTextureLocation), manager);
            }
        }
        this.processData((int[][])data);
        if (this.field_110976_a.isEmpty()) {
            this.field_110976_a.add(data);
        }
        return false;
    }

    protected void processData(int[][] data) {
        for (int mipmap = 0; mipmap < data.length; ++mipmap) {
            if (data[mipmap] == null) continue;
            for (int pxCoord = 0; pxCoord < data[mipmap].length; ++pxCoord) {
                data[mipmap][pxCoord] = this.colorPixel(data[mipmap][pxCoord], mipmap, pxCoord);
            }
        }
    }

    protected abstract int colorPixel(int var1, int var2, int var3);

    protected int[][] backupLoadTexture(ResourceLocation resourceLocation, IResourceManager resourceManager) {
        if (resourceLocation.equals((Object)TextureMap.field_174945_f)) {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f().func_147965_a(0);
        }
        ResourceLocation resourcelocation1 = this.completeResourceLocation(resourceLocation, 0);
        try {
            IResource iresource = resourceManager.func_110536_a(resourcelocation1);
            BufferedImage[] abufferedimage = new BufferedImage[5];
            abufferedimage[0] = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            this.field_130223_c = abufferedimage[0].getWidth();
            this.field_130224_d = abufferedimage[0].getHeight();
            int[][] aint = new int[abufferedimage.length][];
            for (int k = 0; k < abufferedimage.length; ++k) {
                BufferedImage bufferedimage = abufferedimage[k];
                if (bufferedimage == null) continue;
                aint[k] = new int[bufferedimage.getWidth() * bufferedimage.getHeight()];
                bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), aint[k], 0, bufferedimage.getWidth());
            }
            return aint;
        }
        catch (RuntimeException runtimeexception) {
            TinkerRegistry.log.error("Unable to parse metadata from " + resourcelocation1, (Throwable)runtimeexception);
        }
        catch (IOException ioexception1) {
            TinkerRegistry.log.error("Unable to generate " + this.func_94215_i() + ": unable to load " + resourcelocation1 + "!\nBase texture: " + this.baseTexture.func_94215_i(), (Throwable)ioexception1);
        }
        return null;
    }

    protected TextureAtlasSprite backupLoadtextureAtlasSprite(ResourceLocation resourceLocation, IResourceManager resourceManager) {
        ResourceLocation resourcelocation1 = this.completeResourceLocation(resourceLocation, 0);
        TextureAtlasSprite textureAtlasSprite = TextureAtlasSprite.func_176604_a((ResourceLocation)resourceLocation);
        try {
            IResource iresource = resourceManager.func_110536_a(resourcelocation1);
            BufferedImage[] abufferedimage = new BufferedImage[5];
            abufferedimage[0] = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
            if (texturemetadatasection != null) {
                int i1;
                List list = texturemetadatasection.func_148535_c();
                if (!list.isEmpty()) {
                    int l = abufferedimage[0].getWidth();
                    i1 = abufferedimage[0].getHeight();
                    if (MathHelper.func_151236_b((int)l) != l || MathHelper.func_151236_b((int)i1) != i1) {
                        throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                    }
                }
                for (Integer aList : list) {
                    i1 = aList;
                    if (i1 <= 0 || i1 >= abufferedimage.length - 1 || abufferedimage[i1] != null) continue;
                    ResourceLocation resourcelocation2 = this.completeResourceLocation(resourceLocation, i1);
                    try {
                        abufferedimage[i1] = TextureUtil.func_177053_a((InputStream)resourceManager.func_110536_a(resourcelocation2).func_110527_b());
                    }
                    catch (IOException ioexception) {
                        TinkerRegistry.log.error("Unable to load miplevel {} from: {}", new Object[]{i1, resourcelocation2, ioexception});
                    }
                }
            }
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            textureAtlasSprite.func_180598_a(abufferedimage, animationmetadatasection);
            return textureAtlasSprite;
        }
        catch (RuntimeException runtimeexception) {
            TinkerRegistry.log.error("Unable to parse metadata from " + resourcelocation1, (Throwable)runtimeexception);
        }
        catch (IOException ioexception1) {
            TinkerRegistry.log.error("Unable to load " + resourcelocation1, (Throwable)ioexception1);
        }
        return null;
    }

    protected ResourceLocation completeResourceLocation(ResourceLocation location, int p_147634_2_) {
        if (p_147634_2_ == 0) {
            return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
        }
        return new ResourceLocation(location.func_110624_b(), String.format("%s/mipmaps/%s.%d%s", "textures", location.func_110623_a(), p_147634_2_, ".png"));
    }

    public static int getPerceptualBrightness(int col) {
        double r = (double)AbstractColoredTexture.red(col) / 255.0;
        double g = (double)AbstractColoredTexture.green(col) / 255.0;
        double b = (double)AbstractColoredTexture.blue(col) / 255.0;
        return AbstractColoredTexture.getPerceptualBrightness(r, g, b);
    }

    public static int getPerceptualBrightness(double r, double g, double b) {
        double brightness = Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b);
        return (int)(brightness * 255.0);
    }

    public static int compose(int r, int g, int b, int a) {
        int rgb = a;
        rgb = (rgb << 8) + r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    protected static int mult(int c1, int c2) {
        return (int)((float)c1 * ((float)c2 / 255.0f));
    }

    protected int getX(int pxCoord) {
        return pxCoord % this.field_130223_c;
    }

    protected int getY(int pxCoord) {
        return pxCoord / this.field_130223_c;
    }

    protected int coord(int x, int y) {
        return y * this.field_130223_c + x;
    }
}

