/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class PatternTexture
extends TextureColoredTexture {
    public PatternTexture(String partTexture, TextureAtlasSprite patternTexture, String spriteName) {
        super(partTexture, patternTexture, spriteName);
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        if (PatternTexture.alpha(pixel) == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        int x = this.getX(pxCoord);
        int y = this.getY(pxCoord);
        if (x < this.field_130223_c / 8 || x > this.field_130223_c - this.field_130223_c / 8 || y < this.field_130224_d / 8 || y > this.field_130224_d - this.field_130224_d / 8) {
            return pixel;
        }
        int c = this.textureData[mipmap][pxCoord];
        int a = PatternTexture.alpha(c);
        float mult = 1.0f;
        if (a < 64) {
            return pixel;
        }
        boolean edge = false;
        if (x > 0 && (a = PatternTexture.alpha(this.textureData[mipmap][this.coord(x - 1, y)])) < 64) {
            edge = true;
        }
        if (y < this.field_130224_d - 1 && (a = PatternTexture.alpha(this.textureData[mipmap][this.coord(x, y + 1)])) < 64) {
            edge = true;
        }
        if (x < this.field_130223_c - 1 && (a = PatternTexture.alpha(this.textureData[mipmap][this.coord(x + 1, y)])) < 64) {
            edge = true;
        }
        if (y > 0 && (a = PatternTexture.alpha(this.textureData[mipmap][this.coord(x, y - 1)])) < 64) {
            edge = true;
        }
        mult = 0.5f;
        if (edge) {
            mult = 0.6f;
        }
        int r = (int)((float)PatternTexture.red(pixel) * mult);
        int g = (int)((float)PatternTexture.green(pixel) * mult);
        int b = (int)((float)PatternTexture.blue(pixel) * mult);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return PatternTexture.compose(r, g, b, 255);
    }
}

