/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class TextureColoredTexture
extends AbstractColoredTexture {
    protected final TextureAtlasSprite addTexture;
    protected final String addTextureLocation;
    protected int[][] textureData;
    public boolean stencil = false;

    public TextureColoredTexture(String addTextureLocation, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTextureLocation;
        this.addTexture = null;
    }

    public TextureColoredTexture(TextureAtlasSprite addTexture, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTexture.func_94215_i();
        this.addTexture = addTexture;
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        int a = TextureColoredTexture.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        int c = this.textureData[mipmap][pxCoord];
        int r = TextureColoredTexture.red(c);
        int b = TextureColoredTexture.blue(c);
        int g = TextureColoredTexture.green(c);
        if (!this.stencil) {
            r = TextureColoredTexture.mult(TextureColoredTexture.mult(r, TextureColoredTexture.red(pixel)), TextureColoredTexture.red(pixel));
            g = TextureColoredTexture.mult(TextureColoredTexture.mult(g, TextureColoredTexture.green(pixel)), TextureColoredTexture.green(pixel));
            b = TextureColoredTexture.mult(TextureColoredTexture.mult(b, TextureColoredTexture.blue(pixel)), TextureColoredTexture.blue(pixel));
        }
        return TextureColoredTexture.compose(r, g, b, a);
    }

    protected void loadData() {
        this.textureData = this.addTexture != null && this.addTexture.func_110970_k() > 0 ? this.addTexture.func_147965_a(0) : this.backupLoadTexture(new ResourceLocation(this.addTextureLocation), Minecraft.func_71410_x().func_110442_L());
    }
}

