/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class ToolMaterialStats
extends AbstractMaterialStats {
    public static final String TYPE = "tool";
    public static final String LOC_Durability = "stat.durability.name";
    public static final String LOC_MiningSpeed = "stat.miningspeed.name";
    public static final String LOC_Attack = "stat.attack.name";
    public static final String LOC_Handle = "stat.handle.name";
    public static final String LOC_Extra = "stat.extra.name";
    public static final String LOC_HarvestLevel = "stat.harvestlevel.name";
    public static final String LOC_DurabilityDesc = "stat.durability.desc";
    public static final String LOC_MiningSpeedDesc = "stat.miningspeed.desc";
    public static final String LOC_AttackDesc = "stat.attack.desc";
    public static final String LOC_HandleDesc = "stat.handle.desc";
    public static final String LOC_ExtraDesc = "stat.extra.desc";
    public static final String LOC_HarvestLevelDesc = "stat.harvestlevel.desc";
    private static final DecimalFormat df = new DecimalFormat("#,###,###.##");
    private static final DecimalFormat dfPercent = new DecimalFormat("#%");
    public final int durability;
    public final int harvestLevel;
    public final float attack;
    public final float miningspeed;
    public final float handleQuality;
    public final float extraQuality;

    public ToolMaterialStats(int durability, float miningspeed, float attack, float handleQuality, float extraQuality, int harvestLevel) {
        super(TYPE);
        this.durability = durability;
        this.miningspeed = miningspeed;
        this.attack = attack;
        this.handleQuality = MathHelper.func_76131_a((float)handleQuality, (float)0.0f, (float)1.0f);
        this.extraQuality = MathHelper.func_76131_a((float)extraQuality, (float)0.0f, (float)1.0f);
        this.harvestLevel = harvestLevel;
    }

    @Override
    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolMaterialStats.formatDurability(this.durability));
        info.add(ToolMaterialStats.formatHarvestLevel(this.harvestLevel));
        info.add(ToolMaterialStats.formatMiningSpeed(this.miningspeed));
        info.add(ToolMaterialStats.formatAttack(this.attack));
        info.add(ToolMaterialStats.formatHandle(this.handleQuality));
        info.add(ToolMaterialStats.formatExtra(this.extraQuality));
        return info;
    }

    public static String formatDurability(int durability) {
        return ToolMaterialStats.formatDurability(durability, 1000);
    }

    public static String formatDurability(int durability, int ref) {
        return String.format("%s: %s%s", Util.translate(LOC_Durability, new Object[0]), CustomFontColor.valueToColorCode((float)durability / (float)ref), df.format(durability)) + EnumChatFormatting.RESET;
    }

    public static String formatHarvestLevel(int level) {
        return String.format("%s: %s", Util.translate(LOC_HarvestLevel, new Object[0]), HarvestLevels.getHarvestLevelName(level)) + EnumChatFormatting.RESET;
    }

    public static String formatMiningSpeed(float speed) {
        return String.format("%s: %s%s", Util.translate(LOC_MiningSpeed, new Object[0]), CustomFontColor.valueToColorCode(speed / 10.0f), df.format(speed)) + EnumChatFormatting.RESET;
    }

    public static String formatAttack(float attack) {
        return String.format("%s: %s%s", Util.translate(LOC_Attack, new Object[0]), CustomFontColor.valueToColorCode(attack / 10.0f), df.format(attack)) + EnumChatFormatting.RESET;
    }

    public static String formatHandle(float quality) {
        return String.format("%s: %s%s", Util.translate(LOC_Handle, new Object[0]), CustomFontColor.valueToColorCode(quality), dfPercent.format(quality)) + EnumChatFormatting.RESET;
    }

    public static String formatExtra(float quality) {
        return String.format("%s: %s%s", Util.translate(LOC_Extra, new Object[0]), CustomFontColor.valueToColorCode(quality), dfPercent.format(quality));
    }

    @Override
    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        info.add(Util.translate(LOC_DurabilityDesc, new Object[0]));
        info.add(Util.translate(LOC_HarvestLevelDesc, new Object[0]));
        info.add(Util.translate(LOC_MiningSpeedDesc, new Object[0]));
        info.add(Util.translate(LOC_AttackDesc, new Object[0]));
        info.add(Util.translate(LOC_HandleDesc, new Object[0]));
        info.add(Util.translate(LOC_ExtraDesc, new Object[0]));
        return info;
    }
}

