/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class Modifier
extends RecipeMatchRegistry
implements IModifier {
    public static final String LOC_Name = "modifier.%s.name";
    public static final String LOC_Desc = "modifier.%s.desc";
    public final String identifier;
    protected final List<ModifierAspect> aspects = Lists.newLinkedList();

    public Modifier(String identifier) {
        this.identifier = Util.sanitizeLocalizationString(identifier);
        TinkerRegistry.registerModifier(this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    protected void addAspects(ModifierAspect ... aspects) {
        this.aspects.addAll(Arrays.asList(aspects));
    }

    @Override
    public final boolean canApply(ItemStack stack) throws TinkerGuiException {
        for (ModifierAspect aspect : this.aspects) {
            if (aspect.canApply(stack)) continue;
            return false;
        }
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            String id = modifiers.func_150307_f(i);
            IModifier mod = TinkerRegistry.getModifier(id);
            if (mod == null || this.canApplyTogether(mod)) continue;
            throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_modifiers", this.getLocalizedName(), mod.getLocalizedName()));
        }
        Iterator iterator = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (this.canApplyTogether(Enchantment.func_180306_c((int)id))) continue;
            String enchName = StatCollector.func_74838_a((String)Enchantment.func_180306_c((int)id).func_77320_a());
            throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_enchantments", this.getLocalizedName(), enchName));
        }
        return this.canApplyCustom(stack);
    }

    public boolean canApplyTogether(Enchantment enchantment) {
        return true;
    }

    public boolean canApplyTogether(IModifier otherModifier) {
        return true;
    }

    protected boolean canApplyCustom(ItemStack stack) throws TinkerGuiException {
        return true;
    }

    @Override
    public void updateNBT(NBTTagCompound modifierTag) {
    }

    @Override
    public void apply(ItemStack stack) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        this.apply(root);
        stack.func_77982_d(root);
    }

    @Override
    public void apply(NBTTagCompound root) {
        NBTTagList tagList;
        if (!TinkerUtil.hasModifier(root, this.getIdentifier())) {
            tagList = TagUtil.getBaseModifiersTagList(root);
            tagList.func_74742_a((NBTBase)new NBTTagString(this.getIdentifier()));
            TagUtil.setBaseModifiersTagList(root, tagList);
        }
        NBTTagCompound modifierTag = new NBTTagCompound();
        tagList = TagUtil.getModifiersTagList(root);
        int index = TinkerUtil.getIndexInList(tagList, this.identifier);
        if (index >= 0) {
            modifierTag = tagList.func_150305_b(index);
        }
        for (ModifierAspect aspect : this.aspects) {
            aspect.updateNBT(root, modifierTag);
        }
        this.updateNBT(modifierTag);
        if (!modifierTag.func_82582_d()) {
            ModifierNBT data = ModifierNBT.readTag(modifierTag);
            if (!this.identifier.equals(data.identifier)) {
                data.identifier = this.identifier;
                data.write(modifierTag);
            }
        }
        if (index >= 0) {
            tagList.func_150304_a(index, (NBTBase)modifierTag);
        } else {
            tagList.func_74742_a((NBTBase)modifierTag);
        }
        TagUtil.setModifiersTagList(root, tagList);
        this.applyEffect(root, modifierTag);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        StringBuilder sb = new StringBuilder();
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        sb.append(this.getLocalizedName());
        if (data.level > 1) {
            sb.append(" ");
            sb.append(TinkerUtil.getRomanNumeral(data.level));
        }
        return sb.toString();
    }

    public String getLeveledTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        String basic = this.getLocalizedName();
        if (data.level > 1) {
            basic = basic + " " + TinkerUtil.getRomanNumeral(data.level);
        }
        for (int i = data.level; i > 1; --i) {
            if (!StatCollector.func_94522_b((String)String.format(LOC_Name + i, this.getIdentifier()))) continue;
            basic = StatCollector.func_74838_a((String)String.format(LOC_Name + i, this.getIdentifier()));
            break;
        }
        if (detailed) {
            return basic + " " + data.extraInfo;
        }
        return basic;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate(LOC_Name, this.getIdentifier());
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate(LOC_Desc, this.getIdentifier());
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return false;
    }
}

