/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerAPIException;

public class AlloyRecipe {
    protected final List<FluidStack> fluids;
    protected final FluidStack result;

    public AlloyRecipe(FluidStack result, FluidStack ... input) {
        this.result = result;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FluidStack liquid : input) {
            if (liquid.amount < 1) {
                throw new TinkerAPIException("Invalid Alloy recipe: Fluid amount can't be less than 1");
            }
            builder.add((Object)liquid);
        }
        this.fluids = builder.build();
    }

    public int matches(List<FluidStack> fluids) {
        int times = Integer.MAX_VALUE;
        LinkedList needed = Lists.newLinkedList(fluids);
        block0: for (FluidStack fluid : fluids) {
            ListIterator iter = needed.listIterator();
            while (iter.hasNext()) {
                FluidStack need = (FluidStack)iter.next();
                if (!fluid.containsFluid(need)) continue;
                iter.remove();
                if (fluid.amount / need.amount >= times) continue block0;
                times = fluid.amount / need.amount;
                continue block0;
            }
        }
        return needed.isEmpty() ? times : 0;
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public FluidStack getResult() {
        return this.result;
    }
}

