/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;

public class PartMaterialType {
    private final Set<IToolPart> neededPart = new HashSet<IToolPart>();
    private final String[] neededTypes;

    public PartMaterialType(IToolPart part, String ... statIDs) {
        this.neededPart.add(part);
        this.neededTypes = statIDs;
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof IToolPart)) {
            return false;
        }
        IToolPart toolPart = (IToolPart)stack.func_77973_b();
        return this.isValid(toolPart, toolPart.getMaterial(stack));
    }

    public boolean isValid(IToolPart part, Material material) {
        return this.isValidItem(part) && this.isValidMaterial(material);
    }

    public boolean isValidItem(IToolPart part) {
        return this.neededPart.contains(part);
    }

    public boolean isValidMaterial(Material material) {
        for (String type : this.neededTypes) {
            if (material.hasStats(type)) continue;
            return false;
        }
        return true;
    }

    public Set<IToolPart> getPossibleParts() {
        return ImmutableSet.copyOf(this.neededPart);
    }

    public static class ToolPartType
    extends PartMaterialType {
        public ToolPartType(IToolPart part) {
            super(part, "tool");
        }
    }
}

