/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import gnu.trove.set.hash.THashSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.IModifyable;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.ITinkerable;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.ToolTagUtil;

public abstract class TinkersItem
extends Item
implements ITinkerable,
IModifyable,
IRepairable {
    public final PartMaterialType[] requiredComponents;
    protected final Set<Category> categories = new THashSet();

    public TinkersItem(PartMaterialType ... requiredComponents) {
        this.requiredComponents = requiredComponents;
        this.func_77625_d(1);
    }

    protected void addCategory(Category ... categories) {
        Collections.addAll(this.categories, categories);
    }

    public boolean hasCategory(Category category) {
        return this.categories.contains(category);
    }

    protected Category[] getCategories() {
        Category[] out = new Category[this.categories.size()];
        int i = 0;
        for (Category category : this.categories) {
            out[i++] = category;
        }
        return out;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        IndestructibleEntityItem entity = new IndestructibleEntityItem(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        if (location instanceof EntityItem) {
            NBTTagCompound tag = new NBTTagCompound();
            location.func_70109_d(tag);
            entity.func_174867_a(tag.func_74765_d("PickupDelay"));
        }
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        return entity;
    }

    public boolean validComponent(int slot, ItemStack stack) {
        if (slot > this.requiredComponents.length || slot < 0) {
            return false;
        }
        return this.requiredComponents[slot].isValid(stack);
    }

    public ItemStack buildItemFromStacks(ItemStack[] stacks) {
        ArrayList<Material> materials = new ArrayList<Material>(stacks.length);
        if (stacks.length != this.requiredComponents.length) {
            return null;
        }
        for (int i = 0; i < stacks.length; ++i) {
            if (!this.validComponent(i, stacks[i])) {
                return null;
            }
            materials.add(TinkerUtil.getMaterialFromStack(stacks[i]));
        }
        return this.buildItem(materials);
    }

    public ItemStack buildItem(List<Material> materials) {
        ItemStack tool = new ItemStack((Item)this);
        tool.func_77982_d(this.buildItemNBT(materials));
        return tool;
    }

    public NBTTagCompound buildItemNBT(List<Material> materials) {
        NBTTagCompound basetag = new NBTTagCompound();
        NBTTagCompound toolTag = this.buildTag(materials);
        NBTTagCompound dataTag = this.buildData(materials);
        basetag.func_74782_a("TinkerData", (NBTBase)dataTag);
        basetag.func_74782_a("Stats", (NBTBase)toolTag);
        basetag.func_74782_a("StatsOriginal", toolTag.func_74737_b());
        TagUtil.setCategories(basetag, this.getCategories());
        this.addMaterialTraits(basetag, materials);
        return basetag;
    }

    private NBTTagCompound buildData(List<Material> materials) {
        NBTTagCompound base = new NBTTagCompound();
        NBTTagList materialList = new NBTTagList();
        for (Material material : materials) {
            materialList.func_74742_a((NBTBase)new NBTTagString(material.identifier));
        }
        NBTTagList modifierList = new NBTTagList();
        modifierList.func_74742_a((NBTBase)new NBTTagString());
        modifierList.func_74744_a(0);
        base.func_74782_a("Materials", (NBTBase)materialList);
        base.func_74782_a("Modifiers", (NBTBase)modifierList);
        return base;
    }

    public ItemStack buildItemForRendering(List<Material> materials) {
        ItemStack tool = new ItemStack((Item)this);
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("TinkerData", (NBTBase)this.buildData(materials));
        tool.func_77982_d(base);
        return tool;
    }

    public abstract NBTTagCompound buildTag(List<Material> var1);

    public void addMaterialTraits(NBTTagCompound root, List<Material> materials) {
        for (Material material : materials) {
            for (ITrait trait : material.getAllTraits()) {
                ToolBuilder.addTrait(root, trait, material.materialTextColor);
            }
        }
    }

    public int[] getRepairParts() {
        return new int[]{1};
    }

    @Override
    public ItemStack repair(ItemStack repairable, ItemStack[] repairItems) {
        RecipeMatch.Match match;
        if (repairable.func_77952_i() == 0 && !ToolHelper.isBroken(repairable)) {
            return null;
        }
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(repairable));
        if (materials.isEmpty()) {
            return null;
        }
        ItemStack[] items = Util.copyItemStackArray(repairItems);
        boolean foundMatch = false;
        for (int index : this.getRepairParts()) {
            Material material = materials.get(index);
            match = material.matches(items);
            if (match == null) continue;
            foundMatch = true;
            while ((match = material.matches(items)) != null) {
                RecipeMatch.removeMatch((ItemStack[])items, (RecipeMatch.Match)match);
            }
        }
        if (!foundMatch) {
            return null;
        }
        for (int i = 0; i < repairItems.length; ++i) {
            if (repairItems[i] == null || !ItemStack.func_77989_b((ItemStack)repairItems[i], (ItemStack)items[i])) continue;
            return null;
        }
        ItemStack item = repairable.func_77946_l();
        for (int index : this.getRepairParts()) {
            Material material = materials.get(index);
            while ((match = material.matches(repairItems)) != null && item.func_77952_i() != 0) {
                int amount = this.calculateRepair(item, match.amount, index);
                ToolHelper.repairTool(item, amount);
                NBTTagCompound tag = TagUtil.getExtraTag(item);
                TagUtil.addInteger(tag, "RepairCount", 1);
                TagUtil.setExtraTag(item, tag);
                RecipeMatch.removeMatch((ItemStack[])repairItems, (RecipeMatch.Match)match);
            }
        }
        return item;
    }

    protected int calculateRepair(ItemStack tool, int materialValue, int index) {
        int baseDurability = TagUtil.getOriginalToolStats((ItemStack)tool).durability;
        float increase = 50.0f + (float)baseDurability * 0.4f * (float)materialValue / 144.0f;
        int modifiers = ToolTagUtil.getFreeModifiers(TagUtil.getTagSafe(tool));
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase *= mods;
        NBTTagCompound tag = TagUtil.getExtraTag(tool);
        int repair = tag.func_74762_e("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        return (int)(increase *= repairCount);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        boolean shift = Util.isShiftKeyDown();
        boolean ctrl = Util.isCtrlKeyDown();
        if (!shift && !ctrl) {
            DecimalFormat df = new DecimalFormat("#.##");
            this.getTooltip(stack, tooltip);
            tooltip.add("");
            tooltip.add(Util.translate("tooltip.tool.holdShift", new Object[0]));
            tooltip.add(Util.translate("tooltip.tool.holdCtrl", new Object[0]));
            tooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{df.format(ToolHelper.getActualDamage(stack, playerIn)), StatCollector.func_74838_a((String)"attribute.name.generic.attackDamage")}));
        } else if (Config.extraTooltips && shift) {
            this.getTooltipDetailed(stack, tooltip);
        } else if (Config.extraTooltips && ctrl) {
            this.getTooltipComponents(stack, tooltip);
        }
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        NBTTagList tagList = TagUtil.getModifiersTagList(stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            tooltips.add(data.getColorString() + modifier.getTooltip(tag, false));
        }
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TinkerData")) {
            ToolBuilder.rebuildTool(nbt, this);
        }
        return true;
    }
}

