/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Pattern
extends Item {
    private static final DecimalFormat df = new DecimalFormat("#.##");
    public static final String TAG_PARTTYPE = "PartType";

    public Pattern() {
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack((Item)this));
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!(toolpart instanceof Item)) continue;
            ItemStack stack = new ItemStack((Item)this);
            Pattern.setTagForPart(stack, toolpart);
            subItems.add(stack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        IToolPart part = Pattern.getPartFromTag(stack);
        String unloc = this.func_77657_g(stack);
        if (part == null) {
            return Util.translate(unloc + ".blank", new Object[0]);
        }
        return Util.translateFormatted(unloc + ".name", part.getLocalizedName());
    }

    public static void setTagForPart(ItemStack stack, IToolPart toolPart) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        String id = toolPart.getIdentifier();
        tag.func_74778_a(TAG_PARTTYPE, id);
        stack.func_77982_d(tag);
    }

    public static IToolPart getPartFromTag(ItemStack stack) {
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        String part = tag.func_74779_i(TAG_PARTTYPE);
        for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
            if (!part.equals(toolpart.getIdentifier())) continue;
            return toolpart;
        }
        return null;
    }

    public boolean isBlankPattern(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof Pattern)) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return true;
        }
        return Config.reuseStencil || !stack.func_77978_p().func_74764_b(TAG_PARTTYPE);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        IToolPart part = Pattern.getPartFromTag(stack);
        if (part != null) {
            float cost = (float)part.getCost() / 144.0f;
            tooltip.add(Util.translateFormatted("tooltip.pattern.cost", df.format(cost)));
        }
    }
}

