/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.ToolTagUtil;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.modifiers.traits.ToolGrowth;

public abstract class ToolCore
extends TinkersItem {
    protected static final int DEFAULT_MODIFIERS = 3;
    protected static final ToolGrowth toolGrowth = new ToolGrowth();

    public ToolCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabTools);
        TinkerRegistry.registerTool(this);
        this.addCategory(Category.TOOL);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getDurability(stack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public abstract float damagePotential();

    public float damageCutoff() {
        return 15.0f;
    }

    public int attackSpeed() {
        return 0;
    }

    public float knockback() {
        return 1.0f;
    }

    public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
        return entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
    }

    public void reduceDurabilityOnHit(ItemStack stack, EntityPlayer player, int damage) {
        if (!this.hasCategory(Category.WEAPON)) {
            damage *= 2;
        }
        ToolHelper.damageTool(stack, damage, (EntityLivingBase)player);
    }

    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        if (this.isEffective(state.func_177230_c()) || ToolHelper.isToolEffective(itemstack, state)) {
            return ToolHelper.calcDigSpeed(itemstack, state);
        }
        return super.getDigSpeed(itemstack, state);
    }

    public boolean isEffective(Block block) {
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return this.isEffective(block);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (this instanceof IAoeTool && ((IAoeTool)((Object)this)).isAoeHarvestTool()) {
            for (BlockPos extraPos : ((IAoeTool)((Object)this)).getAOEBlocks(itemstack, player.field_70170_p, player, pos)) {
                ToolHelper.breakExtraBlock(itemstack, player.field_70170_p, player, extraPos, pos);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return ToolHelper.attackEntity(stack, this, player, entity);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.attackSpeed() > 0) {
            int speed = Math.min(5, this.attackSpeed());
            ToolHelper.swingItem(speed, entityLiving);
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean canUseSecondaryItem() {
        return true;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.canUseSecondaryItem()) {
            return ToolHelper.useSecondaryItem(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
        }
        return super.func_180614_a(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.attackSpeed() > 0) {
            target.field_70172_ad -= this.attackSpeed();
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public String[] getInformation(ItemStack stack) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability();
        if (this.hasCategory(Category.HARVEST)) {
            info.addHarvestLevel();
            info.addMiningSpeed();
        }
        if (this.hasCategory(Category.WEAPON)) {
            info.addAttack();
        }
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        return info.getTooltip();
    }

    @Override
    public void getTooltipDetailed(ItemStack stack, List<String> tooltips) {
        tooltips.addAll(Arrays.asList(this.getInformation(stack)));
    }

    @Override
    public void getTooltipComponents(ItemStack stack, List<String> tooltips) {
        tooltips.add("Not implemented :(");
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        for (int index : this.getRepairParts()) {
            if (index >= materials.size()) continue;
            nameMaterials.add(materials.get(index));
        }
        String itemName = super.func_77653_i(stack);
        if (nameMaterials.isEmpty()) {
            return itemName;
        }
        if (nameMaterials.size() == 1) {
            return ((Material)((Object)nameMaterials.iterator().next())).getLocalizedItemName(itemName);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = nameMaterials.iterator();
        Material material = (Material)((Object)iter.next());
        sb.append(material.getLocalizedName());
        while (iter.hasNext()) {
            material = (Material)((Object)iter.next());
            sb.append("-");
            sb.append(material.getLocalizedName());
        }
        sb.append(" ");
        sb.append(itemName);
        return sb.toString();
    }

    @Override
    public void addMaterialTraits(NBTTagCompound root, List<Material> materials) {
        super.addMaterialTraits(root, materials);
        ToolBuilder.addTrait(root, toolGrowth, 0xFFFFFF);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Material head : TinkerRegistry.getAllMaterials()) {
            if (!head.hasStats("tool")) continue;
            ArrayList<Material> mats = new ArrayList<Material>(this.requiredComponents.length);
            for (int i = 0; i < this.requiredComponents.length; ++i) {
                mats.add(head);
            }
            ItemStack tool = this.buildItem(mats);
            subItems.add(tool);
        }
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            return ToolTagUtil.getHarvestLevel(tag);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public String getIdentifier() {
        return Util.getItemLocation(this).func_110623_a();
    }

    public String getLocalizedToolName() {
        return Util.translate(this.func_77658_a() + ".name", new Object[0]);
    }

    public String getLocalizedToolName(Material material) {
        return material.getLocalizedItemName(this.getLocalizedToolName());
    }

    public String getLocalizedDescription() {
        return Util.translate(this.func_77658_a() + ".desc", new Object[0]);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, Block blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean effective = this.isEffective(blockIn) || ToolHelper.isToolEffective(stack, worldIn.func_180495_p(pos));
        int damage = effective ? 1 : 2;
        this.afterBlockBreak(stack, worldIn, blockIn, pos, playerIn, damage, effective);
        return this.hasCategory(Category.TOOL);
    }

    public void afterBlockBreak(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.afterBlockBreak(stack, world, block, pos, player, wasEffective);
        }
        ToolHelper.damageTool(stack, damage, player);
    }

    public MovingObjectPosition func_77621_a(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        return super.func_77621_a(worldIn, playerIn, useLiquids);
    }

    protected void preventSlowDown(Entity entityIn, float originalSpeed) {
        EntityPlayerSP playerSP;
        ItemStack usingItem;
        if (entityIn instanceof EntityPlayerSP && (usingItem = (playerSP = (EntityPlayerSP)entityIn).func_71011_bu()) != null && usingItem.func_77973_b() == this) {
            playerSP.field_71158_b.field_78900_b *= originalSpeed * 5.0f;
            playerSP.field_71158_b.field_78902_a *= originalSpeed * 5.0f;
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    static {
        TinkerRegistry.addTrait(toolGrowth);
    }
}

