/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;

public class ToolNBT {
    public int durability;
    public int harvestLevel;
    public float attack;
    public float speed;
    public int modifiers;

    public ToolNBT() {
    }

    public ToolNBT(ToolMaterialStats stats) {
        this.durability = stats.durability;
        this.harvestLevel = stats.harvestLevel;
        this.attack = stats.attack;
        this.speed = stats.miningspeed;
    }

    public ToolNBT(NBTTagCompound tag) {
        this.read(tag);
    }

    public ToolNBT handle(ToolMaterialStats ... handles) {
        for (ToolMaterialStats stats : handles) {
            this.durability = (int)((float)this.durability + (float)stats.durability * stats.handleQuality);
        }
        return this;
    }

    public ToolNBT extra(ToolMaterialStats ... extras) {
        for (ToolMaterialStats stats : extras) {
            this.durability = (int)((float)this.durability + (float)stats.durability * stats.extraQuality);
        }
        return this;
    }

    public void read(NBTTagCompound tag) {
        this.durability = tag.func_74762_e("Durability");
        this.harvestLevel = tag.func_74762_e("HarvestLevel");
        this.attack = tag.func_74760_g("Attack");
        this.speed = tag.func_74760_g("MiningSpeed");
        this.modifiers = tag.func_74762_e("FreeModifiers");
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("Durability", this.durability);
        tag.func_74768_a("HarvestLevel", this.harvestLevel);
        tag.func_74776_a("Attack", this.attack);
        tag.func_74776_a("MiningSpeed", this.speed);
        tag.func_74768_a("FreeModifiers", this.modifiers);
    }

    public NBTTagCompound get() {
        NBTTagCompound tag = new NBTTagCompound();
        this.write(tag);
        return tag;
    }
}

