/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ToolPart
extends MaterialItem
implements IToolPart {
    protected int cost;

    public ToolPart(int cost) {
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Material mat : TinkerRegistry.getAllMaterials()) {
            if (!this.canUseMaterial(mat)) continue;
            subItems.add(this.getItemstackWithMaterial(mat));
        }
    }

    public boolean canUseMaterial(Material mat) {
        for (ToolCore tool : TinkerRegistry.getTools()) {
            for (PartMaterialType pmt : tool.requiredComponents) {
                if (!pmt.isValid(this, mat)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Material material = this.getMaterial(stack);
        boolean shift = Util.isShiftKeyDown();
        if (!this.checkMissingMaterialTooltip(stack, tooltip)) {
            for (ITrait trait : material.getAllTraits()) {
                if (trait.isHidden()) continue;
                tooltip.add(material.getTextColor() + trait.getLocalizedName());
            }
        }
        if (Config.extraTooltips) {
            if (!shift) {
                tooltip.add(Util.translate("tooltip.tool.holdShift", new Object[0]));
            } else {
                for (IMaterialStats stat : material.getAllStats()) {
                    tooltip.addAll(stat.getLocalizedInfo());
                }
            }
        }
        String materialInfo = StatCollector.func_74837_a((String)"tooltip.part.materialAddedBy", (Object[])new Object[]{TinkerRegistry.getTrace(material)});
        tooltip.add("");
        tooltip.add(materialInfo);
    }

    public String func_77653_i(ItemStack stack) {
        Material material = this.getMaterial(stack);
        String locString = this.func_77658_a() + "." + material.getIdentifier();
        if (StatCollector.func_94522_b((String)locString)) {
            return Util.translate(locString, new Object[0]);
        }
        return material.getLocalizedItemName(super.func_77653_i(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @Override
    public String getLocalizedName() {
        return super.func_77653_i(null);
    }

    @Override
    public String getIdentifier() {
        return Util.getItemLocation(this).func_110623_a();
    }

    static String getIdentifier(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IToolPart) {
            return ((IToolPart)stack.func_77973_b()).getIdentifier();
        }
        return null;
    }

    public boolean checkMissingMaterialTooltip(ItemStack stack, List<String> tooltip) {
        return this.checkMissingMaterialTooltip(stack, tooltip, null);
    }

    public boolean checkMissingMaterialTooltip(ItemStack stack, List<String> tooltip, String statIdentifier) {
        Material material = this.getMaterial(stack);
        if (material == Material.UNKNOWN) {
            NBTTagCompound tag = TagUtil.getTagSafe(stack);
            String materialID = tag.func_74779_i("Material");
            String error = materialID != null && !materialID.isEmpty() ? StatCollector.func_74837_a((String)"tooltip.part.missing_material", (Object[])new Object[]{materialID}) : StatCollector.func_74838_a((String)"tooltip.part.missing_info");
            tooltip.addAll(Util.getTooltips(error));
            return true;
        }
        if (statIdentifier != null && material.getStats(statIdentifier) == null) {
            tooltip.addAll(Util.getTooltips(Util.translateFormatted("tooltip.part.missing_stats", material.getLocalizedName(), statIdentifier)));
            return true;
        }
        return false;
    }
}

