/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TooltipBuilder {
    public static final String LOC_FreeModifiers = "tooltip.tool.modifiers";
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private final List<String> tips = Lists.newLinkedList();
    private final ItemStack stack;

    public TooltipBuilder(ItemStack stack) {
        this.stack = stack;
    }

    public String[] getTooltip() {
        return this.tips.toArray(new String[this.tips.size()]);
    }

    public TooltipBuilder addModifiers() {
        if (this.stack != null) {
            NBTTagList tagList = TagUtil.getModifiersTagList(this.stack);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                ModifierNBT data = ModifierNBT.readTag(tag);
                IModifier modifier = TinkerRegistry.getModifier(data.identifier);
                if (modifier == null || modifier.isHidden()) continue;
                this.tips.add(data.getColorString() + modifier.getTooltip(tag, false));
            }
        }
        return this;
    }

    public TooltipBuilder addDurability() {
        if (this.stack != null) {
            if (ToolHelper.isBroken(this.stack)) {
                this.tips.add(String.format("%s: %s%s%s", Util.translate("stat.durability.name", new Object[0]), EnumChatFormatting.DARK_RED, EnumChatFormatting.BOLD, Util.translate("tooltip.tool.broken", new Object[0])));
            } else {
                this.tips.add(ToolMaterialStats.formatDurability(ToolHelper.getCurrentDurability(this.stack), ToolHelper.getDurability(this.stack)));
            }
        }
        return this;
    }

    public TooltipBuilder addMiningSpeed() {
        if (this.stack != null) {
            this.tips.add(ToolMaterialStats.formatMiningSpeed(ToolHelper.getMiningSpeed(this.stack)));
        }
        return this;
    }

    public TooltipBuilder addHarvestLevel() {
        if (this.stack != null) {
            this.tips.add(ToolMaterialStats.formatHarvestLevel(ToolHelper.getHarvestLevel(this.stack)));
        }
        return this;
    }

    public TooltipBuilder addAttack() {
        if (this.stack != null) {
            float attack = ToolHelper.getActualDamage(this.stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.tips.add(ToolMaterialStats.formatAttack(attack));
        }
        return this;
    }

    public TooltipBuilder addFreeModifiers() {
        if (this.stack != null) {
            this.tips.add(String.format("%s: %d", StatCollector.func_74838_a((String)LOC_FreeModifiers), ToolHelper.getFreeModifiers(this.stack)));
        }
        return this;
    }

    public TooltipBuilder addCustom(String custom) {
        if (this.stack != null) {
            this.tips.add(custom);
        }
        return this;
    }
}

